/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import soot.G;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.baf.BafBody;
import soot.dava.toolkits.base.misc.PackageNamer;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.util.Chain;
import soot.util.HashChain;
import soot.util.Numberable;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SootClass
extends AbstractHost
implements Numberable {
    protected String name;
    protected String shortName;
    protected String fixedShortName;
    protected String packageName;
    protected String fixedPackageName;
    protected int modifiers;
    protected Chain<SootField> fields = new HashChain<SootField>();
    protected SmallNumberedMap subSigToMethods = new SmallNumberedMap(Scene.v().getSubSigNumberer());
    protected List<SootMethod> methodList = new ArrayList<SootMethod>();
    protected Chain<SootClass> interfaces = new HashChain<SootClass>();
    protected boolean isInScene;
    protected SootClass superClass;
    protected SootClass outerClass;
    protected boolean isPhantom;
    private Vector additionalMethods = null;
    public static final int DANGLING = 0;
    public static final int HIERARCHY = 1;
    public static final int SIGNATURES = 2;
    public static final int BODIES = 3;
    private int resolvingLevel = 0;
    private RefType refType;
    private int number = 0;

    public void addAdditionalMethods() {
        if (this.additionalMethods != null) {
            for (int i = 0; i < this.additionalMethods.size(); ++i) {
                SootMethod sootMethod = (SootMethod)this.additionalMethods.get(i);
                this.addMethod(sootMethod);
            }
        }
    }

    public void addAdditionalMethod(SootMethod additionalMethod) {
        if (this.additionalMethods == null) {
            this.additionalMethods = new Vector();
        }
        this.additionalMethods.add(additionalMethod);
    }

    public SootClass(String name, int modifiers) {
        if (name.charAt(0) == '[') {
            throw new RuntimeException("Attempt to make a class whose name starts with [");
        }
        this.setName(name);
        this.modifiers = modifiers;
        this.refType = RefType.v(name);
        this.refType.setSootClass(this);
        if (Options.v().debug_resolver()) {
            G.v().out.println("created " + name + " with modifiers " + modifiers);
        }
        this.setResolvingLevel(3);
    }

    public SootClass(String name) {
        this(name, 0);
    }

    private String levelToString(int level) {
        switch (level) {
            case 0: {
                return "DANGLING";
            }
            case 1: {
                return "HIERARCHY";
            }
            case 2: {
                return "SIGNATURES";
            }
            case 3: {
                return "BODIES";
            }
        }
        throw new RuntimeException("unknown resolving level");
    }

    public void checkLevel(int level) {
        if (!Scene.v().doneResolving()) {
            return;
        }
        if (this.resolvingLevel < level) {
            String string = "\nIf you are extending Soot, try to add the following call before calling soot.Main.main(..):\nScene.v().addBasicClass(" + this.getName() + "," + this.levelToString(level) + ");\n" + "Otherwise, try whole-program mode (-w).";
        }
    }

    public int resolvingLevel() {
        return this.resolvingLevel;
    }

    public void setResolvingLevel(int newLevel) {
        this.resolvingLevel = newLevel;
    }

    public boolean isInScene() {
        return this.isInScene;
    }

    public void setInScene(boolean isInScene) {
        this.isInScene = isInScene;
    }

    public int getFieldCount() {
        this.checkLevel(2);
        return this.fields.size();
    }

    public Chain<SootField> getFields() {
        this.checkLevel(2);
        return this.fields;
    }

    public void addField(SootField f) {
        this.checkLevel(2);
        if (f.isDeclared()) {
            throw new RuntimeException("already declared: " + f.getName());
        }
        if (this.declaresField(f.getName())) {
            throw new RuntimeException("Field already exists : " + f.getName());
        }
        this.fields.add(f);
        f.isDeclared = true;
        f.declaringClass = this;
    }

    public void removeField(SootField f) {
        this.checkLevel(2);
        if (!f.isDeclared() || f.getDeclaringClass() != this) {
            throw new RuntimeException("did not declare: " + f.getName());
        }
        this.fields.remove(f);
        f.isDeclared = false;
    }

    public SootField getField(String name, Type type) {
        this.checkLevel(2);
        for (SootField field : this.getFields()) {
            if (!field.name.equals(name) || !field.type.equals(type)) continue;
            return field;
        }
        throw new RuntimeException("No field " + name + " in class " + this.getName());
    }

    public SootField getFieldFromCH(String name, Type type) {
        this.checkLevel(2);
        for (SootField field : this.getFields()) {
            if (!field.name.equals(name) || !field.type.equals(type)) continue;
            return field;
        }
        if (this.hasSuperclass()) {
            return this.getSuperclass().getFieldFromCH(name, type);
        }
        throw new RuntimeException("Class " + this.getName() + " doesn't have field " + name + " type:" + type);
    }

    public SootField getFieldByName(String name) {
        this.checkLevel(2);
        boolean found = false;
        SootField foundField = null;
        for (SootField field : this.getFields()) {
            if (!field.name.equals(name)) continue;
            if (found) {
                throw new RuntimeException("ambiguous field: " + name);
            }
            found = true;
            foundField = field;
        }
        if (found) {
            return foundField;
        }
        throw new RuntimeException("No field " + name + " in class " + this.getName());
    }

    public SootField getField(String subsignature) {
        this.checkLevel(2);
        for (SootField field : this.getFields()) {
            if (!field.getSubSignature().equals(subsignature)) continue;
            return field;
        }
        throw new RuntimeException("No field " + subsignature + " in class " + this.getName());
    }

    public boolean declaresField(String subsignature) {
        this.checkLevel(2);
        for (SootField field : this.getFields()) {
            if (!field.getSubSignature().equals(subsignature)) continue;
            return true;
        }
        return false;
    }

    public SootMethod getMethod(NumberedString subsignature) {
        this.checkLevel(2);
        SootMethod ret = (SootMethod)this.subSigToMethods.get(subsignature);
        if (ret == null) {
            throw new RuntimeException("No method " + subsignature + " in class " + this.getName());
        }
        return ret;
    }

    public boolean declaresMethod(NumberedString subsignature) {
        this.checkLevel(2);
        SootMethod ret = (SootMethod)this.subSigToMethods.get(subsignature);
        return ret != null;
    }

    public SootMethod getMethod(String subsignature) {
        this.checkLevel(2);
        return this.getMethod(Scene.v().getSubSigNumberer().findOrAdd(subsignature));
    }

    public boolean declaresMethod(String subsignature) {
        this.checkLevel(2);
        return this.declaresMethod(Scene.v().getSubSigNumberer().findOrAdd(subsignature));
    }

    public boolean declaresFieldByName(String name) {
        this.checkLevel(2);
        for (SootField field : this.getFields()) {
            if (!field.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresField(String name, Type type) {
        this.checkLevel(2);
        for (SootField field : this.getFields()) {
            if (!field.name.equals(name) || !field.type.equals(type)) continue;
            return true;
        }
        return false;
    }

    public int getMethodCount() {
        this.checkLevel(2);
        return this.subSigToMethods.nonNullSize();
    }

    public Iterator<SootMethod> methodIterator() {
        this.checkLevel(2);
        return this.methodList.iterator();
    }

    public Iterator<SootMethod> snapMethodIter() {
        this.checkLevel(2);
        ArrayList<SootMethod> methods = new ArrayList<SootMethod>();
        methods.addAll(this.methodList);
        return methods.iterator();
    }

    public List<SootMethod> getMethods() {
        this.checkLevel(2);
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        Iterator<SootMethod> it = this.methodIterator();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public SootMethod getMethod(String name, List parameterTypes, Type returnType) {
        this.checkLevel(2);
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name) || !((Object)parameterTypes).equals(method.getParameterTypes()) || !returnType.equals(method.getReturnType())) continue;
            return method;
        }
        throw new RuntimeException("Class " + this.getName() + " doesn't have method " + name + "(" + parameterTypes + ")" + " : " + returnType);
    }

    public SootMethod getMethodFromCH(String name, List parameterTypes, Type returnType) {
        this.checkLevel(2);
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name) || !((Object)parameterTypes).equals(method.getParameterTypes()) || !returnType.equals(method.getReturnType())) continue;
            return method;
        }
        if (this.hasSuperclass()) {
            return this.getSuperclass().getMethodFromCH(name, parameterTypes, returnType);
        }
        throw new RuntimeException("Class " + this.getName() + " doesn't have method " + name + "(" + parameterTypes + ") : " + returnType);
    }

    public SootMethod getMethod(String name, List parameterTypes) {
        this.checkLevel(2);
        boolean found = false;
        SootMethod foundMethod = null;
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name) || !((Object)parameterTypes).equals(method.getParameterTypes())) continue;
            if (found) {
                throw new RuntimeException("ambiguous method");
            }
            found = true;
            foundMethod = method;
        }
        if (found) {
            return foundMethod;
        }
        throw new RuntimeException("couldn't find method " + name + "(" + parameterTypes + ") in " + this);
    }

    public SootMethod getMethodByName(String name) {
        this.checkLevel(2);
        boolean found = false;
        SootMethod foundMethod = null;
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name)) continue;
            if (found) {
                throw new RuntimeException("ambiguous method");
            }
            found = true;
            foundMethod = method;
        }
        if (found) {
            return foundMethod;
        }
        throw new RuntimeException("couldn't find method " + name + "(*) in " + this);
    }

    public boolean declaresMethod(String name, List parameterTypes) {
        this.checkLevel(2);
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name) || !((Object)method.getParameterTypes()).equals(parameterTypes)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresMethod(String name, List parameterTypes, Type returnType) {
        this.checkLevel(2);
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name) || !((Object)method.getParameterTypes()).equals(parameterTypes) || !method.getReturnType().equals(returnType)) continue;
            return true;
        }
        return false;
    }

    public boolean declaresMethodByName(String name) {
        this.checkLevel(2);
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod method = methodIt.next();
            if (!method.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addMethod(SootMethod m) {
        this.checkLevel(2);
        if (m.isDeclared()) {
            throw new RuntimeException("already declared: " + m.getName());
        }
        if (this.subSigToMethods.get(m.getNumberedSubSignature()) != null) {
            throw new RuntimeException("Attempting to add method " + m.getSubSignature() + " to class " + this + ", but the class already has a method with that signature.");
        }
        this.subSigToMethods.put(m.getNumberedSubSignature(), m);
        this.methodList.add(m);
        m.isDeclared = true;
        m.declaringClass = this;
    }

    public void removeMethod(SootMethod m) {
        this.checkLevel(2);
        if (!m.isDeclared() || m.getDeclaringClass() != this) {
            throw new RuntimeException("incorrect declarer for remove: " + m.getName());
        }
        if (this.subSigToMethods.get(m.getNumberedSubSignature()) == null) {
            throw new RuntimeException("Attempt to remove method " + m.getSubSignature() + " which is not in class " + this);
        }
        this.subSigToMethods.put(m.getNumberedSubSignature(), null);
        this.methodList.remove(m);
        m.isDeclared = false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getInterfaceCount() {
        this.checkLevel(1);
        return this.interfaces.size();
    }

    public Chain<SootClass> getInterfaces() {
        this.checkLevel(1);
        return this.interfaces;
    }

    public boolean implementsInterface(String name) {
        this.checkLevel(1);
        for (SootClass SootClass2 : this.getInterfaces()) {
            if (!SootClass2.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addInterface(SootClass interfaceClass) {
        this.checkLevel(1);
        if (this.implementsInterface(interfaceClass.getName())) {
            throw new RuntimeException("duplicate interface: " + interfaceClass.getName());
        }
        this.interfaces.add(interfaceClass);
    }

    public void removeInterface(SootClass interfaceClass) {
        this.checkLevel(1);
        if (!this.implementsInterface(interfaceClass.getName())) {
            throw new RuntimeException("no such interface: " + interfaceClass.getName());
        }
        this.interfaces.remove(interfaceClass);
    }

    public boolean hasSuperclass() {
        this.checkLevel(1);
        return this.superClass != null;
    }

    public SootClass getSuperclass() {
        this.checkLevel(1);
        if (this.superClass == null) {
            throw new RuntimeException("no superclass for " + this.getName());
        }
        return this.superClass;
    }

    public void setSuperclass(SootClass c) {
        this.checkLevel(1);
        this.superClass = c;
    }

    public boolean hasOuterClass() {
        this.checkLevel(1);
        return this.outerClass != null;
    }

    public SootClass getOuterClass() {
        this.checkLevel(1);
        if (this.outerClass == null) {
            throw new RuntimeException("no outer class");
        }
        return this.outerClass;
    }

    public void setOuterClass(SootClass c) {
        this.checkLevel(1);
        this.outerClass = c;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaStyleName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedShortName == null) {
                this.fixedShortName = PackageNamer.v().get_FixedClassName(this.name);
            }
            if (!PackageNamer.v().use_ShortName(this.getJavaPackageName(), this.fixedShortName)) {
                return this.getJavaPackageName() + "." + this.fixedShortName;
            }
            return this.fixedShortName;
        }
        return this.shortName;
    }

    public String getShortJavaStyleName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedShortName == null) {
                this.fixedShortName = PackageNamer.v().get_FixedClassName(this.name);
            }
            return this.fixedShortName;
        }
        return this.shortName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getJavaPackageName() {
        if (PackageNamer.v().has_FixedNames()) {
            if (this.fixedPackageName == null) {
                this.fixedPackageName = PackageNamer.v().get_FixedPackageName(this.packageName);
            }
            return this.fixedPackageName;
        }
        return this.packageName;
    }

    public void setName(String name) {
        this.name = name;
        this.shortName = name;
        this.packageName = "";
        int index = name.lastIndexOf(46);
        if (index > 0) {
            this.shortName = name.substring(index + 1);
            this.packageName = name.substring(0, index);
        }
        this.fixedShortName = null;
        this.fixedPackageName = null;
    }

    public boolean isInterface() {
        this.checkLevel(1);
        return Modifier.isInterface(this.getModifiers());
    }

    public boolean isConcrete() {
        return !this.isInterface() && !this.isAbstract();
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean containsBafBody() {
        Iterator<SootMethod> methodIt = this.methodIterator();
        while (methodIt.hasNext()) {
            SootMethod m = methodIt.next();
            if (!m.hasActiveBody() || !(m.getActiveBody() instanceof BafBody)) continue;
            return true;
        }
        return false;
    }

    public void setRefType(RefType refType) {
        this.refType = refType;
    }

    public boolean hasRefType() {
        return this.refType != null;
    }

    public RefType getType() {
        return this.refType;
    }

    public String toString() {
        return this.getName();
    }

    public void renameFieldsAndMethods(boolean privateOnly) {
        this.checkLevel(2);
        Iterator<SootField> fieldIt = this.getFields().iterator();
        int fieldCount = 0;
        if (fieldIt.hasNext()) {
            while (fieldIt.hasNext()) {
                SootField f = fieldIt.next();
                if (privateOnly && !Modifier.isPrivate(f.getModifiers())) continue;
                String newFieldName = "__field" + fieldCount++;
                f.setName(newFieldName);
            }
        }
        Iterator<SootMethod> methodIt = this.methodIterator();
        int methodCount = 0;
        if (methodIt.hasNext()) {
            while (methodIt.hasNext()) {
                SootMethod m = methodIt.next();
                if (privateOnly && !Modifier.isPrivate(m.getModifiers())) continue;
                String newMethodName = "__method" + methodCount++;
                m.setName(newMethodName);
            }
        }
    }

    public boolean isApplicationClass() {
        return Scene.v().getApplicationClasses().contains(this);
    }

    public void setApplicationClass() {
        Chain<SootClass> c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Chain<SootClass> applicationClasses = Scene.v().getApplicationClasses();
        Iterator<SootClass> it = applicationClasses.iterator();
        while (it.hasNext()) {
            SootClass appliClass = it.next();
            if (!appliClass.name.equals(this.shortName) || !appliClass.refType.equals(this.refType)) continue;
            it.remove();
        }
        Scene.v().getApplicationClasses().add(this);
        this.isPhantom = false;
    }

    public boolean isLibraryClass() {
        return Scene.v().getLibraryClasses().contains(this);
    }

    public void setLibraryClass() {
        Chain<SootClass> c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getLibraryClasses().add(this);
        this.isPhantom = false;
    }

    public boolean isPhantomClass() {
        return Scene.v().getPhantomClasses().contains(this);
    }

    public void setPhantomClass() {
        Chain<SootClass> c = Scene.v().getContainingChain(this);
        if (c != null) {
            c.remove(this);
        }
        Scene.v().getPhantomClasses().add(this);
        this.isPhantom = true;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public void setPhantom(boolean value) {
        if (!value) {
            if (this.isPhantom) {
                throw new RuntimeException("don't know how to de-phantomize this class");
            }
            return;
        }
        this.setPhantomClass();
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final void setNumber(int number) {
        this.number = number;
    }
}

