/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.UnknownType;
import soot.VoidType;
import soot.coffi.AnnotationDefault_attribute;
import soot.coffi.CONSTANT_Class_info;
import soot.coffi.CONSTANT_Double_info;
import soot.coffi.CONSTANT_Fieldref_info;
import soot.coffi.CONSTANT_Float_info;
import soot.coffi.CONSTANT_Integer_info;
import soot.coffi.CONSTANT_InterfaceMethodref_info;
import soot.coffi.CONSTANT_Long_info;
import soot.coffi.CONSTANT_Methodref_info;
import soot.coffi.CONSTANT_NameAndType_info;
import soot.coffi.CONSTANT_String_info;
import soot.coffi.CONSTANT_Utf8_info;
import soot.coffi.ClassFile;
import soot.coffi.CoffiMethodSource;
import soot.coffi.ConstantValue_attribute;
import soot.coffi.Deprecated_attribute;
import soot.coffi.Double2ndHalfType;
import soot.coffi.EnclosingMethod_attribute;
import soot.coffi.Exception_attribute;
import soot.coffi.InnerClasses_attribute;
import soot.coffi.LocalVariableTable_attribute;
import soot.coffi.LocalVariableTypeTable_attribute;
import soot.coffi.Long2ndHalfType;
import soot.coffi.RuntimeInvisibleAnnotations_attribute;
import soot.coffi.RuntimeInvisibleParameterAnnotations_attribute;
import soot.coffi.RuntimeVisibleAnnotations_attribute;
import soot.coffi.RuntimeVisibleParameterAnnotations_attribute;
import soot.coffi.Signature_attribute;
import soot.coffi.SourceFile_attribute;
import soot.coffi.Synthetic_attribute;
import soot.coffi.TypeStack;
import soot.coffi.annotation;
import soot.coffi.annotation_element_value;
import soot.coffi.array_element_value;
import soot.coffi.attribute_info;
import soot.coffi.class_element_value;
import soot.coffi.constant_element_value;
import soot.coffi.cp_info;
import soot.coffi.element_value;
import soot.coffi.enum_constant_element_value;
import soot.coffi.field_info;
import soot.coffi.inner_class_entry;
import soot.coffi.method_info;
import soot.coffi.parameter_annotation;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NoSuchLocalException;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DeprecatedTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.Host;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.SyntheticTag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    Map classNameToAbbreviation;
    Set markedClasses;
    LinkedList classesToResolve;
    int activeOriginalIndex = -1;
    cp_info[] activeConstantPool = null;
    LocalVariableTable_attribute activeVariableTable;
    LocalVariableTypeTable_attribute activeVariableTypeTable;
    boolean useFaithfulNaming = false;
    boolean isLocalStore = false;
    boolean isWideLocalStore = false;
    private final ArrayList<Type> conversionTypes = new ArrayList();
    private final Map<String, Type[]> cache = new HashMap<String, Type[]>();
    int nextEasyNameIndex;

    public Util(Singletons.Global g) {
    }

    public static Util v() {
        return G.v().soot_coffi_Util();
    }

    public void setFaithfulNaming(boolean v) {
        this.useFaithfulNaming = v;
    }

    public void resolveFromClassFile(SootClass aClass, InputStream is, List references) {
        method_info methodInfo;
        int i;
        SootClass bclass = aClass;
        String className = bclass.getName();
        ClassFile coffiClass = new ClassFile(className);
        boolean success = coffiClass.loadClassFile(is);
        if (!success) {
            if (!Scene.v().allowsPhantomRefs()) {
                throw new RuntimeException("Could not load classfile: " + bclass.getName());
            }
            G.v().out.println("Warning: " + className + " is a phantom class!");
            bclass.setPhantom(true);
            return;
        }
        CONSTANT_Class_info c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.this_class];
        String name = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
        if (!(name = name.replace('/', '.')).equals(bclass.getName())) {
            throw new RuntimeException("Error: class " + name + " read in from a classfile in which " + bclass.getName() + " was expected.");
        }
        bclass.setModifiers(coffiClass.access_flags & 0xFFFFFFDF);
        if (coffiClass.super_class != 0) {
            CONSTANT_Class_info c2 = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.super_class];
            String superName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c2.name_index]).convert();
            superName = superName.replace('/', '.');
            references.add(superName);
            bclass.setSuperclass(SootResolver.v().makeClassRef(superName));
        }
        for (i = 0; i < coffiClass.interfaces_count; ++i) {
            c = (CONSTANT_Class_info)coffiClass.constant_pool[coffiClass.interfaces[i]];
            String interfaceName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c.name_index]).convert();
            interfaceName = interfaceName.replace('/', '.');
            references.add(interfaceName);
            SootClass interfaceClass = SootResolver.v().makeClassRef(interfaceName);
            bclass.addInterface(interfaceClass);
        }
        for (i = 0; i < coffiClass.fields_count; ++i) {
            field_info fieldInfo = coffiClass.fields[i];
            String fieldName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.name_index]).convert();
            String fieldDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[fieldInfo.descriptor_index]).convert();
            int modifiers = fieldInfo.access_flags;
            Type fieldType = this.jimpleTypeOfFieldDescriptor(fieldDescriptor);
            SootField field = new SootField(fieldName, fieldType, modifiers);
            bclass.addField(field);
            references.add(fieldType);
            for (int j = 0; j < fieldInfo.attributes_count; ++j) {
                if (fieldInfo.attributes[j] instanceof ConstantValue_attribute) {
                    ConstantValueTag tag;
                    ConstantValue_attribute attr = (ConstantValue_attribute)fieldInfo.attributes[j];
                    cp_info cval = coffiClass.constant_pool[attr.constantvalue_index];
                    switch (cval.tag) {
                        case 3: {
                            tag = new IntegerConstantValueTag((int)((CONSTANT_Integer_info)cval).bytes);
                            break;
                        }
                        case 4: {
                            tag = new FloatConstantValueTag(((CONSTANT_Float_info)cval).convert());
                            break;
                        }
                        case 5: {
                            CONSTANT_Long_info lcval = (CONSTANT_Long_info)cval;
                            tag = new LongConstantValueTag((lcval.high << 32) + lcval.low);
                            break;
                        }
                        case 6: {
                            CONSTANT_Double_info dcval = (CONSTANT_Double_info)cval;
                            tag = new DoubleConstantValueTag(dcval.convert());
                            break;
                        }
                        case 8: {
                            CONSTANT_String_info scval = (CONSTANT_String_info)cval;
                            CONSTANT_Utf8_info ucval = (CONSTANT_Utf8_info)coffiClass.constant_pool[scval.string_index];
                            tag = new StringConstantValueTag(ucval.convert());
                            break;
                        }
                        default: {
                            throw new RuntimeException("unexpected ConstantValue: " + cval);
                        }
                    }
                    field.addTag(tag);
                    continue;
                }
                if (fieldInfo.attributes[j] instanceof Synthetic_attribute) {
                    field.addTag(new SyntheticTag());
                    continue;
                }
                if (fieldInfo.attributes[j] instanceof Deprecated_attribute) {
                    field.addTag(new DeprecatedTag());
                    continue;
                }
                if (fieldInfo.attributes[j] instanceof Signature_attribute) {
                    String generic_sig = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((Signature_attribute)fieldInfo.attributes[j]).signature_index]).convert();
                    field.addTag(new SignatureTag(generic_sig));
                    continue;
                }
                if (!(fieldInfo.attributes[j] instanceof RuntimeVisibleAnnotations_attribute) && !(fieldInfo.attributes[j] instanceof RuntimeInvisibleAnnotations_attribute)) continue;
                this.addAnnotationVisibilityAttribute(field, fieldInfo.attributes[j], coffiClass, references);
            }
        }
        for (i = 0; i < coffiClass.methods_count; ++i) {
            methodInfo = coffiClass.methods[i];
            if (coffiClass.constant_pool[methodInfo.name_index] == null) {
                G.v().out.println("method index: " + methodInfo.toName(coffiClass.constant_pool));
                throw new RuntimeException("method has no name");
            }
            String methodName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.name_index]).convert();
            String methodDescriptor = ((CONSTANT_Utf8_info)coffiClass.constant_pool[methodInfo.descriptor_index]).convert();
            Type[] types = this.jimpleTypesOfFieldOrMethodDescriptor(methodDescriptor);
            ArrayList<Type> parameterTypes = new ArrayList<Type>();
            for (int j = 0; j < types.length - 1; ++j) {
                references.add(types[j]);
                parameterTypes.add(types[j]);
            }
            Type returnType = types[types.length - 1];
            references.add(returnType);
            int modifiers = methodInfo.access_flags;
            SootMethod method = new SootMethod(methodName, parameterTypes, returnType, modifiers);
            bclass.addMethod(method);
            methodInfo.jmethod = method;
            for (int j = 0; j < methodInfo.attributes_count; ++j) {
                if (methodInfo.attributes[j] instanceof Exception_attribute) {
                    Exception_attribute exceptions = (Exception_attribute)methodInfo.attributes[j];
                    for (int k = 0; k < exceptions.number_of_exceptions; ++k) {
                        CONSTANT_Class_info c3 = (CONSTANT_Class_info)coffiClass.constant_pool[exceptions.exception_index_table[k]];
                        String exceptionName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c3.name_index]).convert();
                        exceptionName = exceptionName.replace('/', '.');
                        references.add(exceptionName);
                        method.addExceptionIfAbsent(SootResolver.v().makeClassRef(exceptionName));
                    }
                    continue;
                }
                if (methodInfo.attributes[j] instanceof Synthetic_attribute) {
                    method.addTag(new SyntheticTag());
                    continue;
                }
                if (methodInfo.attributes[j] instanceof Deprecated_attribute) {
                    method.addTag(new DeprecatedTag());
                    continue;
                }
                if (methodInfo.attributes[j] instanceof Signature_attribute) {
                    String generic_sig = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((Signature_attribute)methodInfo.attributes[j]).signature_index]).convert();
                    method.addTag(new SignatureTag(generic_sig));
                    continue;
                }
                if (methodInfo.attributes[j] instanceof RuntimeVisibleAnnotations_attribute || methodInfo.attributes[j] instanceof RuntimeInvisibleAnnotations_attribute) {
                    this.addAnnotationVisibilityAttribute(method, methodInfo.attributes[j], coffiClass, references);
                    continue;
                }
                if (methodInfo.attributes[j] instanceof RuntimeVisibleParameterAnnotations_attribute || methodInfo.attributes[j] instanceof RuntimeInvisibleParameterAnnotations_attribute) {
                    this.addAnnotationVisibilityParameterAttribute(method, methodInfo.attributes[j], coffiClass, references);
                    continue;
                }
                if (!(methodInfo.attributes[j] instanceof AnnotationDefault_attribute)) continue;
                AnnotationDefault_attribute attr = (AnnotationDefault_attribute)methodInfo.attributes[j];
                element_value[] input = new element_value[]{attr.default_value};
                ArrayList<AnnotationElem> list = this.createElementTags(1, coffiClass, input);
                method.addTag(new AnnotationDefaultTag(list.get(0)));
            }
            for (int k = 0; k < coffiClass.constant_pool_count; ++k) {
                Type[] types2;
                if (coffiClass.constant_pool[k] instanceof CONSTANT_Class_info) {
                    CONSTANT_Class_info c4 = (CONSTANT_Class_info)coffiClass.constant_pool[k];
                    String desc = ((CONSTANT_Utf8_info)coffiClass.constant_pool[c4.name_index]).convert();
                    String name2 = desc.replace('/', '.');
                    if (name2.startsWith("[")) {
                        references.add(this.jimpleTypeOfFieldDescriptor(desc));
                    } else {
                        references.add(name2);
                    }
                }
                if (!(coffiClass.constant_pool[k] instanceof CONSTANT_Fieldref_info) && !(coffiClass.constant_pool[k] instanceof CONSTANT_Methodref_info) && !(coffiClass.constant_pool[k] instanceof CONSTANT_InterfaceMethodref_info)) continue;
                for (Type element : types2 = this.jimpleTypesOfFieldOrMethodDescriptor(cp_info.getTypeDescr(coffiClass.constant_pool, k))) {
                    references.add(element);
                }
            }
        }
        for (i = 0; i < coffiClass.methods_count; ++i) {
            methodInfo = coffiClass.methods[i];
            methodInfo.jmethod.setSource(new CoffiMethodSource(coffiClass, methodInfo));
        }
        for (i = 0; i < coffiClass.attributes_count; ++i) {
            attribute_info attr;
            if (coffiClass.attributes[i] instanceof SourceFile_attribute) {
                attr = (SourceFile_attribute)coffiClass.attributes[i];
                String sourceFile = ((CONSTANT_Utf8_info)coffiClass.constant_pool[attr.sourcefile_index]).convert();
                if (sourceFile.indexOf(32) >= 0) {
                    G.v().out.println("Warning: Class " + className + " has invalid SourceFile attribute (will be ignored).");
                    continue;
                }
                bclass.addTag(new SourceFileTag(sourceFile));
                continue;
            }
            if (coffiClass.attributes[i] instanceof InnerClasses_attribute) {
                attr = (InnerClasses_attribute)coffiClass.attributes[i];
                for (int j = 0; j < ((InnerClasses_attribute)attr).inner_classes_length; ++j) {
                    inner_class_entry e = ((InnerClasses_attribute)attr).inner_classes[j];
                    String inner = null;
                    String outer = null;
                    String name3 = null;
                    if (e.inner_class_index != 0) {
                        inner = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((CONSTANT_Class_info)coffiClass.constant_pool[e.inner_class_index]).name_index]).convert();
                    }
                    if (e.outer_class_index != 0) {
                        outer = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((CONSTANT_Class_info)coffiClass.constant_pool[e.outer_class_index]).name_index]).convert();
                    }
                    if (e.name_index != 0) {
                        name3 = ((CONSTANT_Utf8_info)coffiClass.constant_pool[e.name_index]).convert();
                    }
                    bclass.addTag(new InnerClassTag(inner, outer, name3, e.access_flags));
                }
                continue;
            }
            if (coffiClass.attributes[i] instanceof Synthetic_attribute) {
                bclass.addTag(new SyntheticTag());
                continue;
            }
            if (coffiClass.attributes[i] instanceof Deprecated_attribute) {
                bclass.addTag(new DeprecatedTag());
                continue;
            }
            if (coffiClass.attributes[i] instanceof Signature_attribute) {
                String generic_sig = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((Signature_attribute)coffiClass.attributes[i]).signature_index]).convert();
                bclass.addTag(new SignatureTag(generic_sig));
                continue;
            }
            if (coffiClass.attributes[i] instanceof EnclosingMethod_attribute) {
                attr = (EnclosingMethod_attribute)coffiClass.attributes[i];
                String class_name = ((CONSTANT_Utf8_info)coffiClass.constant_pool[((CONSTANT_Class_info)coffiClass.constant_pool[((EnclosingMethod_attribute)attr).class_index]).name_index]).convert();
                CONSTANT_NameAndType_info info = (CONSTANT_NameAndType_info)coffiClass.constant_pool[((EnclosingMethod_attribute)attr).method_index];
                String method_name = "";
                String method_sig = "";
                if (info != null) {
                    method_name = ((CONSTANT_Utf8_info)coffiClass.constant_pool[info.name_index]).convert();
                    method_sig = ((CONSTANT_Utf8_info)coffiClass.constant_pool[info.descriptor_index]).convert();
                }
                bclass.addTag(new EnclosingMethodTag(class_name, method_name, method_sig));
                continue;
            }
            if (!(coffiClass.attributes[i] instanceof RuntimeVisibleAnnotations_attribute) && !(coffiClass.attributes[i] instanceof RuntimeInvisibleAnnotations_attribute)) continue;
            this.addAnnotationVisibilityAttribute(bclass, coffiClass.attributes[i], coffiClass, references);
        }
    }

    Type jimpleReturnTypeOfMethodDescriptor(String descriptor) {
        Type[] types = this.jimpleTypesOfFieldOrMethodDescriptor(descriptor);
        return types[types.length - 1];
    }

    public Type[] jimpleTypesOfFieldOrMethodDescriptor(String descriptor) {
        Type[] ret = this.cache.get(descriptor);
        if (ret != null) {
            return ret;
        }
        char[] d = descriptor.toCharArray();
        int p = 0;
        this.conversionTypes.clear();
        block14: while (p < d.length) {
            boolean isArray = false;
            int numDimensions = 0;
            Type baseType = null;
            block15: while (p < d.length) {
                switch (d[p]) {
                    case '(': 
                    case ')': {
                        ++p;
                        continue block14;
                    }
                    case '[': {
                        isArray = true;
                        ++numDimensions;
                        ++p;
                        continue block15;
                    }
                    case 'B': {
                        baseType = ByteType.v();
                        ++p;
                        break block15;
                    }
                    case 'C': {
                        baseType = CharType.v();
                        ++p;
                        break block15;
                    }
                    case 'D': {
                        baseType = DoubleType.v();
                        ++p;
                        break block15;
                    }
                    case 'F': {
                        baseType = FloatType.v();
                        ++p;
                        break block15;
                    }
                    case 'I': {
                        baseType = IntType.v();
                        ++p;
                        break block15;
                    }
                    case 'J': {
                        baseType = LongType.v();
                        ++p;
                        break block15;
                    }
                    case 'L': {
                        int index;
                        for (index = p + 1; index < d.length && d[index] != ';'; ++index) {
                            if (d[index] != '/') continue;
                            d[index] = 46;
                        }
                        if (index >= d.length) {
                            throw new RuntimeException("Class reference has no ending ;");
                        }
                        String className = new String(d, p + 1, index - p - 1);
                        baseType = RefType.v(className);
                        p = index + 1;
                        break block15;
                    }
                    case 'S': {
                        baseType = ShortType.v();
                        ++p;
                        break block15;
                    }
                    case 'Z': {
                        baseType = BooleanType.v();
                        ++p;
                        break block15;
                    }
                    case 'V': {
                        baseType = VoidType.v();
                        ++p;
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("Unknown field type!");
                    }
                }
            }
            if (baseType == null) continue;
            Type t = isArray ? ArrayType.v(baseType, numDimensions) : baseType;
            this.conversionTypes.add(t);
        }
        ret = this.conversionTypes.toArray(new Type[0]);
        this.cache.put(descriptor, ret);
        return ret;
    }

    public Type jimpleTypeOfFieldDescriptor(String descriptor) {
        Type baseType;
        boolean isArray = false;
        int numDimensions = 0;
        while (descriptor.startsWith("[")) {
            isArray = true;
            ++numDimensions;
            descriptor = descriptor.substring(1);
        }
        if (descriptor.equals("B")) {
            baseType = ByteType.v();
        } else if (descriptor.equals("C")) {
            baseType = CharType.v();
        } else if (descriptor.equals("D")) {
            baseType = DoubleType.v();
        } else if (descriptor.equals("F")) {
            baseType = FloatType.v();
        } else if (descriptor.equals("I")) {
            baseType = IntType.v();
        } else if (descriptor.equals("J")) {
            baseType = LongType.v();
        } else if (descriptor.equals("V")) {
            baseType = VoidType.v();
        } else if (descriptor.startsWith("L")) {
            if (!descriptor.endsWith(";")) {
                throw new RuntimeException("Class reference does not end with ;");
            }
            String className = descriptor.substring(1, descriptor.length() - 1);
            baseType = RefType.v(className.replace('/', '.'));
        } else if (descriptor.equals("S")) {
            baseType = ShortType.v();
        } else if (descriptor.equals("Z")) {
            baseType = BooleanType.v();
        } else {
            throw new RuntimeException("Unknown field type: " + descriptor);
        }
        if (isArray) {
            return ArrayType.v(baseType, numDimensions);
        }
        return baseType;
    }

    void resetEasyNames() {
        this.nextEasyNameIndex = 0;
    }

    String getNextEasyName() {
        int justifiedIndex;
        String[] easyNames = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        if ((justifiedIndex = this.nextEasyNameIndex++) >= easyNames.length) {
            return "local" + (justifiedIndex - easyNames.length);
        }
        return easyNames[justifiedIndex];
    }

    void setClassNameToAbbreviation(Map map) {
        this.classNameToAbbreviation = map;
    }

    Local getLocalForStackOp(JimpleBody listBody, TypeStack typeStack, int index) {
        if (typeStack.get(index).equals(Double2ndHalfType.v()) || typeStack.get(index).equals(Long2ndHalfType.v())) {
            --index;
        }
        return this.getLocalCreatingIfNecessary(listBody, "$stack" + index, UnknownType.v());
    }

    String getAbbreviationOfClassName(String className) {
        StringBuffer buffer = new StringBuffer(new Character(className.charAt(0)).toString());
        int periodIndex = 0;
        while ((periodIndex = className.indexOf(46, periodIndex + 1)) != -1) {
            buffer.append(Character.toLowerCase(className.charAt(periodIndex + 1)));
        }
        return buffer.toString();
    }

    String getNormalizedClassName(String className) {
        if ((className = className.replace('/', '.')).endsWith(";")) {
            className = className.substring(0, className.length() - 1);
        }
        int numDimensions = 0;
        while (className.startsWith("[")) {
            ++numDimensions;
            className = className.substring(1, className.length());
            className = className + "[]";
        }
        if (numDimensions != 0) {
            if (!className.startsWith("L")) {
                throw new RuntimeException("For some reason an array reference does not start with L");
            }
            className = className.substring(1, className.length());
        }
        return className;
    }

    public Local getLocal(Body b, String name) throws NoSuchLocalException {
        for (Local local : b.getLocals()) {
            if (!local.getName().equals(name)) continue;
            return local;
        }
        throw new NoSuchLocalException();
    }

    public boolean declaresLocal(Body b, String localName) {
        for (Local local : b.getLocals()) {
            if (!local.getName().equals(localName)) continue;
            return true;
        }
        return false;
    }

    Local getLocalCreatingIfNecessary(JimpleBody listBody, String name, Type type) {
        if (this.declaresLocal(listBody, name)) {
            return this.getLocal(listBody, name);
        }
        Local l = Jimple.v().newLocal(name, type);
        listBody.getLocals().add(l);
        return l;
    }

    Local getLocalForIndex(JimpleBody listBody, int index) {
        String name = null;
        String debug_type = null;
        boolean assignedName = false;
        if (this.useFaithfulNaming && this.activeVariableTable != null && this.activeOriginalIndex != -1) {
            if (this.isLocalStore) {
                ++this.activeOriginalIndex;
            }
            if (this.isWideLocalStore) {
                ++this.activeOriginalIndex;
            }
            name = this.activeVariableTable.getLocalVariableName(this.activeConstantPool, index, this.activeOriginalIndex);
            if (this.activeVariableTypeTable == null || (debug_type = this.activeVariableTypeTable.getLocalVariableType(this.activeConstantPool, index, this.activeOriginalIndex)) != null) {
                // empty if block
            }
            if (name != null) {
                assignedName = true;
            }
        }
        if (!assignedName) {
            name = "l" + index;
        }
        if (this.declaresLocal(listBody, name)) {
            return this.getLocal(listBody, name);
        }
        Local l = Jimple.v().newLocal(name, UnknownType.v());
        listBody.getLocals().add(l);
        return l;
    }

    boolean isValidJimpleName(String prospectiveName) {
        if (prospectiveName == null) {
            return false;
        }
        for (int i = 0; i < prospectiveName.length(); ++i) {
            char c = prospectiveName.charAt(i);
            if (i == 0 && c >= '0' && c <= '9') {
                return false;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$') continue;
            return false;
        }
        return true;
    }

    private void addAnnotationVisibilityAttribute(Host host, attribute_info attribute, ClassFile coffiClass, List references) {
        VisibilityAnnotationTag tag;
        if (attribute instanceof RuntimeVisibleAnnotations_attribute) {
            tag = new VisibilityAnnotationTag(0);
            RuntimeVisibleAnnotations_attribute attr = (RuntimeVisibleAnnotations_attribute)attribute;
            this.addAnnotations(attr.number_of_annotations, attr.annotations, coffiClass, tag, references);
        } else {
            tag = new VisibilityAnnotationTag(1);
            RuntimeInvisibleAnnotations_attribute attr = (RuntimeInvisibleAnnotations_attribute)attribute;
            this.addAnnotations(attr.number_of_annotations, attr.annotations, coffiClass, tag, references);
        }
        host.addTag(tag);
    }

    private void addAnnotationVisibilityParameterAttribute(Host host, attribute_info attribute, ClassFile coffiClass, List references) {
        VisibilityParameterAnnotationTag tag;
        if (attribute instanceof RuntimeVisibleParameterAnnotations_attribute) {
            RuntimeVisibleParameterAnnotations_attribute attr = (RuntimeVisibleParameterAnnotations_attribute)attribute;
            tag = new VisibilityParameterAnnotationTag(attr.num_parameters, 0);
            for (int i = 0; i < attr.num_parameters; ++i) {
                parameter_annotation pAnnot = attr.parameter_annotations[i];
                VisibilityAnnotationTag vTag = new VisibilityAnnotationTag(0);
                this.addAnnotations(pAnnot.num_annotations, pAnnot.annotations, coffiClass, vTag, references);
                tag.addVisibilityAnnotation(vTag);
            }
        } else {
            RuntimeInvisibleParameterAnnotations_attribute attr = (RuntimeInvisibleParameterAnnotations_attribute)attribute;
            tag = new VisibilityParameterAnnotationTag(attr.num_parameters, 1);
            for (int i = 0; i < attr.num_parameters; ++i) {
                parameter_annotation pAnnot = attr.parameter_annotations[i];
                VisibilityAnnotationTag vTag = new VisibilityAnnotationTag(1);
                this.addAnnotations(pAnnot.num_annotations, pAnnot.annotations, coffiClass, vTag, references);
                tag.addVisibilityAnnotation(vTag);
            }
        }
        host.addTag(tag);
    }

    private void addAnnotations(int numAnnots, annotation[] annotations, ClassFile coffiClass, VisibilityAnnotationTag tag, List references) {
        for (int i = 0; i < numAnnots; ++i) {
            annotation annot = annotations[i];
            String annotType = ((CONSTANT_Utf8_info)coffiClass.constant_pool[annot.type_index]).convert();
            String ref = annotType.substring(1, annotType.length() - 1);
            ref = ref.replace('/', '.');
            references.add(ref);
            int numElems = annot.num_element_value_pairs;
            AnnotationTag annotTag = new AnnotationTag(annotType, numElems);
            annotTag.setElems(this.createElementTags(numElems, coffiClass, annot.element_value_pairs));
            tag.addAnnotation(annotTag);
        }
    }

    private ArrayList<AnnotationElem> createElementTags(int count, ClassFile coffiClass, element_value[] elems) {
        ArrayList<AnnotationElem> list = new ArrayList<AnnotationElem>();
        for (int j = 0; j < count; ++j) {
            element_value aev;
            AnnotationElem elem;
            AnnotationElem elem2;
            element_value cev;
            element_value ev = elems[j];
            char kind = ev.tag;
            String elemName = "default";
            if (ev.name_index != 0) {
                elemName = ((CONSTANT_Utf8_info)coffiClass.constant_pool[ev.name_index]).convert();
            }
            if (kind == 'B' || kind == 'C' || kind == 'I' || kind == 'S' || kind == 'Z' || kind == 'D' || kind == 'F' || kind == 'J' || kind == 's') {
                cev = (constant_element_value)ev;
                if (kind == 'B' || kind == 'C' || kind == 'I' || kind == 'S' || kind == 'Z') {
                    cp_info cval = coffiClass.constant_pool[cev.constant_value_index];
                    int constant_val = (int)((CONSTANT_Integer_info)cval).bytes;
                    AnnotationIntElem elem3 = new AnnotationIntElem(constant_val, kind, elemName);
                    list.add(elem3);
                    continue;
                }
                if (kind == 'D') {
                    cp_info cval = coffiClass.constant_pool[cev.constant_value_index];
                    double constant_val = ((CONSTANT_Double_info)cval).convert();
                    elem2 = new AnnotationDoubleElem(constant_val, kind, elemName);
                    list.add(elem2);
                    continue;
                }
                if (kind == 'F') {
                    cp_info cval = coffiClass.constant_pool[cev.constant_value_index];
                    float constant_val = ((CONSTANT_Float_info)cval).convert();
                    AnnotationFloatElem elem4 = new AnnotationFloatElem(constant_val, kind, elemName);
                    list.add(elem4);
                    continue;
                }
                if (kind == 'J') {
                    cp_info cval = coffiClass.constant_pool[cev.constant_value_index];
                    CONSTANT_Long_info lcval = (CONSTANT_Long_info)cval;
                    long constant_val = (lcval.high << 32) + lcval.low;
                    elem = new AnnotationLongElem(constant_val, kind, elemName);
                    list.add(elem);
                    continue;
                }
                if (kind != 's') continue;
                cp_info cval = coffiClass.constant_pool[cev.constant_value_index];
                String constant_val = ((CONSTANT_Utf8_info)cval).convert();
                AnnotationStringElem elem5 = new AnnotationStringElem(constant_val, kind, elemName);
                list.add(elem5);
                continue;
            }
            if (kind == 'e') {
                enum_constant_element_value ecev = (enum_constant_element_value)ev;
                cp_info type_val = coffiClass.constant_pool[ecev.type_name_index];
                String type_name = ((CONSTANT_Utf8_info)type_val).convert();
                cp_info name_val = coffiClass.constant_pool[ecev.constant_name_index];
                String constant_name = ((CONSTANT_Utf8_info)name_val).convert();
                elem = new AnnotationEnumElem(type_name, constant_name, kind, elemName);
                list.add(elem);
                continue;
            }
            if (kind == 'c') {
                cev = (class_element_value)ev;
                cp_info cval = coffiClass.constant_pool[((class_element_value)cev).class_info_index];
                CONSTANT_Utf8_info sval = (CONSTANT_Utf8_info)cval;
                String desc = sval.convert();
                elem2 = new AnnotationClassElem(desc, kind, elemName);
                list.add(elem2);
                continue;
            }
            if (kind == '[') {
                aev = (array_element_value)ev;
                int num_vals = aev.num_values;
                ArrayList<AnnotationElem> elemVals = this.createElementTags(num_vals, coffiClass, aev.values);
                AnnotationArrayElem elem6 = new AnnotationArrayElem(elemVals, kind, elemName);
                list.add(elem6);
                continue;
            }
            if (kind != '@') continue;
            aev = (annotation_element_value)ev;
            annotation annot = ((annotation_element_value)aev).annotation_value;
            String annotType = ((CONSTANT_Utf8_info)coffiClass.constant_pool[annot.type_index]).convert();
            int numElems = annot.num_element_value_pairs;
            AnnotationTag annotTag = new AnnotationTag(annotType, numElems);
            annotTag.setElems(this.createElementTags(numElems, coffiClass, annot.element_value_pairs));
            elem = new AnnotationAnnotationElem(annotTag, kind, elemName);
            list.add(elem);
        }
        return list;
    }
}

