/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.options.CPOptions;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SmartLocalDefs;

public class CopyPropagator
extends BodyTransformer {
    public CopyPropagator(Singletons.Global g) {
    }

    public static CopyPropagator v() {
        return G.v().soot_jimple_toolkits_scalar_CopyPropagator();
    }

    protected void internalTransform(Body b, String phaseName, Map opts) {
        CPOptions options = new CPOptions(opts);
        StmtBody stmtBody = (StmtBody)b;
        int fastCopyPropagationCount = 0;
        int slowCopyPropagationCount = 0;
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "] Propagating copies...");
        }
        if (Options.v().time()) {
            Timers.v().propagatorTimer.start();
        }
        PatchingChain<Unit> units = stmtBody.getUnits();
        HashMap<Local, Integer> localToDefCount = new HashMap<Local, Integer>();
        for (Stmt stmt : units) {
            if (!(stmt instanceof DefinitionStmt) || !(((DefinitionStmt)stmt).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((DefinitionStmt)stmt).getLeftOp();
            if (!localToDefCount.containsKey(l)) {
                localToDefCount.put(l, new Integer(1));
                continue;
            }
            localToDefCount.put(l, new Integer((Integer)localToDefCount.get(l) + 1));
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(stmtBody);
        SmartLocalDefs smartLocalDefs = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        for (Stmt stmt : new PseudoTopologicalOrderer<Unit>().newList(graph, false)) {
            for (ValueBox useBox : stmt.getUseBoxes()) {
                Stmt s;
                Local m;
                DefinitionStmt def;
                List<Unit> defsOfUse;
                if (!(useBox.getValue() instanceof Local)) continue;
                Local l = (Local)useBox.getValue();
                if (options.only_regular_locals() && l.getName().startsWith("$") || options.only_stack_locals() && !l.getName().startsWith("$") || (defsOfUse = smartLocalDefs.getDefsOfAt(l, stmt)).size() != 1 || !((def = (DefinitionStmt)defsOfUse.get(0)).getRightOp() instanceof Local) || l == (m = (Local)def.getRightOp())) continue;
                Object dcObj = localToDefCount.get(m);
                if (dcObj == null) {
                    throw new RuntimeException("Variable " + m + " used without definition!");
                }
                int defCount = (Integer)dcObj;
                if (defCount == 0) {
                    throw new RuntimeException("Variable " + m + " used without definition!");
                }
                if (defCount == 1) {
                    useBox.setValue(m);
                    ++fastCopyPropagationCount;
                    continue;
                }
                List<Unit> path = graph.getExtendedBasicBlockPathBetween(def, stmt);
                if (path == null) continue;
                Iterator<Unit> pathIt = path.iterator();
                pathIt.next();
                boolean isRedefined = false;
                while (pathIt.hasNext() && stmt != (s = (Stmt)pathIt.next())) {
                    if (!(s instanceof DefinitionStmt) || ((DefinitionStmt)s).getLeftOp() != m) continue;
                    isRedefined = true;
                    break;
                }
                if (isRedefined) continue;
                useBox.setValue(m);
                ++slowCopyPropagationCount;
            }
        }
        if (Options.v().verbose()) {
            G.v().out.println("[" + stmtBody.getMethod().getName() + "]     Propagated: " + fastCopyPropagationCount + " fast copies  " + slowCopyPropagationCount + " slow copies");
        }
        if (Options.v().time()) {
            Timers.v().propagatorTimer.end();
        }
    }
}

