/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.toolkits.graph.DirectedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopBodyFinder {
    private final Stack<Object> stack = new Stack();
    private final Set<Set<Object>> loops = new HashSet<Set<Object>>();

    LoopBodyFinder(Map<Object, Object> backEdges, DirectedGraph g) {
        this.findLoopBody(backEdges, g);
    }

    private void findLoopBody(Map<Object, Object> backEdges, DirectedGraph g) {
        Set<Map.Entry<Object, Object>> maps = backEdges.entrySet();
        for (Map.Entry<Object, Object> entry : maps) {
            Object tail = entry.getKey();
            Object head = entry.getValue();
            Set<Object> loopBody = this.finder(tail, head, g);
            this.loops.add(loopBody);
        }
    }

    private Set<Object> finder(Object tail, Object head, DirectedGraph g) {
        HashSet<Object> loop = new HashSet<Object>();
        this.stack.empty();
        loop.add(head);
        this.insert(tail, loop);
        while (!this.stack.empty()) {
            Object p = this.stack.pop();
            for (Object pred : g.getPredsOf(p)) {
                this.insert(pred, loop);
            }
        }
        return loop;
    }

    private void insert(Object m, Set<Object> loop) {
        if (!loop.contains(m)) {
            loop.add(m);
            this.stack.push(m);
        }
    }

    public Set<Set<Object>> getLoopBody() {
        return this.loops;
    }
}

