/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import java.util.ArrayList;
import java.util.Iterator;
import soot.tagkit.AnnotationElem;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTag
implements Tag {
    private String type;
    private int numElems = 0;
    private ArrayList<AnnotationElem> elems;

    public AnnotationTag(String type, int numElems) {
        this.type = type;
        this.numElems = numElems;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Annotation: type: " + this.type + " num elems: " + this.numElems + " elems: ");
        if (this.elems != null) {
            Iterator<AnnotationElem> it = this.elems.iterator();
            while (it.hasNext()) {
                sb.append("\n");
                sb.append(it.next());
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public String getName() {
        return "AnnotationTag";
    }

    public String getInfo() {
        return "Annotation";
    }

    public String getType() {
        return this.type;
    }

    public int getNumElems() {
        return this.numElems;
    }

    @Override
    public byte[] getValue() {
        throw new RuntimeException("AnnotationTag has no value for bytecode");
    }

    public void addElem(AnnotationElem elem) {
        if (this.elems == null) {
            this.elems = new ArrayList();
        }
        this.elems.add(elem);
    }

    public void setElems(ArrayList<AnnotationElem> list) {
        this.elems = list;
    }

    public AnnotationElem getElemAt(int i) {
        return this.elems.get(i);
    }
}

