/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ArbitraryRegion;
import hj.array.ContiguousRange;
import hj.array.EmptyRegion;
import hj.lang.Indexable;
import hj.lang.RankMismatchException;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Distribution_c
extends dist {
    private int _blockSize;
    private int _cycleSize;
    protected final Set places = new HashSet();

    public boolean isValue() {
        return true;
    }

    public boolean valueEquals(Indexable other) {
        return this.equals(other);
    }

    public Set places() {
        return this.places;
    }

    public Distribution_c(region r, place onePlace) {
        super(r, onePlace);
    }

    public region restrictToRegion(place pl) {
        return Distribution_c.restriction((dist)this, pl);
    }

    protected static region restriction(dist th, place pl) {
        if (th instanceof Combined) {
            return ((Combined)th).restrictToRegion(pl);
        }
        if (th instanceof Constant) {
            return ((Constant)th).restrictToRegion(pl);
        }
        if (th instanceof Unique) {
            return ((Unique)th).restrictToRegion(pl);
        }
        HashSet<point> points = new HashSet<point>();
        boolean zeroBased = false;
        point allZero = point.factory.point(new int[th.rank]);
        Iterator it = th.region.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            if (th.get(p) != pl) continue;
            points.add(p);
            zeroBased |= p.equals(allZero);
        }
        ArbitraryRegion ret = new ArbitraryRegion(th.region.rank, points);
        return ret;
    }

    public dist restriction(Set Ps) {
        return Distribution_c.restriction((dist)this, Ps);
    }

    protected static dist restriction(dist th, Set Ps) {
        HashMap<point, place> hm = new HashMap<point, place>();
        HashSet<point> points = new HashSet<point>();
        boolean zeroBased = false;
        point allZero = point.factory.allZero(th.rank);
        Iterator it = th.region.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            place pl = th.get(p);
            if (!Ps.contains(pl)) continue;
            points.add(p);
            hm.put(p, pl);
            zeroBased |= p.equals(allZero);
        }
        ArbitraryRegion reg = new ArbitraryRegion(th.rank, points);
        place onePlace = Ps.size() == 1 ? (place)Ps.toArray()[0] : null;
        Arbitrary ret = new Arbitrary(reg, hm, onePlace);
        return ret;
    }

    public dist restriction(region r) {
        return Distribution_c.restriction((dist)this, r);
    }

    protected static dist restriction(dist th, region r) {
        if (r.rank != th.rank) {
            throw new RankMismatchException(r, th.rank);
        }
        HashMap<point, place> hm = new HashMap<point, place>();
        HashSet<point> points = new HashSet<point>();
        boolean isSet = false;
        place onePlace = null;
        Iterator it = th.region.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            if (!r.contains(p)) continue;
            place place2 = th.get(p);
            onePlace = isSet ? (onePlace == null ? null : (onePlace.equals(place2) ? onePlace : null)) : place2;
            isSet = true;
            points.add(p);
            hm.put(p, th.get(p));
        }
        ArbitraryRegion reg = new ArbitraryRegion(th.rank, points);
        Arbitrary ret = new Arbitrary(reg, hm, onePlace);
        return ret;
    }

    public dist difference(region r) {
        return Distribution_c.difference(this, r);
    }

    protected static dist difference(dist th, region r) {
        if (r.rank != th.rank) {
            throw new RankMismatchException(r, th.rank);
        }
        region reg = th.region.difference(r);
        HashMap<point, place> hm = new HashMap<point, place>();
        boolean isSet = false;
        place onePlace = null;
        Iterator it = reg.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            place place2 = th.get(p);
            if (isSet) {
                if (onePlace != null) {
                    onePlace = onePlace.equals(place2) ? onePlace : null;
                }
            } else {
                onePlace = place2;
            }
            isSet = true;
            hm.put(p, th.get(p));
        }
        Arbitrary ret = new Arbitrary(reg, hm, onePlace);
        return ret;
    }

    public dist union(dist d) {
        return Distribution_c.union(this, d);
    }

    protected static dist union(dist th, dist d) {
        point p;
        if (d.rank != th.rank) {
            throw new RankMismatchException(d, th.rank);
        }
        if (!d.region.disjoint(th.region)) {
            throw new IllegalArgumentException("Non-disjoint region in a disjoint union");
        }
        region reg = d.region.union(th.region);
        HashMap<point, place> hm = new HashMap<point, place>();
        Iterator it = th.region.iterator();
        while (it.hasNext()) {
            p = (point)it.next();
            hm.put(p, th.get(p));
        }
        it = d.region.iterator();
        while (it.hasNext()) {
            p = (point)it.next();
            hm.put(p, d.get(p));
        }
        Arbitrary ret = new Arbitrary(reg, hm, th.onePlace == null ? null : (th.onePlace.equals(d.onePlace) ? th.onePlace : null));
        return ret;
    }

    public dist intersection(dist D) {
        return Distribution_c.intersection(this, D);
    }

    public dist overlay(region r, dist d) {
        return Distribution_c.overlay(this, r, d);
    }

    public dist overlay(dist d) {
        return Distribution_c.overlay(this, d.region, d);
    }

    protected static dist overlay(dist th, region r, dist d) {
        if (d.rank != th.rank) {
            throw new RankMismatchException(d, th.rank);
        }
        if (r.rank != th.rank) {
            throw new RankMismatchException(r, th.rank);
        }
        region reg = r.union(th.region);
        HashMap<point, place> hm = new HashMap<point, place>();
        boolean isSet = false;
        place onePlace = null;
        Iterator it = reg.iterator();
        while (it.hasNext()) {
            place pl;
            point p = (point)it.next();
            if (d.region.contains(p)) {
                pl = d.get(p);
                assert (pl != null);
            } else {
                pl = th.get(p);
                assert (pl != null);
            }
            onePlace = isSet ? (pl.equals(onePlace) ? onePlace : null) : pl;
            isSet = true;
            hm.put(p, pl);
        }
        Arbitrary ret = new Arbitrary(reg, hm, onePlace);
        return ret;
    }

    protected static dist intersection(dist th, dist d) {
        if (d.rank != th.rank) {
            throw new RankMismatchException(d, th.rank);
        }
        region reg = th.region.intersection(d.region);
        HashMap<point, place> hm = new HashMap<point, place>();
        HashSet<point> points = new HashSet<point>();
        boolean isSet = false;
        place onePlace = null;
        Iterator it = reg.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            place pl = th.get(p);
            if (!pl.equals(d.get(p))) continue;
            onePlace = isSet ? (pl.equals(onePlace) ? onePlace : null) : pl;
            hm.put(p, pl);
            points.add(p);
        }
        ArbitraryRegion reg_new = new ArbitraryRegion(th.rank, points);
        Arbitrary ret = new Arbitrary(reg_new, hm, onePlace);
        return ret;
    }

    public boolean subDistribution(region r, dist d) {
        return Distribution_c.subDistribution(this, r, d);
    }

    protected static boolean subDistribution(dist th, region r, dist d) {
        if (d.rank != th.rank) {
            throw new RankMismatchException(d, th.rank);
        }
        boolean ret = false;
        if (th.region.contains(d.region)) {
            ret = true;
            Iterator it = d.region.iterator();
            while (it.hasNext()) {
                place p2;
                point p = (point)it.next();
                place p1 = th.get(p);
                if (p1.equals(p2 = d.get(p))) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    static final class Arbitrary
    extends Distribution_c {
        private final Map map_;

        Arbitrary(region r, Map m, place onePlace) {
            super(r, onePlace);
            this.map_ = m;
            this.places.addAll(m.values());
        }

        public place get(point p) {
            assert (p != null);
            place ret = (place)this.map_.get(p);
            if (ret == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return ret;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("Distribution_c.Arbitrary<\n");
            Iterator it = this.map_.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                point p = (point)me.getKey();
                place pl = (place)me.getValue();
                s.append("[" + p + ", " + pl + "]");
                if (!it.hasNext()) continue;
                s.append(",\n");
            }
            s.append(">");
            return s.toString();
        }
    }

    static class Combined
    extends Distribution_c {
        private final Distribution_c[] members_;

        Combined(region r, Distribution_c[] members_, place onePlace) {
            super(r, onePlace);
            assert (members_ != null);
            this.members_ = (Distribution_c[])members_.clone();
            for (int i = 0; i < members_.length; ++i) {
                this.places.addAll(members_[i].places());
            }
        }

        public place get(point p) {
            if (p.rank != this.rank) {
                throw new RankMismatchException(p, this.rank);
            }
            place ret = null;
            for (int i = 0; ret == null && i < this.members_.length; ++i) {
                if (!this.members_[i].region.contains(p)) continue;
                ret = this.members_[i].get(p);
                assert (ret != null);
            }
            if (ret == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return ret;
        }

        public place get(int[] p) {
            place ret = null;
            for (int i = 0; ret == null && i < this.members_.length; ++i) {
                if (!this.members_[i].region.contains(p)) continue;
                ret = this.members_[i].get(p);
            }
            if (ret == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return ret;
        }

        public region restrictToRegion(place pl) {
            int i;
            region[] newRegions = new region[this.members_.length];
            int count = 0;
            for (i = 0; i < this.members_.length; ++i) {
                region r = Combined.restriction((dist)this.members_[i], pl);
                if (r instanceof EmptyRegion) continue;
                newRegions[count++] = r;
            }
            region.factory RF = Runtime.factory.getRegionFactory();
            if (0 == count) {
                return RF.emptyRegion(this.region.rank);
            }
            if (1 == count) {
                return newRegions[0];
            }
            HashSet<point> points = new HashSet<point>();
            boolean zeroBased = false;
            point allZero = point.factory.allZero(this.rank);
            for (i = 0; i < count; ++i) {
                Iterator it = newRegions[i].iterator();
                while (it.hasNext()) {
                    point p = (point)it.next();
                    points.add(p);
                    zeroBased |= p.equals(allZero);
                }
            }
            ArbitraryRegion ret = new ArbitraryRegion(this.region.rank, points);
            return ret;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("CombinedDistribution_c<");
            for (int i = 0; i < this.members_.length; ++i) {
                s.append(this.members_[i]);
            }
            return s.append(">").toString();
        }
    }

    static class Unique
    extends Distribution_c {
        place[] placeseq;

        Unique(place[] ps) {
            super(new ContiguousRange(0, ps.length - 1), ps.length == 1 ? ps[0] : null);
            this.placeseq = ps;
            for (int i = 0; i < this.placeseq.length; ++i) {
                this.places.add(ps[i]);
            }
        }

        public place get(point p) {
            if (p.rank != this.rank) {
                throw new RankMismatchException(p, this.rank);
            }
            if (!this.region.contains(p)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.placeseq[p.get(0) % this.placeseq.length];
        }

        public place get(int[] val) {
            assert (val.length == 1);
            if (val[0] >= this.placeseq.length || val[0] < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.placeseq[val[0]];
        }

        public region restrictToRegion(place P) {
            int index = -1;
            for (int i = 0; i < this.placeseq.length; ++i) {
                if (this.placeseq[i] != P) continue;
                index = i;
                break;
            }
            region.factory RF = Runtime.factory.getRegionFactory();
            if (index < 0) {
                return RF.emptyRegion(1);
            }
            return RF.region(index, index);
        }

        public String toString() {
            StringBuffer s = new StringBuffer("Distribution_c.Unique<");
            for (int i = 0; i < this.placeseq.length; ++i) {
                s.append(this.placeseq[i].toString());
            }
            return s.append(">").toString();
        }
    }

    static final class Constant
    extends Distribution_c {
        place place_;

        Constant(region r, place p) {
            super(r, p);
            this.places.add(p);
            this.place_ = p;
        }

        public final region[] getPerPlaceRegions() {
            region[] theRegions = new region[place.MAX_PLACES];
            theRegions[this.place_.id] = this.distribution.region;
            return theRegions;
        }

        public place get(point p) {
            if (p.rank != this.rank) {
                throw new RankMismatchException(p, this.rank);
            }
            if (!this.region.contains(p)) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.place_;
        }

        public region restrictToRegion(place P) {
            if (P.equals(this.place_)) {
                return this.region;
            }
            return Runtime.factory.getRegionFactory().emptyRegion(this.rank);
        }

        public dist restriction(Set Ps) {
            if (Ps.contains(this.place_)) {
                return this;
            }
            return new Empty(this.rank);
        }

        public dist restriction(region R) {
            if (R.rank != this.rank) {
                throw new RankMismatchException(R, this.rank);
            }
            region r = this.region.intersection(R);
            Distribution_c ret = r.size() == 0 ? new Empty(this.rank) : new Constant(r, this.place_);
            return ret;
        }

        public dist difference(region R) {
            if (R.rank != this.rank) {
                throw new RankMismatchException(R, this.rank);
            }
            region r = this.region.difference(R);
            Distribution_c ret = r.size() == 0 ? new Empty(this.rank) : new Constant(r, this.place_);
            return ret;
        }

        public dist union(dist D) {
            Distribution_c ret;
            if (D.rank != this.rank) {
                throw new RankMismatchException(D, this.rank);
            }
            assert (D.region.disjoint(this.region));
            assert (D instanceof Distribution_c);
            if (D.region.size() == 0) {
                ret = this;
            } else {
                Distribution_c[] arr = new Distribution_c[]{this, (Distribution_c)D};
                region r = this.region.union(D.region);
                ret = new Combined(r, arr, arr[0].onePlace == arr[1].onePlace ? arr[0].onePlace : null);
            }
            return ret;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("Distribution_c.Constant<region=|");
            s.append(this.region.toString());
            s.append("|, place=|");
            s.append(this.place_);
            s.append("|");
            s.append(">");
            return s.toString();
        }
    }

    static final class Empty
    extends Distribution_c {
        Empty() {
            this(1);
        }

        Empty(int k) {
            super(Runtime.factory.getRegionFactory().emptyRegion(k), null);
        }

        public place get(point p) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public place get(int[] p) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public region restrictToRegion(place P) {
            return this.region;
        }

        public dist restriction(Set Ps) {
            return this;
        }

        public dist restriction(region R) {
            if (R.rank != this.rank) {
                throw new RankMismatchException(R, this.rank);
            }
            return this;
        }

        public dist difference(region R) {
            if (R.rank != this.rank) {
                throw new RankMismatchException(R, this.rank);
            }
            return this;
        }

        public dist union(dist D) {
            if (D.rank != this.rank) {
                throw new RankMismatchException(D, this.rank);
            }
            return D;
        }

        public boolean subDistribution(region R, dist D) {
            if (D.rank != this.rank) {
                throw new RankMismatchException(D, this.rank);
            }
            return D instanceof Empty || D.region.size() == 0;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("Distribution_c.Empty<");
            s.append(this.region.toString());
            s.append("|>");
            return s.toString();
        }
    }
}

