/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.MultiDimRegion;
import hj.lang.point;
import hj.lang.region;

public class RegionRectangular
extends MultiDimRegion {
    public final int low_I;
    public final int low_J;
    public final int low_K;
    public final int low_L;
    public final int low_M;
    public final int lg_I;
    public final int lg_J;
    public final int lg_K;
    public final int lg_L;
    public final int lg_M;
    public final int rank;

    public RegionRectangular(region[] r) {
        super(r, false);
        this.rank = r.length;
        this.low_I = this.rank >= 1 ? r[0].rank(0).low() : 0;
        this.lg_I = this.rank >= 1 ? r[0].rank(0).size() : 0;
        this.low_J = this.rank >= 2 ? r[1].rank(0).low() : 0;
        this.lg_J = this.rank >= 2 ? r[1].rank(0).size() : 0;
        this.low_K = this.rank >= 3 ? r[2].rank(0).low() : 0;
        this.lg_K = this.rank >= 3 ? r[2].rank(0).size() : 0;
        this.low_L = this.rank >= 4 ? r[3].rank(0).low() : 0;
        this.lg_L = this.rank >= 4 ? r[3].rank(0).size() : 0;
        this.low_M = this.rank >= 5 ? r[4].rank(0).low() : 0;
        int n = this.lg_M = this.rank >= 5 ? r[4].rank(0).size() : 0;
        if (this.rank > 5) {
            throw new RuntimeException("current rectangular region implementation is restricted from 1d to 5d ");
        }
    }

    public int ordinal(point p) {
        int r = p.rank;
        if (r == 1) {
            return this.ordinal(p.get(0));
        }
        if (r == 2) {
            return this.ordinal(p.get(0), p.get(1));
        }
        if (r == 3) {
            return this.ordinal(p.get(0), p.get(1), p.get(2));
        }
        if (r == 4) {
            return this.ordinal(p.get(0), p.get(1), p.get(2), p.get(3));
        }
        if (r == 5) {
            return this.ordinal(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4));
        }
        throw new RuntimeException("point " + p + " rank is not compatible with a rectangular region");
    }

    public final int ordinal(int i) {
        return i - this.low_I;
    }

    public final int ordinal(int i, int j) {
        return j - this.low_J + (i - this.low_I) * this.lg_J;
    }

    public final int ordinal(int i, int j, int k) {
        return k - this.low_K + (j - this.low_J) * this.lg_K + (i - this.low_I) * this.lg_K * this.lg_J;
    }

    public final int ordinal(int i, int j, int k, int l) {
        return l - this.low_L + (k - this.low_K) * this.lg_L + (j - this.low_J) * (this.lg_L * this.lg_K) + (i - this.low_I) * (this.lg_L * this.lg_K * this.lg_J);
    }

    public final int ordinal(int i, int j, int k, int l, int m) {
        return m - this.low_M + (l - this.low_L) * this.lg_M + (k - this.low_K) * (this.lg_M * this.lg_L) + (j - this.low_J) * (this.lg_M * this.lg_L * this.lg_K) + (i - this.low_I) * (this.lg_M * this.lg_L * this.lg_K * this.lg_J);
    }

    public int getDimensionSize(int dimension) {
        if (dimension == 1) {
            return this.lg_I;
        }
        if (dimension == 2) {
            return this.lg_J;
        }
        if (dimension == 3) {
            return this.lg_K;
        }
        if (dimension == 4) {
            return this.lg_L;
        }
        if (dimension == 5) {
            return this.lg_M;
        }
        throw new RuntimeException("current rectangular region implementation is restricted from 1d to 5d ");
    }

    public String toString() {
        int dimension = 1;
        String res = "";
        while (dimension < 6) {
            res = res + "[" + this.getDimensionSize(dimension++) + "]";
        }
        return res;
    }
}

