/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.CharArray;
import hj.array.Distribution_c;
import hj.array.Operator;
import hj.array.lang.charArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class CharArray_c
extends CharArray
implements UnsafeContainer,
Cloneable {
    public final char[] arr_;
    public final int[] descriptor_;

    public CharArray_c(dist d, char c, boolean mutable) {
        this(d, new charArray.Constant(c), mutable);
    }

    public CharArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected CharArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((CharArray)this, c);
        }
    }

    protected CharArray_c(dist d, boolean mutable, char[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new char[count];
    }

    private CharArray_c(dist d, char[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static CharArray_c CharArray_c(char[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new CharArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        CharArray_c o = (CharArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public char[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public char setOrdinal(char v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public char getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected CharArray newInstance(dist d) {
        return new CharArray_c(d, (Operator.Pointwise)null, true);
    }

    protected CharArray newInstance(dist d, char c) {
        return new CharArray_c(d, c, true);
    }

    protected void assign(CharArray rhs) {
        assert (rhs.getClass() == this.getClass());
        CharArray_c rhs_t = (CharArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

