/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Runtime;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.HjGlobalLock;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;

public class TwoLevelLockPlace {
    public static HjGlobalLock globalLevelLock;
    public static ReentrantLock[] placeLevelLock;

    public static void init(int numPlaces) {
        globalLevelLock = new HjGlobalLock();
        placeLevelLock = new ReentrantLock[numPlaces];
        for (int i = 0; i < numPlaces; ++i) {
            TwoLevelLockPlace.placeLevelLock[i] = new ReentrantLock();
        }
    }

    public static void atomicStarLock() {
        globalLevelLock.writeLock().lock();
    }

    public static void atomicStarUnlock() {
        globalLevelLock.writeLock().unlock();
    }

    public static void atomicPLock(int placeID) {
        globalLevelLock.readLock().lock();
        placeLevelLock[placeID].lock();
    }

    public static void atomicPUnlock(int placeID) {
        placeLevelLock[placeID].unlock();
        globalLevelLock.readLock().unlock();
    }

    public static void atomicPLock(int p1, int p2) {
        globalLevelLock.readLock().lock();
        if (p1 == p2) {
            placeLevelLock[p1].lock();
        } else if (p1 < p2) {
            placeLevelLock[p1].lock();
            placeLevelLock[p2].lock();
        } else {
            placeLevelLock[p2].lock();
            placeLevelLock[p1].lock();
        }
    }

    public static void atomicPUnlock(int p1, int p2) {
        if (p1 == p2) {
            placeLevelLock[p1].unlock();
        } else if (p1 < p2) {
            placeLevelLock[p1].unlock();
            placeLevelLock[p2].unlock();
        } else {
            placeLevelLock[p2].unlock();
            placeLevelLock[p1].unlock();
        }
        globalLevelLock.readLock().unlock();
    }

    public static void atomicPLock(int ... places) {
        globalLevelLock.readLock().lock();
        Arrays.sort(places);
        int prev_place = -1;
        for (int i = 0; i < places.length; ++i) {
            if (places[i] == prev_place) continue;
            placeLevelLock[places[i]].lock();
            prev_place = places[i];
        }
    }

    public static void atomicPUnlock(int ... places) {
        Arrays.sort(places);
        int prev_place = -1;
        for (int i = 0; i < places.length; ++i) {
            if (places[i] == prev_place) continue;
            placeLevelLock[places[i]].unlock();
            prev_place = places[i];
        }
        globalLevelLock.readLock().unlock();
    }

    public static boolean inLock() {
        return Runtime.currentWorker() == globalLevelLock.getLockOwner();
    }

    public static boolean inLock(ActivityRunner ar) {
        return ar == globalLevelLock.getLockOwner();
    }
}

