/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive;

import hj.runtime.wst.Trace;
import hj.runtime.wst.WstConfiguration;
import hj.runtime.wst.adaptive.Deque;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DequeNoLeak<T>
implements Deque<T> {
    protected static final int K = 3;
    protected volatile int bottom = 0;
    protected volatile int top = 0;
    public final T Abort;
    protected volatile CircularArray activeArray = new CircularArray(12);

    public DequeNoLeak(T abort) {
        this.Abort = abort;
    }

    @Override
    public void pushBottom(T o) {
        int b = this.bottom;
        int t = this.top;
        int size = b - t;
        CircularArray a = this.activeArray;
        if (size >= a.size() - 1) {
            this.activeArray = a = a.grow(b, t);
        }
        a.put(b, o);
        this.bottom = b + 1;
    }

    @Override
    public T steal() {
        int t = this.top;
        int b = this.bottom;
        CircularArray a = this.activeArray;
        int size = b - t;
        if (size <= 0) {
            return null;
        }
        Object o = a.get(t);
        if (o == null) {
            return this.Abort;
        }
        if (!a.compareAndSet(t, o, null)) {
            return this.Abort;
        }
        this.top = t + 1;
        return o;
    }

    @Override
    public T popBottom() {
        int b = this.bottom;
        CircularArray a = this.activeArray;
        this.bottom = --b;
        int t = this.top;
        int size = b - t;
        if (size < 0) {
            this.bottom = t;
            return null;
        }
        Object o = a.get(b);
        if (size > 0) {
            assert (o != null);
            a.put(b, null);
            return o;
        }
        if (o == null || !a.compareAndSet(t, o, null)) {
            this.bottom = t + 1;
            return null;
        }
        return o;
    }

    @Override
    public boolean isEmpty() {
        return this.bottom - this.top <= 0;
    }

    void perhapsShrink(int b, int t) {
        CircularArray a = this.activeArray;
        if (b - t < a.size() / 3) {
            CircularArray aa;
            this.activeArray = aa = a.shrink(b, t);
        }
    }

    @Override
    public int size() {
        return this.bottom - this.top;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CircularArray {
        private int log_size;
        private int size;
        private AtomicReferenceArray<T> segment;

        CircularArray(int log_size) {
            this.log_size = log_size;
            this.size = 1 << log_size;
            this.segment = new AtomicReferenceArray(this.size);
        }

        int size() {
            return this.size;
        }

        T get(int i) {
            int index = i % this.size;
            return this.segment.get(index);
        }

        void put(int i, T o) {
            int index = i % this.size;
            this.segment.lazySet(index, o);
        }

        boolean compareAndSet(int i, T expect, T update) {
            int index = i % this.size;
            return this.segment.compareAndSet(index, expect, update);
        }

        CircularArray grow(int b, int t) {
            if (WstConfiguration.REPORTING) {
                Trace.line(10, "Growing Deque");
            }
            CircularArray a = new CircularArray(this.log_size + 1);
            for (int i = t; i < b; ++i) {
                Object o = this.get(i);
                if (this.compareAndSet(i, o, null)) {
                    a.put(i, o);
                    continue;
                }
                a.put(i, null);
            }
            return a;
        }

        CircularArray shrink(int b, int t) {
            CircularArray a = new CircularArray(this.log_size - 1);
            for (int i = t; i < b; ++i) {
                a.put(i, this.get(i));
            }
            return a;
        }
    }
}

