/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive;

import hj.runtime.wst.Trace;
import hj.runtime.wst.WstConfiguration;
import hj.runtime.wst.adaptive.ActivationFrame;
import hj.runtime.wst.adaptive.BfAsyncFrame;
import hj.runtime.wst.adaptive.Closure;
import hj.runtime.wst.adaptive.ContinuationFrame;
import hj.runtime.wst.adaptive.DelayedAsync;
import hj.runtime.wst.adaptive.Deque;
import hj.runtime.wst.adaptive.DequeNoLeak;
import hj.runtime.wst.adaptive.FinishTreeNode;
import hj.runtime.wst.adaptive.Place;
import hj.runtime.wst.adaptive.Runtime;
import hj.runtime.wst.adaptive.WorkerAbortException;
import hj.runtime.wst.adaptive.WorkerBlockedException;
import hj.runtime.wst.adaptive.WorkerException;
import hj.runtime.wst.adaptive.WorkerExecutable;
import java.util.Random;

public class Worker
extends Thread {
    public final int id;
    public final int index;
    public int status;
    public int PROFILE_eval = 0;
    public int PROFILE_stack_bound = 0;
    public int PROFILE_stack_bound_switch = 0;
    public int PROFILE_task_bound = 0;
    public int PROFILE_task_bound_switch = 0;
    public int PROFILE_steal_rate_fast = 0;
    public int PROFILE_steal_rate_fast_switch = 0;
    public int PROFILE_steal_rate_slow = 0;
    public int PROFILE_steal_rate_slow_switch = 0;
    public int PROFILE_reset = 0;
    public int PROFILE_reset_switch = 0;
    public int PROFILE_help_first_asyncs = 0;
    public int PROFILE_work_first_asyncs = 0;
    public static final int STATUS_READYTOGO = 0;
    public static final int STATUS_STEALING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUSPENDED = 3;
    public static final int STATUS_ABORT = 4;
    public static final int STATUS_TERM = 5;
    public static final int SCHED_HELPFIRST = 10;
    public static final int SCHED_WORKFIRST = 11;
    public static int SCHED_SWITCHING_DEQUE_THRESHOLD;
    private static int SCHED_POLICY_REVISIT_INTERVAL;
    private static int SCHED_STACK_DEPTH_THRESHOLD;
    private int _pgsCount = 0;
    private int _policyRevisitClock = SCHED_POLICY_REVISIT_INTERVAL;
    private int _lastDequeSize = 0;
    private int _sched_policy = 10;
    private final Deque<ContinuationFrame> _wfDeque;
    private final Deque<BfAsyncFrame> _hfDeque;
    private final Closure closure;
    private int numSteals = 0;
    private int numStealAttempts = 0;

    public Worker(int id, Closure initClosure) {
        this.id = id;
        this.index = id * 16;
        this.closure = initClosure != null ? initClosure : new Closure();
        this._hfDeque = new DequeNoLeak<BfAsyncFrame>(BfAsyncFrame.Abort);
        this._wfDeque = new DequeNoLeak<ContinuationFrame>(ContinuationFrame.Abort);
        this.initializeAdaptiveParameters();
        if (WstConfiguration.POLICY == 'h') {
            this.set_sched_policy(10);
        } else if (WstConfiguration.POLICY == 'w') {
            this.set_sched_policy(11);
        }
    }

    public void initializeAdaptiveParameters() {
        this.set_sched_policy(10);
        SCHED_SWITCHING_DEQUE_THRESHOLD = WstConfiguration.POLICY_DEQUE_LIMIT;
        if (WstConfiguration.NPROC > SCHED_SWITCHING_DEQUE_THRESHOLD) {
            SCHED_SWITCHING_DEQUE_THRESHOLD = WstConfiguration.NPROC;
        }
        if (WstConfiguration.NPROC > (SCHED_POLICY_REVISIT_INTERVAL = WstConfiguration.POLICY_INTERVAL)) {
            SCHED_POLICY_REVISIT_INTERVAL = WstConfiguration.NPROC;
        }
        SCHED_STACK_DEPTH_THRESHOLD = WstConfiguration.POLICY_STACK_DEPTH;
    }

    public void run() {
        Random rand = new Random(System.currentTimeMillis() + (long)this.id);
        WorkerExecutable work = null;
        if (this.closure.getFinishScope() != null) {
            work = new ContinuationFrame(this.closure);
        }
        int victimId = this.id;
        int numWorkers = Runtime.getNumWorkers();
        Worker victim = null;
        while (!Runtime.done) {
            if (work == null) {
                this.status = 1;
                if (WstConfiguration.REPORTING) {
                    Trace.line(10, this + " goes stealing");
                }
            }
            victimId = (int)(rand.nextDouble() * (double)numWorkers);
            int count = 0;
            while (work == null && !Runtime.done) {
                ++count;
                do {
                    if ((victimId = (victimId + 1) % numWorkers) == this.id) continue;
                    victim = Runtime.getWorker(victimId);
                } while (victim == null);
                work = victim.steal(this);
                if (WstConfiguration.REPORTING && work != null) {
                    Trace.line(10, this + " stole a work: " + work + " from " + victim);
                }
                if (work != null) continue;
            }
            if (Runtime.done) break;
            work = this.startWork(work);
            if (WstConfiguration.REPORTING) {
                Trace.line(0, this + " got provabaly good steal " + work);
            }
            if (work != null || WstConfiguration.POLICY != 'a') continue;
            ++this.PROFILE_reset;
            if (this.sched_policy() == 11) {
                ++this.PROFILE_reset_switch;
                if (SCHED_POLICY_REVISIT_INTERVAL <= 1) {
                    this.evaluateSchedulePolicy();
                } else {
                    this.set_sched_policy(10);
                }
            }
            this._lastDequeSize = 0;
            this._pgsCount = 0;
            this._policyRevisitClock = SCHED_POLICY_REVISIT_INTERVAL;
        }
    }

    private WorkerExecutable evaluateAllDelayedAsyncs() {
        for (FinishTreeNode finish : FinishTreeNode.FinishWithDelayedAsyncs) {
            DelayedAsync work;
            if (finish == null || (work = finish.evaluateDelayedAsyncs(this)) == null) continue;
            return work;
        }
        return null;
    }

    private WorkerExecutable startWork(WorkerExecutable executable) {
        this.status = 2;
        if (WstConfiguration.REPORTING) {
            String type = executable instanceof BfAsyncFrame ? "hfJob" : (executable instanceof ContinuationFrame ? "cont" : executable.getClass().toString());
            Trace.line(20, this + " starts working on " + executable + " (" + type + ")");
        }
        this.closure.initializeFromExecutable(executable);
        try {
            this.closure.stackDepth = 0;
            if (executable instanceof ContinuationFrame && ((ContinuationFrame)executable).head == null) {
                System.out.println("head is null");
            }
            executable.execute(this);
            this.status = 5;
            WorkerExecutable work = this.taskTerminating();
            if (WstConfiguration.REPORTING) {
                Trace.line(0, this + " terminates");
            }
            if (work != null) {
                return work;
            }
        }
        catch (WorkerBlockedException e) {
            this.status = 3;
            if (WstConfiguration.REPORTING) {
                Trace.line(0, this + " is blocked");
            }
            if (e.work != null) {
                return e.work;
            }
        }
        catch (WorkerAbortException e) {
            WorkerExecutable work;
            this.status = 4;
            if (WstConfiguration.REPORTING) {
                Trace.line(0, this + " aborts because of steal");
            }
            if ((work = this.taskTerminating()) != null) {
                return work;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Runtime.done = true;
            return null;
        }
        return this.findProvablyGoodSteal();
    }

    public void pushBfAsync(BfAsyncFrame frame) {
        FinishTreeNode finish = frame.getFinishScope();
        finish.incLocalCounter(this);
        this._hfDeque.pushBottom(frame);
        finish.fast = false;
        if (WstConfiguration.REPORTING) {
            Trace.line(0, this + " pushes hfJob " + frame + " to HfDeque");
        }
        ++this.PROFILE_help_first_asyncs;
        if (WstConfiguration.POLICY == 'a' && --this._policyRevisitClock <= 0) {
            this.evaluateSchedulePolicy();
        }
    }

    public void pushContinuation() {
        FinishTreeNode finish = this.getCurrentFinishScope();
        assert (this.closure.head != null) : this + " head is null";
        ContinuationFrame frame = new ContinuationFrame(this.closure);
        if (WstConfiguration.REPORTING) {
            Trace.line(0, this + " pushes wfFrame " + frame + " to WfDeque, head = " + this.closure.head);
        }
        this._wfDeque.pushBottom(frame);
        finish.incLocalCounter(this);
        this.closure.head = null;
        ++this.PROFILE_work_first_asyncs;
        if (WstConfiguration.POLICY == 'a' && --this._policyRevisitClock <= 0) {
            this.evaluateSchedulePolicy();
        }
    }

    public void popAndAbortOnSteal() throws WorkerAbortException {
        ContinuationFrame f = this._wfDeque.popBottom();
        if (f == null) {
            throw new WorkerAbortException();
        }
        if (WstConfiguration.REPORTING) {
            Trace.line(0, this + " popes wfFrame " + f + " from WfDeque");
        }
        f.getFinishScope().decLocalCounter(this);
        this.closure.head = f.head;
        ++this._pgsCount;
    }

    private void evaluateSchedulePolicy() {
        int size = this._hfDeque.size();
        ++this.PROFILE_eval;
        if (WstConfiguration.REPORTING) {
            Trace.line(3, this + " revisiting sched_policy: last_deque=" + this._lastDequeSize + " curr_size=" + size + " pgscount=" + this._pgsCount);
        }
        if (this.closure.stackDepth >= SCHED_STACK_DEPTH_THRESHOLD) {
            ++this.PROFILE_stack_bound;
            if (this.sched_policy() == 11) {
                ++this.PROFILE_stack_bound_switch;
                this.set_sched_policy(10);
            }
        } else if (size >= SCHED_SWITCHING_DEQUE_THRESHOLD) {
            ++this.PROFILE_task_bound;
            if (this.sched_policy() == 10) {
                ++this.PROFILE_task_bound_switch;
                this.set_sched_policy(11);
            }
        } else if (size + this._pgsCount >= this._lastDequeSize) {
            ++this.PROFILE_steal_rate_slow;
            if (this.sched_policy() == 10) {
                ++this.PROFILE_steal_rate_slow_switch;
                this.set_sched_policy(11);
            }
        } else {
            ++this.PROFILE_steal_rate_fast;
            if (this.sched_policy() == 11) {
                ++this.PROFILE_steal_rate_fast_switch;
                this.set_sched_policy(10);
            }
        }
        this._policyRevisitClock = SCHED_POLICY_REVISIT_INTERVAL;
        this._lastDequeSize = size;
        this._pgsCount = 0;
    }

    private WorkerExecutable steal(Worker thief) {
        FinishTreeNode finish;
        WorkerExecutable w;
        ++this.numStealAttempts;
        BfAsyncFrame o = this._hfDeque.steal();
        if (o == null || o.isAbort()) {
            ContinuationFrame c = this._wfDeque.steal();
            if (c == null || c.isAbort()) {
                return null;
            }
            w = c;
            finish = c.getFinishScope();
        } else {
            w = o;
            finish = o.getFinishScope();
        }
        finish.checkIn(thief);
        finish.incStealCounter(this);
        ++this.numSteals;
        return w;
    }

    private WorkerExecutable getMoreLocalWork(FinishTreeNode finish) {
        BfAsyncFrame b;
        ContinuationFrame c = this._wfDeque.popBottom();
        if (c != null) {
            if (c.getFinishScope() != finish) {
                this._wfDeque.pushBottom(c);
            } else {
                ++this._pgsCount;
                finish.decLocalCounter(this);
                return c;
            }
        }
        if ((b = this._hfDeque.popBottom()) != null) {
            if (b.getFinishScope() != finish) {
                this._hfDeque.pushBottom(b);
            } else {
                ++this._pgsCount;
                finish.decLocalCounter(this);
                return b;
            }
        }
        return null;
    }

    private WorkerExecutable findProvablyGoodSteal() {
        FinishTreeNode finish;
        WorkerExecutable f;
        BfAsyncFrame bf = this._hfDeque.popBottom();
        if (bf == null) {
            ContinuationFrame c = this._wfDeque.popBottom();
            if (c == null) {
                return null;
            }
            f = c;
            finish = c.getFinishScope();
        } else {
            f = bf;
            finish = bf.getFinishScope();
        }
        finish.checkIn(this);
        finish.decLocalCounter(this);
        ++this._pgsCount;
        return f;
    }

    private WorkerExecutable taskTerminating() {
        FinishTreeNode finish = this.closure.getFinishScope();
        WorkerExecutable f = this.getMoreLocalWork(finish);
        if (f != null) {
            return f;
        }
        if (finish.checkOut(this) == 0 && finish.verifyComplete()) {
            if (WstConfiguration.SUPPORT_DELAYED_ASYNCS && (f = finish.evaluateDelayedAsyncs(this)) != null) {
                return f;
            }
            if (WstConfiguration.REPORTING) {
                Trace.line(0, finish + " is verified to be complete");
            }
            if (finish.completeForContinuation()) {
                if (WstConfiguration.REPORTING) {
                    Trace.line(0, this + " won the continuation after " + finish);
                }
                if (finish.suspendedContinuation == null) {
                    Runtime.done = true;
                }
                return finish.suspendedContinuation;
            }
        }
        return null;
    }

    public void startFinish() {
        Closure c = this.closure;
        c.setFinishScope(new FinishTreeNode(c.getFinishScope(), this));
    }

    public void stopFinish() throws WorkerBlockedException {
        FinishTreeNode finish = this.getCurrentFinishScope();
        if (finish.fast) {
            this.stopFinishFast();
        } else {
            this.stopFinishSlow();
        }
    }

    public void stopFinishFast() {
        this.closure.setFinishScope(this.closure.getFinishScope().parent);
    }

    public boolean stopFinishSlow() throws WorkerBlockedException {
        Closure c = this.closure;
        FinishTreeNode finish = c.getFinishScope();
        c.setFinishScope(finish.parent);
        assert (c.head != null) : "closure.head is null";
        finish.suspendedContinuation = new ContinuationFrame(c);
        WorkerExecutable f = this.getMoreLocalWork(finish);
        if (f == null) {
            if (WstConfiguration.REPORTING) {
                Trace.line(0, this + " completes all local task under " + finish);
            }
            if (finish.checkOut(this) == 0 && finish.verifyComplete() && finish.completeForContinuation()) {
                if (finish == FinishTreeNode.mainFinishScope) {
                    Runtime.done = true;
                }
                return true;
            }
        }
        this.status = 3;
        if (WstConfiguration.REPORTING) {
            Trace.line(0, this + " suspended on finish " + finish + " suspended closure = " + c);
        }
        throw new WorkerBlockedException(f);
    }

    public void set_sched_policy(int _sched_policy) {
        this._sched_policy = _sched_policy;
    }

    public int sched_policy() {
        return this._sched_policy;
    }

    public int getNumSteals() {
        return this.numSteals;
    }

    public int getNumStealAttempts() {
        return this.numStealAttempts;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public FinishTreeNode getCurrentFinishScope() {
        return this.closure.getFinishScope();
    }

    public String toString() {
        return "Worker " + this.id;
    }

    public void startTimer() {
        Runtime.startTimer();
    }

    public void stopTimer() {
        Runtime.stopTimer();
    }

    public void beginMethod(ActivationFrame af) {
        ++this.closure.stackDepth;
        af.next = this.closure.head;
        this.closure.head = af;
    }

    public void endMethodFast() {
        --this.closure.stackDepth;
        this.closure.head = this.closure.head.next;
    }

    public void endMethodSlow() throws WorkerException {
        assert (this.closure.head != null) : this + "'s head is null";
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            ++this.closure.stackDepth;
            this.closure.head.execute(this);
            --this.closure.stackDepth;
        }
        --this.closure.stackDepth;
    }

    public void endMethodSlow(Object retObject) throws WorkerException {
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            if (retObject != null) {
                this.closure.head.setReturnResult(retObject);
            }
            this.closure.head.execute(this);
        } else assert (retObject == null);
    }

    public void pushDelayedAsync(DelayedAsync frame) {
        if (frame.isReady()) {
            if (WstConfiguration.REPORTING) {
                Trace.line(20, this + ": push delayed async: " + frame + " (ready)");
            }
            this.pushBfAsync(frame);
        } else {
            if (WstConfiguration.REPORTING) {
                Trace.line(20, this + ": push delayed async: " + frame + " (not ready)");
            }
            FinishTreeNode finish = frame.getFinishScope();
            finish.addDelayedAsync(frame);
        }
    }

    public Place place() {
        return null;
    }
}

