/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.NullableType_c;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayAccess1_c
extends Expr_c
implements HjArrayAccess1 {
    protected Expr array;
    protected Expr index;

    public HjArrayAccess1_c(Position pos, Expr array, Expr index) {
        super(pos);
        this.array = array;
        this.index = index;
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    @Override
    public Expr array() {
        return this.array;
    }

    @Override
    public HjArrayAccess1 array(Expr array) {
        HjArrayAccess1_c n = (HjArrayAccess1_c)this.copy();
        n.array = array;
        return n;
    }

    @Override
    public Expr index() {
        return this.index;
    }

    @Override
    public HjArrayAccess1 index(Expr index) {
        HjArrayAccess1_c n = (HjArrayAccess1_c)this.copy();
        n.index = index;
        return n;
    }

    public Flags flags() {
        return Flags.NONE;
    }

    protected HjArrayAccess1_c reconstruct(Expr array, Expr index) {
        if (array != this.array || index != this.index) {
            HjArrayAccess1_c n = (HjArrayAccess1_c)this.copy();
            n.array = array;
            n.index = index;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr array = (Expr)this.visitChild((Node)this.array, v);
        Expr index = (Expr)this.visitChild((Node)this.index, v);
        return this.reconstruct(array, index);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        Type type = this.array.type();
        if (type instanceof NullableType_c) {
            type = ((NullableType_c)type).base();
        }
        boolean isArray = type.isArray();
        boolean isIndexable = ts.isIndexable(type);
        if (!isArray && !isIndexable) {
            throw new SemanticException("Subscript can only follow an array type, and not " + type + ".", this.position());
        }
        if (isArray) {
            return nf.ArrayAccess(this.position(), this.array, this.index).del().typeCheck(tc);
        }
        if (!ts.isImplicitCastValid(this.index.type(), (Type)ts.point()) && !this.index.type().isInt()) {
            throw new SemanticException("Array subscript |" + this.toString() + "| must be an integer or a point.", this.position());
        }
        LinkedList<Expr> args = new LinkedList<Expr>();
        args.add(this.index);
        HjType pt = (HjType)type;
        if (pt.isParametric()) {
            List<Type> params = pt.typeParameters();
            Type param = params.get(0);
            return this.type(param);
        }
        HjClassType refType = (HjClassType)((Object)(type instanceof NullableType ? ((NullableType)type).base() : type));
        Type retType = ts.baseType(refType);
        return this.type(retType);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        HjTypeSystem ts = (HjTypeSystem)av.typeSystem();
        if (child == this.index) {
            return ts.Int();
        }
        if (child == this.array) {
            return ts.array(this.type);
        }
        return child.type();
    }

    public String toString() {
        HjType pt = (HjType)this.type;
        String result = "";
        if (pt != null && pt.isParametric()) {
            Type type = pt.typeParameters().get(0);
            result = "(" + type + ")";
        }
        return result + this.array + ".get(" + this.index + ")";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        assert (false);
        HjType at = (HjType)this.array.type();
        if (at.isParametric()) {
            Type result = at.typeParameters().get(0);
            w.write("((");
            this.print((Node)new HjCanonicalTypeNode_c(Position.COMPILER_GENERATED, result), w, tr);
            w.write(")");
        }
        this.printSubExpr(this.array, w, tr);
        w.write(".get(");
        this.printBlock((Node)this.index, w, tr);
        w.write(")");
        if (at.isParametric()) {
            w.write(")");
        }
    }

    public Term entry() {
        return this.array.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.array, this.index.entry());
        v.visitCFG((Term)this.index, (Term)this);
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        return CollectionUtil.list((Object)ts.OutOfBoundsException(), (Object)ts.NullPointerException());
    }

    @Override
    public List<Expr> indexList() {
        ArrayList<Expr> il = new ArrayList<Expr>();
        il.add(this.index());
        return il;
    }
}

