/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import polyglot.ast.Binary;
import polyglot.ast.Block;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Field_c;
import polyglot.ast.FloatLit;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Instanceof;
import polyglot.ast.IntLit;
import polyglot.ast.Lit;
import polyglot.ast.Lit_c;
import polyglot.ast.Local;
import polyglot.ast.Local_c;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Return;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.DepCast;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.HjBinary;
import polyglot.ext.hj.ast.HjCastInfo;
import polyglot.ext.hj.ast.HjDepCastInfo;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.ast.HjUnary_c;
import polyglot.ext.hj.ast.ParExpr;
import polyglot.ext.hj.ast.ParExpr_c;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjPrimitiveType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.frontend.Job;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class HjCaster
extends AscriptionVisitor {
    HjTypeSystem xts;
    boolean castCheckClassNotLoaded = true;
    private static String RUNTIME_CAST_CHECKER_CLASSNAME = "hj.runtime.wsh.RuntimeCastChecker";
    private static String RUNTIME_CAST_CHECKER_CONSTRAINT_CLASSNAME = "hj.runtime.wsh.RuntimeConstraint";

    public HjCaster(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.xts = (HjTypeSystem)ts;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        return super.leave(old, n, v);
    }

    protected Node leaveCall(Node n) throws SemanticException {
        return super.leaveCall(n);
    }

    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        Type fromType = e.type();
        Expr ret_notype = e;
        boolean complexCast = false;
        if (this.castCheckClassNotLoaded) {
            ((Type)this.ts.systemResolver().find(RUNTIME_CAST_CHECKER_CLASSNAME)).toClass();
            this.castCheckClassNotLoaded = false;
        }
        if (toType == null) {
            return e;
        }
        Position p = e.position();
        if (this.xts.isComplex64(toType) && this.xts.isComplex32(fromType)) {
            TypeBuilder tb = new TypeBuilder(this.job, this.ts, this.nf);
            AmbiguityRemover ar = new AmbiguityRemover(this.job, this.ts, this.nf);
            TypeChecker tc = new TypeChecker(this.job, this.ts, this.nf);
            tb = tb.pushContext(this.context());
            ar = (AmbiguityRemover)ar.context(this.context());
            tc = (TypeChecker)tc.context(this.context());
            Cast newCast = this.nf.Cast(p, (TypeNode)this.nf.CanonicalTypeNode(p, toType), e);
            return (Expr)newCast.visit((NodeVisitor)tb).visit((NodeVisitor)ar).visit((NodeVisitor)tc);
        }
        if (e instanceof Cast || e instanceof Instanceof) {
            TypeBuilder tb = new TypeBuilder(this.job, this.ts, this.nf);
            AmbiguityRemover ar = new AmbiguityRemover(this.job, this.ts, this.nf);
            TypeChecker tc = new TypeChecker(this.job, this.ts, this.nf);
            tb = tb.pushContext(this.context());
            ar = (AmbiguityRemover)ar.context(this.context());
            tc = (TypeChecker)tc.context(this.context());
            HjCastInfo cast = (HjCastInfo)ret_notype;
            if (cast.isToTypeNullable()) {
                if (e instanceof Instanceof && cast.expr().type().isNull()) {
                    return (Expr)this.nf.BooleanLit(p, false).visit((NodeVisitor)tc);
                }
                if (e instanceof Cast && cast.expr().type().isNull()) {
                    return (Expr)this.nf.NullLit(p).visit((NodeVisitor)tc);
                }
            }
            if (cast.isDepTypeCheckingNeeded()) {
                HjCastInfo castOrInstanceof = (HjCastInfo)e;
                boolean codeIsInlinable = HjCastHelper.isSideEffectFree(castOrInstanceof.expr());
                AbstractRuntimeChecking mc = e instanceof DepCast ? (codeIsInlinable ? new InlineCastChecking(tb, ar, tc, p) : new InnerClassCastChecking(tb, ar, tc, p)) : (codeIsInlinable ? new InlineInstanceofChecking(tb, ar, tc, p) : new InnerClassInstanceofChecking(tb, ar, tc, p));
                Expr runtimeCheckingExpr = (Expr)mc.getRuntimeCheckingExpression((HjCastInfo)e);
                return runtimeCheckingExpr;
            }
            if (cast.notNullRequired() && e instanceof Cast) {
                InlineCastChecking mc = new InlineCastChecking(tb, ar, tc, p);
                return mc.checking.getNonNullableCheckingExpr(ret_notype);
            }
        }
        return e;
    }

    public static class HjCastHelper {
        public static Expr getNestedExpression(Expr source) {
            if (source instanceof ParExpr_c) {
                Expr nestedExpr = source;
                while (nestedExpr instanceof ParExpr_c) {
                    nestedExpr = ((ParExpr_c)nestedExpr).expr();
                }
                return nestedExpr;
            }
            return source;
        }

        public static boolean isSideEffectFree(Expr exprToCast) {
            Expr nestedExpression = HjCastHelper.getNestedExpression(exprToCast);
            if (nestedExpression instanceof Field_c) {
                return HjCastHelper.isSideEffectFree((Expr)((Field_c)nestedExpression).target());
            }
            return nestedExpression instanceof Local_c || nestedExpression instanceof Lit_c;
        }
    }

    private class ConstraintBuilder {
        private Constraint declaredConstraint;
        private Expr self;

        public Expr buildConstraint(Expr self, Constraint declaredConstraint, DepParameterExpr expr) throws SemanticException {
            this.declaredConstraint = declaredConstraint;
            Expr constraintExpr = expr.condition();
            this.self = self;
            assert (self != null);
            HjBinary b = (HjBinary)(constraintExpr instanceof HjBinary ? constraintExpr : this.makeBinary(constraintExpr));
            return this.visit(b);
        }

        private Expr visit(Expr constraintExpr) throws SemanticException {
            if (constraintExpr instanceof HjBinary) {
                return this.visit((HjBinary)constraintExpr);
            }
            if (constraintExpr instanceof Field) {
                return this.visit((Field)constraintExpr);
            }
            if (constraintExpr instanceof Lit || constraintExpr instanceof HjUnary_c || constraintExpr instanceof Local) {
                return this.visitWithoutChanging(constraintExpr);
            }
            if (constraintExpr instanceof HjSpecial) {
                return this.visit((HjSpecial)constraintExpr);
            }
            throw new SemanticException("Unhandled expression of type " + constraintExpr.getClass());
        }

        private boolean isBinary(Expr expr) {
            return expr instanceof HjBinary;
        }

        private HjBinary makeBinary(Field f) throws SemanticException {
            Expr constraintRightValue = this.constraintToExpr(this.declaredConstraint.find(f.name()), f.position());
            return (HjBinary)((HjNodeFactory)HjCaster.this.nf).Binary(f.position(), (Expr)f, HjBinary.EQ, constraintRightValue);
        }

        private HjBinary makeBinary(Expr expr) throws SemanticException {
            if (expr instanceof Field) {
                return this.makeBinary((Field)expr);
            }
            throw new SemanticException("Can't convert expr of type " + expr.type() + " to binary expression");
        }

        private Expr visit(HjBinary binary) throws SemanticException {
            binary = (HjBinary)binary.left(this.visit(binary.left()));
            if ((binary = (HjBinary)binary.right(this.visit(binary.right()))).operator() == Binary.EQ) {
                return new ParExpr_c(binary.position(), (Expr)binary);
            }
            return binary;
        }

        private Expr visitWithoutChanging(Expr expr) throws SemanticException {
            return expr;
        }

        private Expr visit(Field field) throws SemanticException {
            if (field.target() instanceof HjSpecial && ((HjSpecial)field.target()).kind() == HjSpecial.SELF) {
                return HjCaster.this.nf.Call(field.position(), (Receiver)this.self, field.name());
            }
            if (field.target() instanceof HjSpecial && ((HjSpecial)field.target()).kind() == HjSpecial.THIS) {
                Special thisTarget = HjCaster.this.nf.This(field.position(), HjCaster.this.nf.TypeNodeFromQualifiedName(field.position(), ((HjParsedClassType)field.fieldInstance().container()).name()));
                return HjCaster.this.nf.Field(field.position(), (Receiver)thisTarget, field.name());
            }
            return field;
        }

        private Expr visit(HjSpecial special) throws SemanticException {
            return this.self;
        }

        private Expr constraintToExpr(C_Term term, Position p) throws SemanticException {
            if (term instanceof C_Lit) {
                C_Lit lit = (C_Lit)term;
                if (lit.type().isInt()) {
                    return HjCaster.this.nf.IntLit(p, IntLit.INT, (long)((Number)lit.val()).intValue());
                }
                if (lit.type().isLong()) {
                    return HjCaster.this.nf.IntLit(p, IntLit.LONG, ((Number)lit.val()).longValue());
                }
                if (lit.type().isDouble()) {
                    return HjCaster.this.nf.FloatLit(p, FloatLit.DOUBLE, ((Number)lit.val()).doubleValue());
                }
                if (lit.type().isFloat()) {
                    return HjCaster.this.nf.FloatLit(p, FloatLit.FLOAT, (double)((Number)lit.val()).floatValue());
                }
                if (lit.type().isBoolean()) {
                    return HjCaster.this.nf.BooleanLit(p, ((Boolean)lit.val()).booleanValue());
                }
            }
            throw new SemanticException("Unsupported runtime constraint " + term);
        }
    }

    private class NullableCheckInstanceofBuilder
    extends NullableCheckBuilder {
        public NullableCheckInstanceofBuilder(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p);
        }

        public Expr buildNullableChecking(Expr exprToReturn, boolean mustBeNotNull, boolean toTypeIsNullable, Expr constraintExpr, TypeNode toType) {
            HjNodeFactory xnf = (HjNodeFactory)HjCaster.this.nf;
            ParExpr isAssignable = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Call(this.p, (Receiver)HjCaster.this.nf.ClassLit(this.p, toType), "isAssignableFrom", (Expr)HjCaster.this.nf.Call(this.p, (Receiver)exprToReturn, "getClass")));
            Object retExpr = HjCaster.this.nf.Binary(this.p, (Expr)isAssignable, Binary.COND_AND, constraintExpr);
            if (mustBeNotNull || toTypeIsNullable) {
                ParExpr isExprNotNull = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Binary(this.p, exprToReturn, Binary.NE, (Expr)HjCaster.this.nf.Cast(this.p, (TypeNode)xnf.Nullable(this.p, (TypeNode)HjCaster.this.nf.CanonicalTypeNode(this.p, exprToReturn.type())), (Expr)HjCaster.this.nf.NullLit(this.p))));
                retExpr = HjCaster.this.nf.Binary(this.p, (Expr)isExprNotNull, Binary.COND_AND, (Expr)retExpr);
            }
            retExpr = ((HjNodeFactory)HjCaster.this.nf).ParExpr(this.p, (Expr)retExpr);
            return retExpr;
        }
    }

    private class NullableCheckCastBuilder
    extends NullableCheckBuilder {
        public NullableCheckCastBuilder(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p);
        }

        public Expr buildNullableChecking(Expr exprToReturn, boolean mustBeNotNull, boolean toTypeIsNullable, Expr constraintExpr, TypeNode toType) {
            HjNodeFactory xnf = (HjNodeFactory)HjCaster.this.nf;
            constraintExpr = xnf.ParExpr(this.p, constraintExpr);
            Cast castExprToReturn = HjCaster.this.nf.Cast(this.p, toType, exprToReturn);
            Expr retExpr = this.constraintCheckingExpr((Expr)castExprToReturn, constraintExpr, toType);
            if (mustBeNotNull) {
                Expr nestedCondition = retExpr;
                ParExpr firstCondition = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Binary(this.p, exprToReturn, Binary.NE, (Expr)HjCaster.this.nf.Cast(this.p, (TypeNode)xnf.Nullable(this.p, (TypeNode)HjCaster.this.nf.CanonicalTypeNode(this.p, exprToReturn.type())), (Expr)HjCaster.this.nf.NullLit(this.p))));
                Cast firstAlternative = HjCaster.this.nf.Cast(this.p, toType, this.throwClassCastExceptionExpr(this.p, exprToReturn, "Cannot cast a null instance to a non nullable type"));
                retExpr = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Conditional(this.p, (Expr)firstCondition, nestedCondition, (Expr)firstAlternative));
                return retExpr;
            }
            if (toTypeIsNullable) {
                ParExpr conditionLeft = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Binary(this.p, exprToReturn, Binary.EQ, (Expr)HjCaster.this.nf.Cast(this.p, (TypeNode)xnf.Nullable(this.p, (TypeNode)HjCaster.this.nf.CanonicalTypeNode(this.p, exprToReturn.type())), (Expr)HjCaster.this.nf.NullLit(this.p))));
                ParExpr condition = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Binary(this.p, (Expr)conditionLeft, Binary.COND_OR, constraintExpr));
                ParExpr alternative = xnf.ParExpr(this.p, (Expr)HjCaster.this.nf.Cast(this.p, toType, this.throwClassCastExceptionExpr(this.p, exprToReturn, "Constraint not meet")));
                retExpr = HjCaster.this.nf.Conditional(this.p, (Expr)condition, (Expr)castExprToReturn, (Expr)alternative);
            }
            retExpr = xnf.ParExpr(this.p, retExpr);
            return retExpr;
        }

        private Expr constraintCheckingExpr(Expr castExpr, Expr constraintExpr, TypeNode toType) {
            Expr nestedConsequence = castExpr;
            Cast nestedAlternative = HjCaster.this.nf.Cast(this.p, toType, this.throwClassCastExceptionExpr(this.p, castExpr, "Constraint is not meet"));
            return HjCaster.this.nf.Conditional(this.p, constraintExpr, nestedConsequence, (Expr)nestedAlternative);
        }

        private Expr throwClassCastExceptionExpr(Position p, Expr exprToCast, String errorMsg) {
            return HjCaster.this.nf.Call(p, (Receiver)this.getRuntimeCheckingClassName(p), "throwClassCastException", exprToCast, (Expr)HjCaster.this.nf.StringLit(p, errorMsg));
        }
    }

    private abstract class NullableCheckBuilder
    extends Builder {
        public NullableCheckBuilder(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p);
        }

        public abstract Expr buildNullableChecking(Expr var1, boolean var2, boolean var3, Expr var4, TypeNode var5);

        protected TypeNode getRuntimeCheckingClassName(Position p) {
            return HjCaster.this.nf.TypeNodeFromQualifiedName(p, RUNTIME_CAST_CHECKER_CLASSNAME);
        }
    }

    private class Builder {
        protected TypeBuilder tb;
        protected AmbiguityRemover ar;
        protected TypeChecker tc;
        protected Position p;

        public Builder(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            this.tb = tb;
            this.ar = ar;
            this.tc = tc;
            this.p = p;
        }
    }

    private class InlineCastChecking
    extends InlineChecking {
        public InlineCastChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p, new CastChecking(tb, ar, tc, p));
        }
    }

    private class InlineInstanceofChecking
    extends InlineChecking {
        public InlineInstanceofChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p, new InstanceofChecking(tb, ar, tc, p));
        }
    }

    protected abstract class InlineChecking
    extends AbstractRuntimeChecking {
        protected ConstraintBuilder constraintBuilder;
        protected NullableCheckBuilder nullableCheckBuilder;

        public InlineChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p, Checking checking) {
            super(tb, ar, tc, p, checking);
            this.constraintBuilder = this.checking.getConstraintBuilder();
            this.nullableCheckBuilder = this.checking.getNullableCheckBuilder();
        }

        public Node getRuntimeCheckingExpression(HjCastInfo castOrInstanceof) throws SemanticException {
            Cast exprToCheck;
            Expr objToCast = castOrInstanceof.expr();
            Expr incomingExpr = castOrInstanceof.expr();
            TypeNode destType = this.checking.getToTypeRootType(castOrInstanceof);
            Cast castedExpr = HjCaster.this.nf.Cast(this.p, destType, objToCast);
            TypeNode checkingConstrainedType = this.checking.getToType(castOrInstanceof);
            boolean notNullRequired = castOrInstanceof.notNullRequired();
            boolean isToTypeNullable = castOrInstanceof.isToTypeNullable();
            boolean isBoxedCode = ((HjTypeSystem)HjCaster.this.ts).isBoxedType(this.checking.getToType(castOrInstanceof).type());
            if (isBoxedCode) {
                NullableType nullType;
                HjType incomingExprType = (HjType)incomingExpr.type();
                if (HjCaster.this.xts.isNullable(incomingExprType) && (nullType = (NullableType)incomingExprType).base().isPrimitive()) {
                    nullType = nullType.base(HjCaster.this.xts.boxedType((HjPrimitiveType)nullType.base()));
                    incomingExpr = incomingExpr.type((Type)nullType);
                }
                exprToCheck = HjCaster.this.nf.Call(this.p, (Receiver)castedExpr, ((HjTypeSystem)HjCaster.this.ts).getGetterName(destType.type()));
            } else {
                exprToCheck = castedExpr;
            }
            Expr exprToReturn = objToCast.type(incomingExpr.type());
            Expr constraintCheckExpr = this.constraintBuilder.buildConstraint(((HjNodeFactory)HjCaster.this.nf).ParExpr(this.p, (Expr)exprToCheck), this.getConstraintsToCheck(checkingConstrainedType), ((HjDepCastInfo)castOrInstanceof).depParameterExpr());
            if (destType.type().isPrimitive()) {
                notNullRequired = false;
                isToTypeNullable = false;
            }
            Expr nullableCheckExpr = this.nullableCheckBuilder.buildNullableChecking(exprToReturn, notNullRequired, isToTypeNullable, constraintCheckExpr, destType);
            this.tb = this.tb.pushCode();
            Node runtimeCheckingNode = this.checkExpression((Node)nullableCheckExpr);
            return runtimeCheckingNode;
        }
    }

    private class InnerClassCastChecking
    extends InnerClassChecking {
        public InnerClassCastChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p, new CastChecking(tb, ar, tc, p));
        }
    }

    private class InnerClassInstanceofChecking
    extends InnerClassChecking {
        public InnerClassInstanceofChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p, new InstanceofChecking(tb, ar, tc, p));
        }
    }

    private class CastChecking
    extends Checking {
        public CastChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p);
        }

        public TypeNode getToType(HjCastInfo castOrInstanceof) {
            return castOrInstanceof.getTypeNode();
        }

        public Expr getExprToCast(HjCastInfo castOrInstanceof) {
            return castOrInstanceof.expr();
        }

        protected Expr finalizeRuntimeCheckingExpr(Expr castNode, Expr runtimeCheckingExpr) throws SemanticException {
            Cast newCast = HjCaster.this.nf.Cast(this.p, ((HjCastInfo)castNode).getTypeNode(), runtimeCheckingExpr);
            newCast = (Cast)this.checkExpression((Node)newCast);
            return newCast;
        }

        protected Id runtimeCheckingToNonNullableMethodName() throws SemanticException {
            return HjCaster.this.nf.Id(this.p, "checkCastToNonNullable");
        }

        public NullableCheckBuilder getNullableCheckBuilder() {
            return new NullableCheckCastBuilder(this.tb, this.ar, this.tc, this.p);
        }

        public TypeNode getExprReturnType(HjCastInfo castOrInstanceof) {
            return this.getToTypeRootType(castOrInstanceof);
        }
    }

    private class InstanceofChecking
    extends Checking {
        public InstanceofChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            super(tb, ar, tc, p);
        }

        public TypeNode getToType(HjCastInfo castOrInstanceof) {
            return ((Instanceof)castOrInstanceof).compareType();
        }

        public Expr getExprToCast(HjCastInfo castOrInstanceof) {
            return castOrInstanceof.expr();
        }

        protected Expr finalizeRuntimeCheckingExpr(Expr castNode, Expr runtimeCheckingExpr) throws SemanticException {
            return runtimeCheckingExpr;
        }

        protected Id runtimeCheckingToNonNullableMethodName() throws SemanticException {
            throw new SemanticException("Compiler error: Runtime Checking to non nullable is not implemented, and should be the regular java instanceof code");
        }

        public NullableCheckBuilder getNullableCheckBuilder() {
            return new NullableCheckInstanceofBuilder(this.tb, this.ar, this.tc, this.p);
        }

        public TypeNode getExprReturnType(HjCastInfo castOrInstanceof) {
            return HjCaster.this.nf.CanonicalTypeNode(this.p, (Type)HjCaster.this.ts.Boolean());
        }
    }

    private abstract class Checking {
        protected TypeBuilder tb;
        protected AmbiguityRemover ar;
        protected TypeChecker tc;
        protected Position p;

        public Checking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p) {
            this.tb = tb;
            this.ar = ar;
            this.tc = tc;
            this.p = p;
        }

        public abstract TypeNode getExprReturnType(HjCastInfo var1);

        protected abstract Id runtimeCheckingToNonNullableMethodName() throws SemanticException;

        public abstract TypeNode getToType(HjCastInfo var1);

        public abstract Expr getExprToCast(HjCastInfo var1);

        protected abstract Expr finalizeRuntimeCheckingExpr(Expr var1, Expr var2) throws SemanticException;

        public abstract NullableCheckBuilder getNullableCheckBuilder();

        public TypeNode getToTypeRootType(HjCastInfo castOrInstanceof) {
            HjType baseType = ((HjType)castOrInstanceof.getTypeNode().type()).rootType();
            if (((HjTypeSystem)HjCaster.this.ts).isNullable(baseType)) {
                baseType = ((NullableType)baseType).base();
            }
            return HjCaster.this.nf.CanonicalTypeNode(this.p, (Type)baseType);
        }

        protected Cast getAsCast(HjCastInfo castOrInstanceof) {
            return HjCaster.this.nf.Cast(this.p, this.getToType(castOrInstanceof), this.getExprToCast(castOrInstanceof));
        }

        protected Node checkExpression(Node n) {
            return n.visit((NodeVisitor)this.tb).visit((NodeVisitor)this.ar).visit((NodeVisitor)this.tc);
        }

        public Expr getNonNullableCheckingExpr(Expr checkingNode) throws SemanticException {
            ArrayList<Object> methodArgs = new ArrayList<Object>();
            Expr exprToCheck = ((HjCastInfo)checkingNode).expr();
            methodArgs.add((Expr)exprToCheck.copy());
            methodArgs.add(HjCaster.this.nf.ClassLit(this.p, ((HjCastInfo)checkingNode).getTypeNode()));
            Call checkNullableCall = HjCaster.this.nf.Call(this.p, (Receiver)this.getRuntimeCheckingClassName(), this.runtimeCheckingToNonNullableMethodName(), methodArgs);
            checkNullableCall = (Call)this.checkExpression((Node)checkNullableCall);
            return this.finalizeRuntimeCheckingExpr(checkingNode, (Expr)checkNullableCall);
        }

        protected TypeNode getRuntimeCheckingClassName() {
            return HjCaster.this.nf.TypeNodeFromQualifiedName(this.p, RUNTIME_CAST_CHECKER_CLASSNAME);
        }

        public ConstraintBuilder getConstraintBuilder() {
            return new ConstraintBuilder();
        }
    }

    protected abstract class InnerClassChecking
    extends AbstractRuntimeChecking {
        private static final String OBJ_TO_CAST = "hj_generated_objToCast";
        protected ConstraintBuilder constraintBuilder;
        protected NullableCheckBuilder nullableCheckBuilder;

        public InnerClassChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p, Checking checking) {
            super(tb, ar, tc, p, checking);
            this.constraintBuilder = this.checking.getConstraintBuilder();
            this.nullableCheckBuilder = this.checking.getNullableCheckBuilder();
        }

        public Node getRuntimeCheckingExpression(HjCastInfo castOrInstanceof) throws SemanticException {
            Cast exprToCheck;
            Expr incomingExpr = castOrInstanceof.expr();
            Local objToCast = HjCaster.this.nf.Local(this.p, OBJ_TO_CAST);
            TypeNode destType = this.checking.getToTypeRootType(castOrInstanceof);
            Cast castedExpr = HjCaster.this.nf.Cast(this.p, destType, (Expr)objToCast);
            TypeNode checkingConstrainedType = this.checking.getToType(castOrInstanceof);
            boolean notNullRequired = castOrInstanceof.notNullRequired();
            boolean isToTypeNullable = castOrInstanceof.isToTypeNullable();
            boolean isBoxedCode = ((HjTypeSystem)HjCaster.this.ts).isBoxedType(this.checking.getToType(castOrInstanceof).type());
            if (isBoxedCode) {
                NullableType nullType;
                HjType incomingExprType = (HjType)incomingExpr.type();
                if (HjCaster.this.xts.isNullable(incomingExprType) && (nullType = (NullableType)incomingExprType).base().isPrimitive()) {
                    nullType = nullType.base(HjCaster.this.xts.boxedType((HjPrimitiveType)nullType.base()));
                    incomingExpr = incomingExpr.type((Type)nullType);
                }
                CanonicalTypeNode checkingType = HjCaster.this.nf.CanonicalTypeNode(this.p, ((HjTypeSystem)HjCaster.this.ts).boxedTypeToPrimitiveType(destType.type()));
                exprToCheck = HjCaster.this.nf.Call(this.p, (Receiver)castedExpr, ((HjTypeSystem)HjCaster.this.ts).getGetterName(destType.type()));
            } else {
                TypeNode checkingType = destType;
                exprToCheck = castedExpr;
            }
            Expr exprToReturn = objToCast.type(incomingExpr.type());
            Expr constraintCheckExpr = this.constraintBuilder.buildConstraint(((HjNodeFactory)HjCaster.this.nf).ParExpr(this.p, (Expr)exprToCheck), this.getConstraintsToCheck(checkingConstrainedType), ((HjDepCastInfo)castOrInstanceof).depParameterExpr());
            if (destType.type().isPrimitive()) {
                notNullRequired = false;
                isToTypeNullable = false;
            }
            Expr nullableCheckExpr = this.nullableCheckBuilder.buildNullableChecking(exprToReturn, notNullRequired, isToTypeNullable, constraintCheckExpr, destType);
            LinkedList<Return> statements = new LinkedList<Return>();
            statements.add(HjCaster.this.nf.Return(this.p, nullableCheckExpr));
            Block methodBody = HjCaster.this.nf.Block(this.p, statements);
            CanonicalTypeNode paramType = destType.type().isPrimitive() ? HjCaster.this.nf.CanonicalTypeNode(this.p, destType.type()) : HjCaster.this.nf.CanonicalTypeNode(this.p, incomingExpr.type());
            LinkedList<Formal> paramFormalList = new LinkedList<Formal>();
            Formal mthParamFormal = HjCaster.this.nf.Formal(this.p, Flags.FINAL, (TypeNode)paramType, OBJ_TO_CAST);
            paramFormalList.add(mthParamFormal);
            MethodDecl checkCastMethod = HjCaster.this.nf.MethodDecl(this.p, Flags.PUBLIC, this.checking.getExprReturnType(castOrInstanceof), "checkCast", paramFormalList, Collections.EMPTY_LIST, methodBody);
            LinkedList<MethodDecl> classBodyMembers = new LinkedList<MethodDecl>();
            classBodyMembers.add(checkCastMethod);
            ClassBody classBody = HjCaster.this.nf.ClassBody(this.p, classBodyMembers);
            TypeNode anonClassName = HjCaster.this.nf.TypeNodeFromQualifiedName(this.p, "hj.runtime.wsh.RuntimeCastChecker.DepTypeRuntimeChecking");
            New newAnonClass = HjCaster.this.nf.New(this.p, anonClassName, Collections.EMPTY_LIST, classBody);
            if (isBoxedCode) {
                incomingExpr = HjCaster.this.nf.Cast(this.p, destType, incomingExpr);
            }
            Call checkingCall = HjCaster.this.nf.Call(this.p, (Receiver)newAnonClass, "checkCast", incomingExpr);
            this.tb = this.tb.pushCode();
            Node runtimeCheckingNode = this.checkExpression((Node)checkingCall);
            return runtimeCheckingNode;
        }
    }

    private abstract class AbstractRuntimeChecking {
        protected TypeBuilder tb;
        protected AmbiguityRemover ar;
        protected TypeChecker tc;
        protected Position p;
        protected Checking checking;
        protected static final String CHECK_CAST_MTH_NAME = "checkCast";
        protected static final String Hj_RUNTIME_NESTED_CONSTRAINT = "hj.runtime.wsh.RuntimeCastChecker.DepTypeRuntimeChecking";

        public AbstractRuntimeChecking(TypeBuilder tb, AmbiguityRemover ar, TypeChecker tc, Position p, Checking checking) {
            this.tb = tb;
            this.ar = ar;
            this.tc = tc;
            this.p = p;
            this.checking = checking;
        }

        protected Node checkExpression(Node n) {
            return n.visit((NodeVisitor)this.tb).visit((NodeVisitor)this.ar).visit((NodeVisitor)this.tc);
        }

        protected TypeNode getRuntimeCheckingClassName() {
            return HjCaster.this.nf.TypeNodeFromQualifiedName(this.p, RUNTIME_CAST_CHECKER_CLASSNAME);
        }

        protected Constraint getConstraintsToCheck(TypeNode toTypeNode) {
            HjType toType = (HjType)toTypeNode.type();
            return toType instanceof NullableType ? ((NullableType)toType).base().depClause() : toType.depClause();
        }

        public abstract Node getRuntimeCheckingExpression(HjCastInfo var1) throws SemanticException;
    }
}

