/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import polyglot.ast.Binary;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.FloatLit;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.StringLit;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.ComplexOperation;
import polyglot.ext.hj.ast.HjComplexConstructor;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjPrimitiveType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.Job;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class HjComplexCaster
extends AscriptionVisitor {
    private HjTypeSystem xts;

    public HjComplexCaster(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
        this.xts = (HjTypeSystem)ts;
    }

    public NodeVisitor enterCall(Node parent, Node n) throws SemanticException {
        HjType t;
        if (parent instanceof Expr && n instanceof Expr && parent instanceof Binary && ((t = (HjType)((Expr)parent).type()).isComplex64() || t.isComplex32())) {
            n = ((Expr)n).type((Type)t);
        }
        return super.enterCall(parent, n);
    }

    public Node visitEdge(Node parent, Node child) {
        Node newChild = child;
        if (parent != null && child instanceof Expr) {
            Type t = parent.childExpectedType((Expr)child, (AscriptionVisitor)this);
            if (newChild instanceof Binary) {
                Binary bin = (Binary)newChild;
                newChild = bin.type(t);
            }
        }
        return super.visitEdge(parent, newChild);
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        return super.leaveCall(old, n, v);
    }

    private Expr createComplexCast(HjComplexType toType, Expr e) throws SemanticException {
        TypeBuilder tb = new TypeBuilder(this.job, this.ts, this.nf);
        AmbiguityRemover ar = new AmbiguityRemover(this.job, this.ts, this.nf);
        TypeChecker tc = new TypeChecker(this.job, this.ts, this.nf);
        tb = tb.pushContext(this.context());
        ar = (AmbiguityRemover)ar.context(this.context());
        tc = (TypeChecker)tc.context(this.context());
        Position p = e.position();
        CanonicalTypeNode typeNode = this.nf.CanonicalTypeNode(p, (Type)toType);
        return (Expr)this.nf.Cast(p, (TypeNode)typeNode, e).visit((NodeVisitor)tb).visit((NodeVisitor)ar).visit((NodeVisitor)tc);
    }

    private Expr rewriteComplexConstructor(HjComplexType toType, HjComplexConstructor xcc) throws SemanticException {
        TypeBuilder tb = new TypeBuilder(this.job, this.ts, this.nf);
        AmbiguityRemover ar = new AmbiguityRemover(this.job, this.ts, this.nf);
        TypeChecker tc = new TypeChecker(this.job, this.ts, this.nf);
        tb = tb.pushContext(this.context());
        ar = (AmbiguityRemover)ar.context(this.context());
        tc = (TypeChecker)tc.context(this.context());
        PrimitiveType baseType = toType.base();
        CanonicalTypeNode baseTypeNode = this.nf.CanonicalTypeNode(xcc.position(), (Type)baseType);
        Cast newReal = this.nf.Cast(xcc.position(), (TypeNode)baseTypeNode, xcc.real());
        Cast newImag = this.nf.Cast(xcc.position(), (TypeNode)baseTypeNode, xcc.imag());
        HjComplexConstructor newXcc = xcc.real((Expr)newReal);
        newXcc = newXcc.imag((Expr)newImag);
        return (Expr)newXcc.visit((NodeVisitor)tb).visit((NodeVisitor)ar).visit((NodeVisitor)tc);
    }

    private Expr createComplexConstructor(HjComplexType toType, Expr e) throws SemanticException {
        TypeBuilder tb = new TypeBuilder(this.job, this.ts, this.nf);
        AmbiguityRemover ar = new AmbiguityRemover(this.job, this.ts, this.nf);
        TypeChecker tc = new TypeChecker(this.job, this.ts, this.nf);
        tb = tb.pushContext(this.context());
        ar = (AmbiguityRemover)ar.context(this.context());
        tc = (TypeChecker)tc.context(this.context());
        Position p = e.position();
        HjPrimitiveType baseType = (HjPrimitiveType)toType.base();
        FloatLit.Kind floatKind = baseType.isDouble() ? FloatLit.DOUBLE : FloatLit.FLOAT;
        CanonicalTypeNode baseTypeNode = this.nf.CanonicalTypeNode(p, (Type)baseType);
        Cast newReal = this.nf.Cast(p, (TypeNode)baseTypeNode, e);
        Cast newImag = this.nf.Cast(p, (TypeNode)baseTypeNode, (Expr)this.nf.FloatLit(p, floatKind, 0.0));
        HjComplexConstructor newXcc = ((HjNodeFactory)this.nf).HjComplexConstructor(p, (Expr)newReal, (Expr)newImag);
        return (Expr)newXcc.visit((NodeVisitor)tb).visit((NodeVisitor)ar).visit((NodeVisitor)tc);
    }

    protected Node leaveCall(Node n) throws SemanticException {
        return super.leaveCall(n);
    }

    public Expr ascribe(Expr e, Type toType) throws SemanticException {
        if (this.xts.isString(toType) && (((HjType)e.type()).isComplex32() || ((HjType)e.type()).isComplex64())) {
            Expr c = this.complexToString(e);
            return c;
        }
        if (this.xts.isComplex64(toType) || this.xts.isComplex32(toType)) {
            Type fromType = e.type();
            if (this.xts.isComplex64(fromType) || this.xts.isComplex32(fromType)) {
                Cast cast;
                if (e instanceof HjComplexConstructor) {
                    return this.rewriteComplexConstructor((HjComplexType)toType, (HjComplexConstructor)e);
                }
                if (e instanceof Cast && (cast = (Cast)e).type().equals(cast.expr().type())) {
                    return ((Cast)e).expr();
                }
            } else {
                return this.createComplexConstructor((HjComplexType)toType, e);
            }
        }
        return super.ascribe(e, toType);
    }

    private Expr complexToString(Expr e) throws SemanticException {
        TypeBuilder tb = new TypeBuilder(this.job, this.ts, this.nf);
        AmbiguityRemover ar = new AmbiguityRemover(this.job, this.ts, this.nf);
        TypeChecker tc = new TypeChecker(this.job, this.ts, this.nf);
        tb = tb.pushContext(this.context);
        ar = (AmbiguityRemover)ar.context(this.context);
        tc = (TypeChecker)tc.context(this.context);
        HjNodeFactory hnf = (HjNodeFactory)this.nf;
        Position p = e.position();
        Expr realPart = (Expr)hnf.ComplexAccessor(p, ComplexOperation.REAL, e);
        Expr imagPart = (Expr)hnf.ComplexAccessor(p, ComplexOperation.IMAG, e);
        StringLit lpar = hnf.StringLit(p, "(");
        StringLit mid = hnf.StringLit(p, ",");
        StringLit rpar = hnf.StringLit(p, ")");
        Binary strConcat = this.nf.Binary(p, (Expr)lpar, Binary.ADD, realPart);
        strConcat = this.nf.Binary(p, (Expr)strConcat, Binary.ADD, (Expr)mid);
        strConcat = this.nf.Binary(p, (Expr)strConcat, Binary.ADD, imagPart);
        strConcat = this.nf.Binary(p, (Expr)strConcat, Binary.ADD, (Expr)rpar);
        return (Expr)strConcat.visit((NodeVisitor)tb).visit((NodeVisitor)ar).visit((NodeVisitor)tc);
    }
}

