/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.Collections;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Formal;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjLoop;
import polyglot.frontend.Job;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjImplicitDeclarationExpander
extends ContextVisitor {
    public HjImplicitDeclarationExpander(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        if (n instanceof MethodDecl) {
            return this.visitMethodDecl((MethodDecl)n);
        }
        if (n instanceof Closure) {
            return this.visitClosure((Closure)n);
        }
        if (n instanceof HjLoop) {
            return this.visitLoop((HjLoop)n);
        }
        return n;
    }

    private Block explodeAllArgs(List<Formal> formals, Block body) {
        List<Stmt> stmts = Collections.emptyList();
        for (HjFormal hjFormal : formals) {
            if (!hjFormal.hasExplodedVars()) continue;
            stmts = hjFormal.explode(this.nf, this.ts, stmts, false);
        }
        if (stmts.isEmpty()) {
            return body;
        }
        stmts.addAll(body.statements());
        return body.statements(stmts);
    }

    private Node visitMethodDecl(MethodDecl n) {
        List fs = n.formals();
        Block b = this.explodeAllArgs(fs, n.body());
        if (n.body() != b) {
            return n.body(b);
        }
        return n;
    }

    private Node visitClosure(Closure c) {
        List fs = c.formals();
        Block b = this.explodeAllArgs(fs, c.body());
        if (c.body() != b) {
            return c.body(b);
        }
        return c;
    }

    private Node visitLoop(HjLoop n) {
        HjFormal f = (HjFormal)n.formal();
        if (!f.hasExplodedVars()) {
            return n;
        }
        return n.locals(f.explode(this.nf, this.ts));
    }
}

