/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.List;
import polyglot.ast.Call_c;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.ConstructorCall_c;
import polyglot.ast.ConstructorDecl_c;
import polyglot.ast.Expr_c;
import polyglot.ast.FieldDecl_c;
import polyglot.ast.Field_c;
import polyglot.ast.Formal_c;
import polyglot.ast.Initializer_c;
import polyglot.ast.JL;
import polyglot.ast.LocalDecl_c;
import polyglot.ast.Local_c;
import polyglot.ast.New_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode_c;
import polyglot.ast.TypeNode_c;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjFieldInstance;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjMethodInstance;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeObject;
import polyglot.ext.hj.visit.HjDelegatingVisitor;
import polyglot.frontend.Job;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.LocalInstance;
import polyglot.types.MemberInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.visit.NodeVisitor;

public class PropagateDependentAnnotationsVisitor
extends NodeVisitor {
    Job job;
    TypeSystem ts;
    NodeFactory nf;

    public PropagateDependentAnnotationsVisitor(Job job, TypeSystem ts, NodeFactory nf) {
        this.job = job;
        this.ts = ts;
        this.nf = nf;
    }

    public Job job() {
        return this.job;
    }

    public Node leave(Node old, Node n, NodeVisitor v) {
        n = super.leave(old, n, v);
        HjDelegatingVisitor d = new HjDelegatingVisitor(){

            protected void force(List l) {
                for (TypeObject o : l) {
                    this.force(o);
                }
            }

            protected void force(TypeObject o) {
                if (o instanceof HjTypeObject) {
                    HjClassType ct;
                    MethodInstance mi;
                    HjTypeObject xo = (HjTypeObject)o;
                    if (xo instanceof FieldInstance) {
                        FieldInstance fi = (FieldInstance)xo;
                        fi.constantValue();
                        this.force((TypeObject)fi.type());
                    } else if (xo instanceof LocalInstance) {
                        LocalInstance li = (LocalInstance)xo;
                        li.constantValue();
                        this.force((TypeObject)li.type());
                    } else if (xo instanceof MethodInstance) {
                        mi = (MethodInstance)xo;
                        this.force((TypeObject)mi.returnType());
                        this.force(mi.formalTypes());
                        this.force(mi.throwTypes());
                    } else if (xo instanceof HjConstructorInstance) {
                        HjConstructorInstance ci = (HjConstructorInstance)xo;
                        this.force(ci.returnType());
                        this.force(ci.formalTypes());
                        this.force(ci.throwTypes());
                    } else if (xo instanceof ArrayType) {
                        ArrayType at = (ArrayType)xo;
                        this.force((TypeObject)at.base());
                    } else if (xo instanceof HjClassType) {
                        ct = (HjClassType)xo;
                        DepParameterExpr dep = ct.dep();
                        if (dep != null) {
                            dep.visit(PropagateDependentAnnotationsVisitor.this);
                        }
                        if (ct instanceof HjParsedClassType) {
                            this.force(ct.classAnnotations());
                        }
                    } else if (xo instanceof ClassType) {
                        ct = (ClassType)xo;
                    }
                    if (xo instanceof HjParsedClassType) {
                        ct = (HjParsedClassType)xo;
                        if (ct.isRootType() && ct.job() == PropagateDependentAnnotationsVisitor.this.job()) {
                            return;
                        }
                        if (ct.job() == null) {
                            return;
                        }
                    } else if (xo instanceof MemberInstance) {
                        mi = (MemberInstance)xo;
                        boolean isRoot = false;
                        if (mi instanceof HjFieldInstance && ((HjFieldInstance)mi).orig() == mi) {
                            isRoot = true;
                        }
                        if (mi instanceof HjLocalInstance && ((HjLocalInstance)mi).orig() == mi) {
                            isRoot = true;
                        }
                        if (mi instanceof HjMethodInstance && ((HjMethodInstance)mi).orig() == mi) {
                            isRoot = true;
                        }
                        if (mi instanceof HjConstructorInstance && ((HjConstructorInstance)mi).orig() == mi) {
                            isRoot = true;
                        }
                        if (mi.container() instanceof ParsedClassType) {
                            ParsedClassType ct2 = (ParsedClassType)mi.container();
                            if (isRoot && ct2.job() == PropagateDependentAnnotationsVisitor.this.job()) {
                                return;
                            }
                            if (ct2.job() == null) {
                                return;
                            }
                        }
                    } else {
                        return;
                    }
                    this.force(xo.annotations());
                }
            }

            public void visit(Call_c n) {
                this.force((TypeObject)n.methodInstance());
                super.visit(n);
            }

            public void visit(ClassDecl_c n) {
                this.force((TypeObject)n.type());
                super.visit(n);
            }

            public void visit(ConstructorCall_c n) {
                this.force((TypeObject)n.constructorInstance());
                super.visit(n);
            }

            public void visit(ConstructorDecl_c n) {
                this.force((TypeObject)n.constructorInstance());
                super.visit(n);
            }

            public void visit(Expr_c n) {
                this.force((TypeObject)n.type());
                super.visit(n);
            }

            public void visit(Field_c n) {
                this.force((TypeObject)n.fieldInstance());
                super.visit(n);
            }

            public void visit(FieldDecl_c n) {
                this.force((TypeObject)n.fieldInstance());
                super.visit(n);
            }

            public void visit(Formal_c n) {
                this.force((TypeObject)n.localInstance());
                super.visit(n);
            }

            public void visit(Initializer_c n) {
                this.force((TypeObject)n.initializerInstance());
                super.visit(n);
            }

            public void visit(Local_c n) {
                this.force((TypeObject)n.localInstance());
                super.visit(n);
            }

            public void visit(LocalDecl_c n) {
                this.force((TypeObject)n.localInstance());
                super.visit(n);
            }

            public void visit(New_c n) {
                this.force((TypeObject)n.constructorInstance());
                super.visit(n);
            }

            public void visit(PackageNode_c n) {
                this.force((TypeObject)n.package_());
                super.visit(n);
            }

            public void visit(TypeNode_c n) {
                this.force((TypeObject)n.type());
                super.visit(n);
            }
        };
        try {
            d.visitAppropriate((JL)n);
        }
        catch (MissingDependencyException e) {
            if (Report.should_report((String)"frontend", (int)3)) {
                e.printStackTrace();
            }
            Scheduler scheduler = this.job.extensionInfo().scheduler();
            Goal g = scheduler.currentGoal();
            scheduler.addDependencyAndEnqueue(g, e.goal(), e.prerequisite());
            g.setUnreachableThisRun();
        }
        return n;
    }
}

