/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import soot.G;
import soot.HjToJimple.jimple.HabAttrBox;
import soot.HjToJimple.jimple.HabRTClassBuilder;
import soot.HjToJimple.jimple.HabRTWFClassBuilder;
import soot.HjToJimple.jimple.HjRSTTranslator;
import soot.HjToJimple.jimple.HjRedundantAsyncElim;
import soot.HjToJimple.jimple.TargetedHjRuntime;
import soot.HjToJimple.util.RSTNode;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjWSTranslator
extends SceneTransformer {
    protected ArrayList<SootClass> extraClasses = new ArrayList();
    protected HabRTClassBuilder habRTClassBuilder;

    public HjWSTranslator(Singletons.Global g) {
    }

    public static HjWSTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjWSTranslator();
    }

    @Override
    protected void internalTransform(String phaseName, Map opts) {
        HjRedundantAsyncElim.v().raeTransform();
        if (TargetedHjRuntime.isRuntimeWorkStealingWorkFirst()) {
            this.habRTClassBuilder = HabRTWFClassBuilder.v();
        } else if (TargetedHjRuntime.isRuntimeWorkStealingHelpFirst()) {
            this.habRTClassBuilder = HabRTClassBuilder.v();
        } else {
            throw new RuntimeException("Unrecognized work-stealing code generation policy");
        }
        this.hjWSTransform(phaseName, opts);
    }

    protected void hjWSTransform(String phaseName, Map opts) {
        HashSet<SootMethod> appMethodSet = new HashSet<SootMethod>();
        HashMap<SootMethod, HabAttrBox> contMethodMap = new HashMap<SootMethod, HabAttrBox>();
        HashSet<SootMethod> methodContSet = new HashSet<SootMethod>();
        this.collectAppMethods(appMethodSet);
        this.rebuildRST(appMethodSet);
        this.collectContMethods(appMethodSet, contMethodMap, methodContSet);
        this.extractAsyncs(contMethodMap);
        HashMap local2FieldMap = new HashMap();
        HashMap field2LocalMap = new HashMap();
        HabAttrBox mainHabBox = null;
        for (SootMethod method : contMethodMap.keySet()) {
            HabAttrBox habBox = contMethodMap.get(method);
            if (method.getSubSignature().equals("void main(java.lang.String[])")) {
                mainHabBox = habBox;
            }
            if (!this.habRTClassBuilder.hasContinuation(method.getRSTNode(), contMethodMap, false) && habBox.isExecMethod()) continue;
            if (habBox.isExecMethod()) {
                HjRSTTranslator.v().rebuildRST(method.retrieveActiveBody(), null, null);
                HjWSTranslator hjWSTranslator = this;
                hjWSTranslator.habRTClassBuilder.v().resetMethodInvoke(method.getRSTNode(), habBox, contMethodMap);
                if (!TargetedHjRuntime.isRuntimeWorkStealingAdaptive() || !this.habRTClassBuilder.hasAsync(method.getRSTNode())) continue;
            }
            local2FieldMap.clear();
            field2LocalMap.clear();
            SootClass frameClass = this.habRTClassBuilder.buildFrameClass(method, contMethodMap, habBox, local2FieldMap, field2LocalMap);
            habBox.setFrameClass(frameClass);
        }
        this.cleanMethods(contMethodMap);
    }

    protected void extractAsyncs(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        Iterator<SootMethod> methodIter = contMethodMap.keySet().iterator();
        ArrayList<SootMethod> methodList = new ArrayList<SootMethod>();
        while (methodIter.hasNext()) {
            methodList.add(methodIter.next());
        }
        methodIter = methodList.iterator();
        int methodCounter = 0;
        while (methodIter.hasNext()) {
            SootMethod method = methodIter.next();
            this.habRTClassBuilder.identityLocals(method);
            this.habRTClassBuilder.extractAsync(method, method, method.getRSTNode(), contMethodMap, methodCounter += 10);
        }
    }

    protected void cleanMethods(HashMap<SootMethod, HabAttrBox> contMethodMap) {
        for (SootMethod method : contMethodMap.keySet()) {
            HabAttrBox habBox = contMethodMap.get(method);
            if (habBox.isExecMethod()) continue;
            method.releaseActiveBody();
            method.getDeclaringClass().removeMethod(method);
        }
    }

    protected void rebuildRST(HashSet<SootMethod> appMethodSet) {
        Iterator<SootMethod> methodIter = appMethodSet.iterator();
        while (methodIter.hasNext()) {
            HjRSTTranslator.v().rebuildRST(methodIter.next().retrieveActiveBody(), null, null);
        }
    }

    protected void collectAppMethods(HashSet<SootMethod> appMethodSet) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            ListIterator<SootMethod> methodIter = appClass.getMethods().listIterator();
            while (methodIter.hasNext()) {
                SootMethod method = (SootMethod)methodIter.next();
                if (method.getName().startsWith("<init>") || !method.hasActiveBody() || this.isConcreteMethod(method, appClass.getSuperclass())) continue;
                appMethodSet.add(method);
            }
        }
    }

    protected void collectContMethods(HashSet<SootMethod> appMethodSet, HashMap<SootMethod, HabAttrBox> contMethodMap, HashSet<SootMethod> methodContSet) {
        for (SootMethod method : appMethodSet) {
            SootMethod fcMethod;
            HabAttrBox habBox;
            if (appMethodSet.contains(method) && this.checkFinishAsync(method.getRSTNode())) {
                habBox = new HabAttrBox();
                fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
                habBox.setFastClone(fcMethod);
                contMethodMap.put(method, habBox);
                methodContSet.add(method);
                continue;
            }
            if (!method.getSubSignature().equals("void main(java.lang.String[])")) continue;
            habBox = new HabAttrBox();
            fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
            habBox.setFastClone(fcMethod);
            contMethodMap.put(method, habBox);
            methodContSet.add(method);
        }
        CallGraph cg = Scene.v().getCallGraph();
        boolean change = true;
        while (change) {
            change = false;
            block2: for (SootMethod method : appMethodSet) {
                if (contMethodMap.containsKey(method)) continue;
                Iterator<Edge> edgeIter = cg.edgesOutOf(method);
                while (edgeIter.hasNext()) {
                    Edge edge = edgeIter.next();
                    if (!contMethodMap.containsKey(edge.tgt())) continue;
                    HabAttrBox habBox = new HabAttrBox();
                    SootMethod fcMethod = this.habRTClassBuilder.createFCMethod(method, habBox);
                    habBox.setFastClone(fcMethod);
                    contMethodMap.put(method, habBox);
                    change = true;
                    continue block2;
                }
            }
        }
    }

    protected boolean checkFinishAsync(RSTNode rstNode) {
        return this.habRTClassBuilder.hasContinuation(rstNode, false);
    }

    protected boolean isConcreteMethod(SootMethod method, SootClass checkClass) {
        if (checkClass.declaresMethod(method.getSubSignature())) {
            return checkClass.getMethod(method.getSubSignature()).isConcrete();
        }
        return false;
    }
}

