/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import soot.Immediate;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Annotation;
import soot.JastAddJ.Block;
import soot.JastAddJ.Body;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.BooleanType;
import soot.JastAddJ.Case;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.Constant;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.ElementValue;
import soot.JastAddJ.EnumDecl;
import soot.JastAddJ.Expr;
import soot.JastAddJ.GLBType;
import soot.JastAddJ.GenericConstructorDecl;
import soot.JastAddJ.GenericMethodDecl;
import soot.JastAddJ.IntType;
import soot.JastAddJ.LUBType;
import soot.JastAddJ.LabeledStmt;
import soot.JastAddJ.MethodDecl;
import soot.JastAddJ.NameType;
import soot.JastAddJ.Problem;
import soot.JastAddJ.SimpleSet;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.TryStmt;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;
import soot.JastAddJ.VariableScope;
import soot.Local;
import soot.Type;
import soot.Value;
import soot.jimple.ConcreteRef;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.StringConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTNode<T extends ASTNode>
extends Symbol
implements Cloneable,
Iterable<T> {
    protected static int indent = 0;
    protected static final String PRIMITIVE_PACKAGE_NAME = "@primitive";
    private static int replacePos = 0;
    public static boolean generatedWithCircularEnabled = true;
    public static boolean generatedWithCacheCycle = false;
    public static boolean generatedWithComponentCheck = false;
    public static boolean IN_CIRCLE = false;
    public static int CIRCLE_INDEX;
    public static boolean CHANGE;
    public static boolean RESET_CYCLE;
    public static int boundariesCrossed;
    protected static ASTNode$State state;
    public boolean in$Circle = false;
    public boolean is$Final = false;
    protected static final int REWRITE_CHANGE = 1;
    protected static final int REWRITE_NOCHANGE = 2;
    protected static final int REWRITE_INTERRUPT = 3;
    public int childIndex;
    protected ASTNode parent;
    protected ASTNode[] children;
    protected int numChildren;
    protected static int duringDefiniteAssignment;
    protected static int duringGenericTypeVariables;
    protected static int duringVariableDeclaration;
    protected static int duringBoundNames;
    protected static int duringEnums;
    protected static int duringLookupConstructor;
    protected static int duringConstantExpression;
    protected static int duringAnonymousClasses;
    protected static int duringAnnotations;
    protected static int duringSyntacticClassification;
    protected static int duringResolveAmbiguousNames;

    public void flushCache() {
    }

    public ASTNode<T> clone() throws CloneNotSupportedException {
        ASTNode node = (ASTNode)super.clone();
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public ASTNode<T> copy() {
        try {
            Object node = this.clone();
            if (this.children != null) {
                ((ASTNode)node).children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public ASTNode<T> fullCopy() {
        ASTNode<T> res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void accessControl() {
    }

    protected void collectExceptions(Collection c, ASTNode target) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collectExceptions(c, target);
        }
    }

    public void collectBranches(Collection c) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collectBranches(c);
        }
    }

    public Stmt branchTarget(Stmt branchStmt) {
        if (this.getParent() != null) {
            return this.getParent().branchTarget(branchStmt);
        }
        return null;
    }

    public void collectFinally(Stmt branchStmt, ArrayList list) {
        if (this.getParent() != null) {
            this.getParent().collectFinally(branchStmt, list);
        }
    }

    public int varChildIndex(Block b) {
        ASTNode node = this;
        while (node.getParent().getParent() != b) {
            node = node.getParent();
        }
        return b.getStmtListNoTransform().getIndexOfChild(node);
    }

    public int varChildIndex(TypeDecl t) {
        ASTNode node;
        for (node = this; node != null && node.getParent() != null && node.getParent().getParent() != t; node = node.getParent()) {
        }
        if (node == null) {
            return -1;
        }
        return t.getBodyDeclListNoTransform().getIndexOfChild(node);
    }

    public void definiteAssignment() {
    }

    protected boolean checkDUeverywhere(Variable v) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            if (((ASTNode)this.getChild(i)).checkDUeverywhere(v)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDescendantTo(ASTNode node) {
        if (this == node) {
            return true;
        }
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().isDescendantTo(node);
    }

    protected String sourceFile() {
        ASTNode node;
        for (node = this; node != null && !(node instanceof CompilationUnit); node = node.getParent()) {
        }
        if (node == null) {
            return "Unknown file";
        }
        CompilationUnit u = (CompilationUnit)node;
        return u.relativeName();
    }

    public ASTNode setLocation(ASTNode node) {
        this.setStart(node.getStart());
        this.setEnd(node.getEnd());
        return this;
    }

    public ASTNode setStart(int i) {
        this.start = i;
        return this;
    }

    public int start() {
        return this.start;
    }

    public ASTNode setEnd(int i) {
        this.end = i;
        return this;
    }

    public int end() {
        return this.end;
    }

    public String location() {
        return "" + this.lineNumber();
    }

    public String errorPrefix() {
        return this.sourceFile() + ":" + this.location() + ":\n" + "  *** Semantic Error: ";
    }

    public String warningPrefix() {
        return this.sourceFile() + ":" + this.location() + ":\n" + "  *** WARNING: ";
    }

    protected void error(String s) {
        ASTNode node;
        for (node = this; node != null && !(node instanceof CompilationUnit); node = node.getParent()) {
        }
        CompilationUnit cu = (CompilationUnit)node;
        if (this.getNumChild() == 0 && this.getStart() != 0 && this.getEnd() != 0) {
            int line = ASTNode.getLine(this.getStart());
            int column = ASTNode.getColumn(this.getStart());
            int endLine = ASTNode.getLine(this.getEnd());
            int endColumn = ASTNode.getColumn(this.getEnd());
            cu.errors.add(new Problem(this.sourceFile(), s, line, column, endLine, endColumn, Problem.Severity.ERROR, Problem.Kind.SEMANTIC));
        } else {
            cu.errors.add(new Problem(this.sourceFile(), s, this.lineNumber(), Problem.Severity.ERROR, Problem.Kind.SEMANTIC));
        }
    }

    protected void warning(String s) {
        ASTNode node;
        for (node = this; node != null && !(node instanceof CompilationUnit); node = node.getParent()) {
        }
        CompilationUnit cu = (CompilationUnit)node;
        cu.warnings.add(new Problem(this.sourceFile(), "WARNING: " + s, this.lineNumber(), Problem.Severity.WARNING));
    }

    public void collectErrors() {
        this.nameCheck();
        this.typeCheck();
        this.accessControl();
        this.exceptionHandling();
        this.checkUnreachableStmt();
        this.definiteAssignment();
        this.checkModifiers();
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collectErrors();
        }
    }

    public void exceptionHandling() {
    }

    protected boolean reachedException(TypeDecl type) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            if (!((ASTNode)this.getChild(i)).reachedException(type)) continue;
            return true;
        }
        return false;
    }

    public static Collection removeInstanceMethods(Collection c) {
        c = new LinkedList(c);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            MethodDecl m = (MethodDecl)iter.next();
            if (m.isStatic()) continue;
            iter.remove();
        }
        return c;
    }

    protected static void putSimpleSetElement(HashMap map, Object key, Object value) {
        SimpleSet set = (SimpleSet)map.get(key);
        if (set == null) {
            set = SimpleSet.emptySet;
        }
        map.put(key, set.add(value));
    }

    public SimpleSet removeInstanceVariables(SimpleSet oldSet) {
        SimpleSet newSet = SimpleSet.emptySet;
        Iterator iter = oldSet.iterator();
        while (iter.hasNext()) {
            Variable v = (Variable)iter.next();
            if (v.isInstanceVariable()) continue;
            newSet = newSet.add(v);
        }
        return newSet;
    }

    void checkModifiers() {
    }

    public void nameCheck() {
    }

    public TypeDecl extractSingleType(SimpleSet c) {
        if (c.size() != 1) {
            return null;
        }
        return (TypeDecl)c.iterator().next();
    }

    public static String indent() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            s.append("  ");
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.toString(s);
        return s.toString().trim();
    }

    public void toString(StringBuffer s) {
        throw new Error("Operation toString(StringBuffer s) not implemented for " + this.getClass().getName());
    }

    public String dumpTree() {
        StringBuffer s = new StringBuffer();
        this.dumpTree(s, 0);
        return s.toString();
    }

    public void dumpTree(StringBuffer s, int j) {
        int i;
        for (i = 0; i < j; ++i) {
            s.append("  ");
        }
        s.append(this.dumpString() + "\n");
        for (i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).dumpTree(s, j + 1);
        }
    }

    public String dumpTreeNoRewrite() {
        StringBuffer s = new StringBuffer();
        this.dumpTreeNoRewrite(s, 0);
        return s.toString();
    }

    protected void dumpTreeNoRewrite(StringBuffer s, int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            s.append("  ");
        }
        s.append(this.dumpString());
        s.append("\n");
        for (i = 0; i < this.getNumChildNoTransform(); ++i) {
            ((ASTNode)this.getChildNoTransform(i)).dumpTreeNoRewrite(s, indent + 1);
        }
    }

    public void typeCheck() {
    }

    void checkUnreachableStmt() {
    }

    protected void transformEnumConstructors() {
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            T child = this.getChildNoTransform(i);
            if (child == null) continue;
            ((ASTNode)child).transformEnumConstructors();
        }
    }

    protected void checkEnum(EnumDecl enumDecl) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).checkEnum(enumDecl);
        }
    }

    public void collectEnclosingVariables(HashSet set, TypeDecl typeDecl) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collectEnclosingVariables(set, typeDecl);
        }
    }

    public void flushCaches() {
        this.flushCache();
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).flushCaches();
        }
    }

    public void transformation() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).transformation();
        }
    }

    protected static ASTNode replace(ASTNode node) {
        replacePos = node.getParent().getIndexOfChild(node);
        node.getParent().in$Circle(true);
        return node.getParent();
    }

    protected ASTNode with(ASTNode node) {
        this.setChild(node, replacePos);
        this.in$Circle(false);
        return node;
    }

    public void jimplify1phase1() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).jimplify1phase1();
        }
    }

    public void jimplify1phase2() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).jimplify1phase2();
        }
    }

    public void jimplify2() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).jimplify2();
        }
    }

    public void jimplify2(Body b) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).jimplify2(b);
        }
    }

    public Immediate asImmediate(Body b, Value v) {
        if (v instanceof Immediate) {
            return (Immediate)v;
        }
        return b.newTemp(v);
    }

    public Local asLocal(Body b, Value v) {
        if (v instanceof Local) {
            return (Local)v;
        }
        return b.newTemp(v);
    }

    public Local asLocal(Body b, Value v, Type t) {
        if (v instanceof Local) {
            return (Local)v;
        }
        Local local = b.newTemp(t);
        b.add(Jimple.v().newAssignStmt(local, v));
        return local;
    }

    public Value asRValue(Body b, Value v) {
        if (v instanceof Local) {
            return v;
        }
        if (v instanceof soot.jimple.Constant) {
            return v;
        }
        if (v instanceof ConcreteRef) {
            return v;
        }
        if (v instanceof soot.jimple.Expr) {
            return v;
        }
        throw new Error("Need to convert " + v.getClass().getName() + " to RValue");
    }

    protected soot.jimple.Stmt newLabel() {
        return Jimple.v().newNopStmt();
    }

    public void addAttributes() {
    }

    public static Value emitConstant(Constant constant) {
        if (constant instanceof Constant.ConstantInt) {
            return IntType.emitConstant(constant.intValue());
        }
        if (constant instanceof Constant.ConstantLong) {
            return LongConstant.v(constant.longValue());
        }
        if (constant instanceof Constant.ConstantFloat) {
            return FloatConstant.v(constant.floatValue());
        }
        if (constant instanceof Constant.ConstantDouble) {
            return DoubleConstant.v(constant.doubleValue());
        }
        if (constant instanceof Constant.ConstantChar) {
            return IntType.emitConstant(constant.intValue());
        }
        if (constant instanceof Constant.ConstantBoolean) {
            return BooleanType.emitConstant(constant.booleanValue());
        }
        if (constant instanceof Constant.ConstantString) {
            return StringConstant.v(constant.stringValue());
        }
        throw new Error("Unexpected constant");
    }

    public void endExceptionRange(Body b, ArrayList list) {
        if (list != null) {
            soot.jimple.Stmt label = this.newLabel();
            b.addLabel(label);
            list.add(label);
        }
    }

    public void beginExceptionRange(Body b, ArrayList list) {
        if (list != null) {
            b.addNextStmt(list);
        }
    }

    public void collectTypesToHierarchy(Collection<Type> set) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collectTypesToHierarchy(set);
        }
    }

    public void collectTypesToSignatures(Collection<Type> set) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            ((ASTNode)this.getChild(i)).collectTypesToSignatures(set);
        }
    }

    public boolean in$Circle() {
        return this.in$Circle;
    }

    public void in$Circle(boolean b) {
        this.in$Circle = b;
    }

    public boolean is$Final() {
        return this.is$Final;
    }

    public void is$Final(boolean b) {
        this.is$Final = b;
    }

    public T getChild(int i) {
        return (T)ASTNode.getChild(this, i);
    }

    public static ASTNode getChild(ASTNode that, int i) {
        Object node = that.getChildNoTransform(i);
        if (((ASTNode)node).is$Final()) {
            return node;
        }
        if (!((ASTNode)node).mayHaveRewrite()) {
            ((ASTNode)node).is$Final(that.is$Final());
            return node;
        }
        if (!((ASTNode)node).in$Circle()) {
            int rewriteState;
            int num = boundariesCrossed;
            do {
                state.push(1);
                Object oldNode = node;
                ((ASTNode)oldNode).in$Circle(true);
                node = ((ASTNode)node).rewriteTo();
                if (node != oldNode) {
                    that.setChild(node, i);
                }
                ((ASTNode)oldNode).in$Circle(false);
            } while ((rewriteState = state.pop()) == 1);
            if (rewriteState == 2 && that.is$Final()) {
                ((ASTNode)node).is$Final(true);
                boundariesCrossed = num;
            }
        } else if (that.is$Final() != ((ASTNode)node).is$Final()) {
            ++boundariesCrossed;
        }
        return node;
    }

    public int getIndexOfChild(ASTNode node) {
        if (node != null && node.childIndex < this.getNumChildNoTransform() && node == this.getChildNoTransform(node.childIndex)) {
            return node.childIndex;
        }
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            if (this.getChildNoTransform(i) != node) continue;
            node.childIndex = i;
            return i;
        }
        return -1;
    }

    public void addChild(T node) {
        this.setChild(node, this.getNumChildNoTransform());
    }

    public final T getChildNoTransform(int i) {
        return (T)this.children[i];
    }

    protected int numChildren() {
        return this.numChildren;
    }

    public int getNumChild() {
        return this.numChildren();
    }

    public final int getNumChildNoTransform() {
        return this.numChildren();
    }

    public void setChild(T node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1];
        } else if (i >= this.children.length) {
            ASTNode[] c = new ASTNode[i << 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = node;
        if (i >= this.numChildren) {
            this.numChildren = i + 1;
        }
        if (node != null) {
            ((ASTNode)node).setParent(this);
            ((ASTNode)node).childIndex = i;
        }
    }

    public void insertChild(T node, int i) {
        if (this.children == null) {
            this.children = new ASTNode[i + 1];
            this.children[i] = node;
        } else {
            ASTNode[] c = new ASTNode[this.children.length + 1];
            System.arraycopy(this.children, 0, c, 0, i);
            c[i] = node;
            if (i < this.children.length) {
                System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            }
            this.children = c;
        }
        ++this.numChildren;
        if (node != null) {
            ((ASTNode)node).setParent(this);
            ((ASTNode)node).childIndex = i;
        }
    }

    public void removeChild(int i) {
        if (this.children != null) {
            ASTNode child = this.children[i];
            if (child != null) {
                child.setParent(null);
                child.childIndex = -1;
            }
            System.arraycopy(this.children, i + 1, this.children, i, this.children.length - i - 1);
            --this.numChildren;
        }
    }

    public ASTNode getParent() {
        if (this.parent != null && this.parent.is$Final() != this.is$Final()) {
            ++boundariesCrossed;
        }
        return this.parent;
    }

    public void setParent(ASTNode node) {
        this.parent = node;
    }

    protected static boolean duringDefiniteAssignment() {
        if (duringDefiniteAssignment == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringGenericTypeVariables() {
        if (duringGenericTypeVariables == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringVariableDeclaration() {
        if (duringVariableDeclaration == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringBoundNames() {
        if (duringBoundNames == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringEnums() {
        if (duringEnums == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringLookupConstructor() {
        if (duringLookupConstructor == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringConstantExpression() {
        if (duringConstantExpression == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringAnonymousClasses() {
        if (duringAnonymousClasses == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringAnnotations() {
        if (duringAnnotations == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringSyntacticClassification() {
        if (duringSyntacticClassification == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    protected static boolean duringResolveAmbiguousNames() {
        if (duringResolveAmbiguousNames == 0) {
            return false;
        }
        state.pop();
        state.push(3);
        return true;
    }

    public static void reset() {
        IN_CIRCLE = false;
        CIRCLE_INDEX = 0;
        CHANGE = false;
        boundariesCrossed = 0;
        state = new ASTNode$State();
        if (duringDefiniteAssignment != 0) {
            System.out.println("Warning: resetting duringDefiniteAssignment");
            duringDefiniteAssignment = 0;
        }
        if (duringGenericTypeVariables != 0) {
            System.out.println("Warning: resetting duringGenericTypeVariables");
            duringGenericTypeVariables = 0;
        }
        if (duringVariableDeclaration != 0) {
            System.out.println("Warning: resetting duringVariableDeclaration");
            duringVariableDeclaration = 0;
        }
        if (duringBoundNames != 0) {
            System.out.println("Warning: resetting duringBoundNames");
            duringBoundNames = 0;
        }
        if (duringEnums != 0) {
            System.out.println("Warning: resetting duringEnums");
            duringEnums = 0;
        }
        if (duringLookupConstructor != 0) {
            System.out.println("Warning: resetting duringLookupConstructor");
            duringLookupConstructor = 0;
        }
        if (duringConstantExpression != 0) {
            System.out.println("Warning: resetting duringConstantExpression");
            duringConstantExpression = 0;
        }
        if (duringAnonymousClasses != 0) {
            System.out.println("Warning: resetting duringAnonymousClasses");
            duringAnonymousClasses = 0;
        }
        if (duringAnnotations != 0) {
            System.out.println("Warning: resetting duringAnnotations");
            duringAnnotations = 0;
        }
        if (duringSyntacticClassification != 0) {
            System.out.println("Warning: resetting duringSyntacticClassification");
            duringSyntacticClassification = 0;
        }
        if (duringResolveAmbiguousNames != 0) {
            System.out.println("Warning: resetting duringResolveAmbiguousNames");
            duringResolveAmbiguousNames = 0;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int counter = 0;

            @Override
            public boolean hasNext() {
                return this.counter < ASTNode.this.getNumChild();
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ASTNode.this.getChild(this.counter++);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean mayHaveRewrite() {
        return false;
    }

    public boolean unassignedEverywhere(Variable v, TryStmt stmt) {
        boolean unassignedEverywhere_Variable_TryStmt_value = this.unassignedEverywhere_compute(v, stmt);
        return unassignedEverywhere_Variable_TryStmt_value;
    }

    private boolean unassignedEverywhere_compute(Variable v, TryStmt stmt) {
        for (int i = 0; i < this.getNumChild(); ++i) {
            if (((ASTNode)this.getChild(i)).unassignedEverywhere(v, stmt)) continue;
            return false;
        }
        return true;
    }

    public int lineNumber() {
        int lineNumber_value = this.lineNumber_compute();
        return lineNumber_value;
    }

    private int lineNumber_compute() {
        ASTNode n = this;
        while (n.getParent() != null && n.getStart() == 0) {
            n = n.getParent();
        }
        return ASTNode.getLine(n.getStart());
    }

    public String dumpString() {
        String dumpString_value = this.dumpString_compute();
        return dumpString_value;
    }

    private String dumpString_compute() {
        return this.getClass().getName();
    }

    public boolean usesTypeVariable() {
        boolean usesTypeVariable_value = this.usesTypeVariable_compute();
        return usesTypeVariable_value;
    }

    private boolean usesTypeVariable_compute() {
        for (int i = 0; i < this.getNumChild(); ++i) {
            if (!((ASTNode)this.getChild(i)).usesTypeVariable()) continue;
            return true;
        }
        return false;
    }

    public boolean isStringAdd() {
        boolean isStringAdd_value = this.isStringAdd_compute();
        return isStringAdd_value;
    }

    private boolean isStringAdd_compute() {
        return false;
    }

    public boolean definesLabel() {
        boolean definesLabel_value = this.definesLabel_compute();
        return definesLabel_value;
    }

    private boolean definesLabel_compute() {
        return false;
    }

    public ASTNode rewriteTo() {
        if (state.peek() == 1) {
            state.pop();
            state.push(2);
        }
        return this;
    }

    public LUBType Define_LUBType_lookupLUBType(ASTNode caller, ASTNode child, Collection bounds) {
        return this.getParent().Define_LUBType_lookupLUBType(this, caller, bounds);
    }

    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    public GenericMethodDecl Define_GenericMethodDecl_genericMethodDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_GenericMethodDecl_genericMethodDecl(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeNullPointerException(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeNullPointerException(this, caller);
    }

    public Collection Define_Collection_lookupConstructor(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Collection_lookupConstructor(this, caller);
    }

    public boolean Define_boolean_mayBeFinal(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeFinal(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeThrowable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeThrowable(this, caller);
    }

    public TypeDecl Define_TypeDecl_expectedType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_expectedType(this, caller);
    }

    public boolean Define_boolean_insideLoop(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_insideLoop(this, caller);
    }

    public boolean Define_boolean_isMethodParameter(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isMethodParameter(this, caller);
    }

    public LabeledStmt Define_LabeledStmt_lookupLabel(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_LabeledStmt_lookupLabel(this, caller, name);
    }

    public boolean Define_boolean_mayBePublic(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBePublic(this, caller);
    }

    public Collection Define_Collection_lookupSuperConstructor(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Collection_lookupSuperConstructor(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeRuntimeException(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeRuntimeException(this, caller);
    }

    public boolean Define_boolean_mayBeProtected(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeProtected(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeWildcard(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeWildcard(this, caller);
    }

    public boolean Define_boolean_variableArityValid(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_variableArityValid(this, caller);
    }

    public boolean Define_boolean_isMemberType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isMemberType(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeBoolean(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeBoolean(this, caller);
    }

    public TypeDecl Define_TypeDecl_componentType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_componentType(this, caller);
    }

    public boolean Define_boolean_enclosedByExceptionHandler(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_enclosedByExceptionHandler(this, caller);
    }

    public GLBType Define_GLBType_lookupGLBType(ASTNode caller, ASTNode child, ArrayList bounds) {
        return this.getParent().Define_GLBType_lookupGLBType(this, caller, bounds);
    }

    public boolean Define_boolean_isDUbefore(ASTNode caller, ASTNode child, Variable v) {
        return this.getParent().Define_boolean_isDUbefore(this, caller, v);
    }

    public boolean Define_boolean_mayBeStrictfp(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeStrictfp(this, caller);
    }

    public TypeDecl Define_TypeDecl_switchType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_switchType(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeObject(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeObject(this, caller);
    }

    public boolean Define_boolean_inExplicitConstructorInvocation(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_inExplicitConstructorInvocation(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeShort(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeShort(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeCloneable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeCloneable(this, caller);
    }

    public boolean Define_boolean_isLocalClass(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isLocalClass(this, caller);
    }

    public boolean Define_boolean_isNestedType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isNestedType(this, caller);
    }

    public String Define_String_methodHost(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_methodHost(this, caller);
    }

    public boolean Define_boolean_isDest(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isDest(this, caller);
    }

    public boolean Define_boolean_isSource(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isSource(this, caller);
    }

    public ArrayList Define_ArrayList_exceptionRanges(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ArrayList_exceptionRanges(this, caller);
    }

    public ConstructorDecl Define_ConstructorDecl_unknownConstructor(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ConstructorDecl_unknownConstructor(this, caller);
    }

    public ConstructorDecl Define_ConstructorDecl_constructorDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ConstructorDecl_constructorDecl(this, caller);
    }

    public TypeDecl Define_TypeDecl_declType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_declType(this, caller);
    }

    public GenericConstructorDecl Define_GenericConstructorDecl_genericConstructorDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_GenericConstructorDecl_genericConstructorDecl(this, caller);
    }

    public boolean Define_boolean_isConstructorParameter(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isConstructorParameter(this, caller);
    }

    public SimpleSet Define_SimpleSet_lookupVariable(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_SimpleSet_lookupVariable(this, caller, name);
    }

    public soot.jimple.Stmt Define_soot_jimple_Stmt_condition_false_label(ASTNode caller, ASTNode child) {
        return this.getParent().Define_soot_jimple_Stmt_condition_false_label(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeChar(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeChar(this, caller);
    }

    public TypeDecl Define_TypeDecl_lookupType(ASTNode caller, ASTNode child, String packageName, String typeName) {
        return this.getParent().Define_TypeDecl_lookupType(this, caller, packageName, typeName);
    }

    public boolean Define_boolean_mayBeAbstract(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeAbstract(this, caller);
    }

    public TypeDecl Define_TypeDecl_lookupWildcardExtends(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        return this.getParent().Define_TypeDecl_lookupWildcardExtends(this, caller, typeDecl);
    }

    public boolean Define_boolean_isAnonymous(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isAnonymous(this, caller);
    }

    public SimpleSet Define_SimpleSet_allImportedTypes(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_SimpleSet_allImportedTypes(this, caller, name);
    }

    public TypeDecl Define_TypeDecl_lookupWildcardSuper(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        return this.getParent().Define_TypeDecl_lookupWildcardSuper(this, caller, typeDecl);
    }

    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        return this.getParent().Define_ASTNode_enclosingBlock(this, caller);
    }

    public boolean Define_boolean_mayBeSynchronized(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeSynchronized(this, caller);
    }

    public boolean Define_boolean_reportUnreachable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_reportUnreachable(this, caller);
    }

    public TypeDecl Define_TypeDecl_enclosingInstance(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_enclosingInstance(this, caller);
    }

    public VariableScope Define_VariableScope_outerScope(ASTNode caller, ASTNode child) {
        return this.getParent().Define_VariableScope_outerScope(this, caller);
    }

    public CompilationUnit Define_CompilationUnit_compilationUnit(ASTNode caller, ASTNode child) {
        return this.getParent().Define_CompilationUnit_compilationUnit(this, caller);
    }

    public boolean Define_boolean_mayBePrivate(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBePrivate(this, caller);
    }

    public TypeDecl Define_TypeDecl_unknownType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_unknownType(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeSerializable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeSerializable(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeLong(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeLong(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeError(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeError(this, caller);
    }

    public Annotation Define_Annotation_lookupAnnotation(ASTNode caller, ASTNode child, TypeDecl typeDecl) {
        return this.getParent().Define_Annotation_lookupAnnotation(this, caller, typeDecl);
    }

    public boolean Define_boolean_mayBeTransient(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeTransient(this, caller);
    }

    public String Define_String_packageName(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_packageName(this, caller);
    }

    public boolean Define_boolean_mayBeNative(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeNative(this, caller);
    }

    public MethodDecl Define_MethodDecl_unknownMethod(ASTNode caller, ASTNode child) {
        return this.getParent().Define_MethodDecl_unknownMethod(this, caller);
    }

    public NameType Define_NameType_nameType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_NameType_nameType(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeNull(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeNull(this, caller);
    }

    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeString(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeString(this, caller);
    }

    public boolean Define_boolean_withinDeprecatedAnnotation(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_withinDeprecatedAnnotation(this, caller);
    }

    public TypeDecl Define_TypeDecl_assignConvertedType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_assignConvertedType(this, caller);
    }

    public Variable Define_Variable_unknownField(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Variable_unknownField(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeInt(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeInt(this, caller);
    }

    public String Define_String_hostPackage(ASTNode caller, ASTNode child) {
        return this.getParent().Define_String_hostPackage(this, caller);
    }

    public soot.jimple.Stmt Define_soot_jimple_Stmt_condition_true_label(ASTNode caller, ASTNode child) {
        return this.getParent().Define_soot_jimple_Stmt_condition_true_label(this, caller);
    }

    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    public boolean Define_boolean_insideSwitch(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_insideSwitch(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeByte(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeByte(this, caller);
    }

    public TypeDecl Define_TypeDecl_genericDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_genericDecl(this, caller);
    }

    public TypeDecl Define_TypeDecl_returnType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_returnType(this, caller);
    }

    public TypeDecl Define_TypeDecl_superType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_superType(this, caller);
    }

    public TypeDecl Define_TypeDecl_enclosingAnnotationDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_enclosingAnnotationDecl(this, caller);
    }

    public SimpleSet Define_SimpleSet_lookupType(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_SimpleSet_lookupType(this, caller, name);
    }

    public boolean Define_boolean_mayBeStatic(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeStatic(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeFloat(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeFloat(this, caller);
    }

    public Collection Define_Collection_lookupMethod(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_Collection_lookupMethod(this, caller, name);
    }

    public TypeDecl Define_TypeDecl_hostType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_hostType(this, caller);
    }

    public boolean Define_boolean_reachableCatchClause(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_reachableCatchClause(this, caller);
    }

    public boolean Define_boolean_mayUseAnnotationTarget(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_boolean_mayUseAnnotationTarget(this, caller, name);
    }

    public Expr Define_Expr_nestedScope(ASTNode caller, ASTNode child) {
        return this.getParent().Define_Expr_nestedScope(this, caller);
    }

    public boolean Define_boolean_isExceptionHandlerParameter(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isExceptionHandlerParameter(this, caller);
    }

    public boolean Define_boolean_hasPackage(ASTNode caller, ASTNode child, String packageName) {
        return this.getParent().Define_boolean_hasPackage(this, caller, packageName);
    }

    public boolean Define_boolean_withinSuppressWarnings(ASTNode caller, ASTNode child, String s) {
        return this.getParent().Define_boolean_withinSuppressWarnings(this, caller, s);
    }

    public TypeDecl Define_TypeDecl_typeVoid(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeVoid(this, caller);
    }

    public TypeDecl Define_TypeDecl_enclosingType(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_enclosingType(this, caller);
    }

    public Case Define_Case_bind(ASTNode caller, ASTNode child, Case c) {
        return this.getParent().Define_Case_bind(this, caller, c);
    }

    public TypeDecl Define_TypeDecl_typeException(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeException(this, caller);
    }

    public int Define_int_localNum(ASTNode caller, ASTNode child) {
        return this.getParent().Define_int_localNum(this, caller);
    }

    public boolean Define_boolean_mayBeVolatile(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_mayBeVolatile(this, caller);
    }

    public ElementValue Define_ElementValue_lookupElementTypeValue(ASTNode caller, ASTNode child, String name) {
        return this.getParent().Define_ElementValue_lookupElementTypeValue(this, caller, name);
    }

    public BodyDecl Define_BodyDecl_enclosingBodyDecl(ASTNode caller, ASTNode child) {
        return this.getParent().Define_BodyDecl_enclosingBodyDecl(this, caller);
    }

    public boolean Define_boolean_isIncOrDec(ASTNode caller, ASTNode child) {
        return this.getParent().Define_boolean_isIncOrDec(this, caller);
    }

    public TypeDecl Define_TypeDecl_typeDouble(ASTNode caller, ASTNode child) {
        return this.getParent().Define_TypeDecl_typeDouble(this, caller);
    }

    static {
        CHANGE = false;
        RESET_CYCLE = false;
        boundariesCrossed = 0;
        state = new ASTNode$State();
        duringDefiniteAssignment = 0;
        duringGenericTypeVariables = 0;
        duringVariableDeclaration = 0;
        duringBoundNames = 0;
        duringEnums = 0;
        duringLookupConstructor = 0;
        duringConstantExpression = 0;
        duringAnonymousClasses = 0;
        duringAnnotations = 0;
        duringSyntacticClassification = 0;
        duringResolveAmbiguousNames = 0;
    }
}

