/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import soot.ClassSource;
import soot.G;
import soot.SootClass;
import soot.SootMethod;
import soot.javaToJimple.IInitialResolver;
import soot.jimple.JimpleMethodSource;
import soot.jimple.parser.JimpleAST;
import soot.options.Options;

public class JimpleClassSource
extends ClassSource {
    protected InputStream classFile;

    public JimpleClassSource(String className, InputStream classFile) {
        super(className);
        this.classFile = classFile;
    }

    public IInitialResolver.Dependencies resolve(SootClass sc) {
        if (Options.v().verbose()) {
            G.v().out.println("resolving [from .jimple]: " + this.className);
        }
        JimpleAST jimpAST = new JimpleAST(this.classFile);
        jimpAST.getSkeleton(sc);
        JimpleMethodSource mtdSrc = new JimpleMethodSource(jimpAST);
        Iterator<SootMethod> mtdIt = sc.methodIterator();
        while (mtdIt.hasNext()) {
            SootMethod sm = mtdIt.next();
            sm.setSource(mtdSrc);
        }
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        deps.typesToSignature.addAll(jimpAST.getCstPool());
        try {
            this.classFile.close();
        }
        catch (IOException e) {
            throw new RuntimeException("!?");
        }
        return deps;
    }
}

