/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.Iterator;
import soot.Body;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.ThisRef;
import soot.util.Chain;

public class JimpleBody
extends StmtBody {
    JimpleBody(SootMethod m) {
        super(m);
    }

    JimpleBody() {
    }

    public Object clone() {
        JimpleBody b = new JimpleBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    public void validate() {
        super.validate();
        this.validateIdentityStatements();
    }

    public void validateIdentityStatements() {
        if (this.method.isAbstract()) {
            return;
        }
        Body body = this.method.getActiveBody();
        Chain<Unit> units = body.getUnits().getNonPatchingChain();
        boolean foundNonThisOrParamIdentityStatement = false;
        boolean firstStatement = true;
        Unit predStmt = null;
        for (Unit unit : units) {
            if (unit instanceof IdentityStmt) {
                IdentityStmt identityStmt = (IdentityStmt)unit;
                if (identityStmt.getRightOp() instanceof ThisRef) {
                    if (this.method.isStatic()) {
                        throw new RuntimeException("@this-assignment in a static method!");
                    }
                    if (!firstStatement) {
                        throw new RuntimeException("@this-assignment statement should precede all other statements: " + identityStmt + " after: " + predStmt + " in method: " + this.method.getSubSignature());
                    }
                } else if (identityStmt.getRightOp() instanceof ParameterRef) {
                    if (foundNonThisOrParamIdentityStatement) {
                        throw new RuntimeException("@param-assignment statements should precede all non-identity statements");
                    }
                } else {
                    foundNonThisOrParamIdentityStatement = true;
                }
            } else {
                foundNonThisOrParamIdentityStatement = true;
            }
            firstStatement = false;
            predStmt = unit;
        }
    }

    public void insertIdentityStmts() {
        int i = 0;
        if (!this.getMethod().isStatic()) {
            Local l = Jimple.v().newLocal("this", RefType.v(this.getMethod().getDeclaringClass()));
            this.getLocals().add(l);
            this.getUnits().addFirst(Jimple.v().newIdentityStmt(l, Jimple.v().newThisRef((RefType)l.getType())));
        }
        for (Type t : this.getMethod().getParameterTypes()) {
            Local l = Jimple.v().newLocal("parameter" + i, t);
            this.getLocals().add(l);
            this.getUnits().addFirst(Jimple.v().newIdentityStmt(l, Jimple.v().newParameterRef(l.getType(), i)));
            ++i;
        }
    }

    public Stmt getFirstNonIdentityStmt() {
        Iterator<Unit> it = this.getUnits().iterator();
        Unit o = null;
        while (it.hasNext() && (o = it.next()) instanceof IdentityStmt) {
        }
        if (o == null) {
            throw new RuntimeException("no non-id statements!");
        }
        return (Stmt)o;
    }
}

