/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import soot.ArrayType;
import soot.Body;
import soot.Context;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.G;
import soot.Kind;
import soot.Local;
import soot.MethodContext;
import soot.MethodOrMethodContext;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ContextManager;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.callgraph.VirtualCallSite;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.options.CGOptions;
import soot.util.LargeNumberedMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public final class OnFlyCallGraphBuilder {
    private final CallGraph cicg = new CallGraph();
    private final HashSet<SootMethod> analyzedMethods = new HashSet();
    private final LargeNumberedMap receiverToSites = new LargeNumberedMap(Scene.v().getLocalNumberer());
    private final LargeNumberedMap methodToReceivers = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private final SmallNumberedMap stringConstToSites = new SmallNumberedMap(Scene.v().getLocalNumberer());
    private final LargeNumberedMap methodToStringConstants = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private CGOptions options;
    private boolean appOnly;
    private ReachableMethods rm;
    private QueueReader worklist;
    private ContextManager cm;
    private final ChunkedQueue targetsQueue = new ChunkedQueue();
    private final QueueReader targets = this.targetsQueue.reader();
    private final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    private final NumberedString sigInit = Scene.v().getSubSigNumberer().findOrAdd("void <init>()");
    private final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    private final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    private final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    private final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");
    private final RefType clRunnable = RefType.v("java.lang.Runnable");

    public LargeNumberedMap methodToReceivers() {
        return this.methodToReceivers;
    }

    public LargeNumberedMap methodToStringConstants() {
        return this.methodToStringConstants;
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm) {
        this.cm = cm;
        this.rm = rm;
        this.worklist = rm.listener();
        this.options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        if (!this.options.verbose()) {
            G.v().out.println("[Call Graph] For information on where the call graph may be incomplete, use the verbose option to the cg phase.");
        }
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm, boolean appOnly) {
        this(cm, rm);
        this.appOnly = appOnly;
    }

    public void processReachables() {
        while (true) {
            if (!this.worklist.hasNext()) {
                this.rm.update();
                if (!this.worklist.hasNext()) break;
            }
            MethodOrMethodContext momc = (MethodOrMethodContext)this.worklist.next();
            SootMethod m = momc.method();
            if (this.appOnly && !m.getDeclaringClass().isApplicationClass()) continue;
            if (this.analyzedMethods.add(m)) {
                this.processNewMethod(m);
            }
            this.processNewMethodContext(momc);
        }
    }

    public boolean wantTypes(Local receiver) {
        return this.receiverToSites.get(receiver) != null;
    }

    public void addType(Local receiver, Context srcContext, Type type, Context typeContext) {
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        for (VirtualCallSite site : (Collection)this.receiverToSites.get(receiver)) {
            InstanceInvokeExpr iie = site.iie();
            if (site.kind() == Kind.THREAD && !fh.canStoreType(type, this.clRunnable)) continue;
            if (site.iie() instanceof SpecialInvokeExpr) {
                this.targetsQueue.add(VirtualCalls.v().resolveSpecial((SpecialInvokeExpr)site.iie(), site.subSig(), site.container()));
            } else {
                VirtualCalls.v().resolve(type, receiver.getType(), site.subSig(), site.container(), this.targetsQueue);
            }
            while (this.targets.hasNext()) {
                SootMethod target = (SootMethod)this.targets.next();
                this.cm.addVirtualEdge(MethodContext.v(site.container(), srcContext), site.stmt(), target, site.kind(), typeContext);
            }
        }
    }

    public boolean wantStringConstants(Local stringConst) {
        return this.stringConstToSites.get(stringConst) != null;
    }

    public void addStringConstant(Local l, Context srcContext, String constant) {
        for (VirtualCallSite site : (Collection)this.stringConstToSites.get(l)) {
            if (constant == null) {
                if (!this.options.verbose()) continue;
                G.v().out.println("Warning: Method " + site.container() + " is reachable, and calls Class.forName on a" + " non-constant String; graph will be incomplete!" + " Use safe-forname option for a conservative result.");
                continue;
            }
            if (constant.length() > 0 && constant.charAt(0) == '[') {
                if (constant.length() <= 1 || constant.charAt(1) != 'L' || constant.charAt(constant.length() - 1) != ';') continue;
                constant = constant.substring(2, constant.length() - 1);
            }
            if (!Scene.v().containsClass(constant)) {
                if (!this.options.verbose()) continue;
                G.v().out.println("Warning: Class " + constant + " is" + " a dynamic class, and you did not specify" + " it as such; graph will be incomplete!");
                continue;
            }
            SootClass sootcls = Scene.v().getSootClass(constant);
            if (!sootcls.isApplicationClass()) {
                sootcls.setLibraryClass();
            }
            for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                this.cm.addStaticEdge(MethodContext.v(site.container(), srcContext), site.stmt(), clinit, Kind.CLINIT);
            }
        }
    }

    private void addVirtualCallSite(Stmt s, SootMethod m, Local receiver, InstanceInvokeExpr iie, NumberedString subSig, Kind kind) {
        ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)this.receiverToSites.get(receiver);
        if (sites == null) {
            sites = new ArrayList<VirtualCallSite>();
            this.receiverToSites.put(receiver, sites);
            ArrayList<Local> receivers = (ArrayList<Local>)this.methodToReceivers.get(m);
            if (receivers == null) {
                receivers = new ArrayList<Local>();
                this.methodToReceivers.put(m, receivers);
            }
            receivers.add(receiver);
        }
        sites.add(new VirtualCallSite(s, m, iie, subSig, kind));
    }

    private void processNewMethod(SootMethod m) {
        if (m.isNative() || m.isPhantom()) {
            return;
        }
        Body b = m.retrieveActiveBody();
        this.getImplicitTargets(m);
        this.findReceivers(m, b);
    }

    private void findReceivers(SootMethod m, Body b) {
        for (Stmt stmt : b.getUnits()) {
            Local receiver;
            if (!stmt.containsInvokeExpr()) continue;
            InvokeExpr ie = stmt.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                receiver = (Local)iie.getBase();
                NumberedString subSig = iie.getMethodRef().getSubSignature();
                this.addVirtualCallSite(stmt, m, receiver, iie, subSig, Edge.ieToKind(iie));
                if (subSig != this.sigStart) continue;
                this.addVirtualCallSite(stmt, m, receiver, iie, this.sigRun, Kind.THREAD);
                continue;
            }
            SootMethod tgt = ((StaticInvokeExpr)ie).getMethod();
            this.addEdge(m, stmt, tgt);
            if (!tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>") && !tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>") && !tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>") && !tgt.getSignature().equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>")) continue;
            receiver = (Local)ie.getArg(0);
            this.addVirtualCallSite(stmt, m, receiver, null, this.sigObjRun, Kind.PRIVILEGED);
        }
    }

    private void getImplicitTargets(SootMethod source) {
        ArrayList<Local> stringConstants = (ArrayList<Local>)this.methodToStringConstants.get(source);
        if (stringConstants == null) {
            stringConstants = new ArrayList<Local>();
            this.methodToStringConstants.put(source, stringConstants);
        }
        SootClass scl = source.getDeclaringClass();
        if (source.isNative() || source.isPhantom()) {
            return;
        }
        if (source.getSubSignature().indexOf("<init>") >= 0) {
            this.handleInit(source, scl);
        }
        Body b = source.retrieveActiveBody();
        boolean warnedAlready = false;
        for (Stmt stmt : b.getUnits()) {
            FieldRef fr;
            if (stmt.containsInvokeExpr()) {
                InvokeExpr ie = stmt.getInvokeExpr();
                if (ie.getMethod().getSignature().equals("<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>") && !warnedAlready) {
                    if (this.options.verbose()) {
                        G.v().out.println("Warning: call to java.lang.reflect.Method: invoke() from " + source + "; graph will be incomplete!");
                    }
                    warnedAlready = true;
                }
                if (ie.getMethod().getSignature().equals("<java.lang.Class: java.lang.Object newInstance()>")) {
                    if (this.options.safe_newinstance()) {
                        for (SootMethod sootMethod : EntryPoints.v().inits()) {
                            this.addEdge(source, stmt, sootMethod, Kind.NEWINSTANCE);
                        }
                    } else {
                        for (SootClass sootClass : Scene.v().dynamicClasses()) {
                            if (!sootClass.declaresMethod(this.sigInit)) continue;
                            this.addEdge(source, stmt, sootClass.getMethod(this.sigInit), Kind.NEWINSTANCE);
                        }
                        if (this.options.verbose()) {
                            G.v().out.println("Warning: Method " + source + " is reachable, and calls Class.newInstance;" + " graph will be incomplete!" + " Use safe-newinstance option for a conservative result.");
                        }
                    }
                }
                if (ie instanceof StaticInvokeExpr) {
                    SootClass cl = ie.getMethodRef().declaringClass();
                    for (SootMethod clinit : EntryPoints.v().clinitsOf(cl)) {
                        this.addEdge(source, stmt, clinit, Kind.CLINIT);
                    }
                }
                if (ie.getMethodRef().getSubSignature() == this.sigForName) {
                    Value className = ie.getArg(0);
                    if (className instanceof StringConstant) {
                        String string = ((StringConstant)className).value;
                        this.constantForName(string, source, stmt);
                    } else {
                        Local local = (Local)className;
                        if (this.options.safe_forname()) {
                            for (SootMethod tgt : EntryPoints.v().clinits()) {
                                this.addEdge(source, stmt, tgt, Kind.CLINIT);
                            }
                        } else {
                            for (SootClass cls : Scene.v().dynamicClasses()) {
                                for (SootMethod clinit : EntryPoints.v().clinitsOf(cls)) {
                                    this.addEdge(source, stmt, clinit, Kind.CLINIT);
                                }
                            }
                            VirtualCallSite site = new VirtualCallSite(stmt, source, null, null, Kind.CLINIT);
                            ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)this.stringConstToSites.get(local);
                            if (sites == null) {
                                sites = new ArrayList<VirtualCallSite>();
                                this.stringConstToSites.put(local, sites);
                                stringConstants.add(local);
                            }
                            sites.add(site);
                        }
                    }
                }
            }
            if (stmt.containsFieldRef() && (fr = stmt.getFieldRef()) instanceof StaticFieldRef) {
                SootClass cl2 = fr.getFieldRef().declaringClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf(cl2)) {
                    this.addEdge(source, stmt, clinit, Kind.CLINIT);
                }
            }
            if (!(stmt instanceof AssignStmt)) continue;
            Value rhs = ((AssignStmt)stmt).getRightOp();
            if (rhs instanceof NewExpr) {
                NewExpr r = (NewExpr)rhs;
                SootClass sootClass = r.getBaseType().getSootClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf(sootClass)) {
                    this.addEdge(source, stmt, clinit, Kind.CLINIT);
                }
                continue;
            }
            if (!(rhs instanceof NewArrayExpr) && !(rhs instanceof NewMultiArrayExpr)) continue;
            Type t = rhs.getType();
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).baseType;
            }
            if (!(t instanceof RefType)) continue;
            SootClass sootClass = ((RefType)t).getSootClass();
            for (SootMethod clinit : EntryPoints.v().clinitsOf(sootClass)) {
                this.addEdge(source, stmt, clinit, Kind.CLINIT);
            }
        }
    }

    private void processNewMethodContext(MethodOrMethodContext momc) {
        SootMethod m = momc.method();
        Context ctxt = momc.context();
        Iterator<Edge> it = this.cicg.edgesOutOf(m);
        while (it.hasNext()) {
            Edge e = it.next();
            this.cm.addStaticEdge(momc, e.srcUnit(), e.tgt(), e.kind());
        }
    }

    private void handleInit(SootMethod source, SootClass scl) {
        this.addEdge(source, null, scl, this.sigFinalize, Kind.FINALIZE);
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
    }

    private void constantForName(String cls, SootMethod src, Stmt srcUnit) {
        if (cls.length() > 0 && cls.charAt(0) == '[') {
            if (cls.length() > 1 && cls.charAt(1) == 'L' && cls.charAt(cls.length() - 1) == ';') {
                cls = cls.substring(2, cls.length() - 1);
                this.constantForName(cls, src, srcUnit);
            }
        } else if (!Scene.v().containsClass(cls)) {
            if (this.options.verbose()) {
                G.v().out.println("Warning: Class " + cls + " is" + " a dynamic class, and you did not specify" + " it as such; graph will be incomplete!");
            }
        } else {
            SootClass sootcls = Scene.v().getSootClass(cls);
            if (!sootcls.isApplicationClass()) {
                sootcls.setLibraryClass();
            }
            for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                this.addEdge(src, srcUnit, clinit, Kind.CLINIT);
            }
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt, Kind kind) {
        this.cicg.addEdge(new Edge(src, stmt, tgt, kind));
    }

    private void addEdge(SootMethod src, Stmt stmt, SootClass cls, NumberedString methodSubSig, Kind kind) {
        if (cls.declaresMethod(methodSubSig)) {
            this.addEdge(src, stmt, cls.getMethod(methodSubSig), kind);
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt) {
        InvokeExpr ie = stmt.getInvokeExpr();
        this.addEdge(src, stmt, tgt, Edge.ieToKind(ie));
    }
}

