/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.RefLikeType;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class LocalMustNotAliasAnalysis
extends ForwardFlowAnalysis {
    protected static final Object UNKNOWN = new Object(){

        public String toString() {
            return "UNKNOWN";
        }
    };
    protected List<Local> locals = new LinkedList<Local>();

    public LocalMustNotAliasAnalysis(UnitGraph g) {
        super(g);
        this.locals.addAll(g.getBody().getLocals());
        for (Local l : g.getBody().getLocals()) {
            if (!(l.getType() instanceof RefLikeType)) continue;
            this.locals.add(l);
        }
        this.doAnalysis();
    }

    protected void merge(Object in1, Object in2, Object o) {
        HashMap inMap1 = (HashMap)in1;
        HashMap inMap2 = (HashMap)in2;
        HashMap outMap = (HashMap)o;
        for (Local l : this.locals) {
            Set l1 = (Set)inMap1.get(l);
            Set l2 = (Set)inMap2.get(l);
            Set out = (Set)outMap.get(l);
            out.clear();
            if (l1.contains(UNKNOWN) || l2.contains(UNKNOWN)) {
                out.add(UNKNOWN);
                continue;
            }
            out.addAll(l1);
            out.addAll(l2);
        }
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        HashMap in = (HashMap)inValue;
        HashMap out = (HashMap)outValue;
        Stmt s = (Stmt)unit;
        out.clear();
        out.putAll(in);
        if (s instanceof DefinitionStmt) {
            DefinitionStmt ds = (DefinitionStmt)s;
            Value lhs = ds.getLeftOp();
            Value rhs = ds.getRightOp();
            if (lhs instanceof Local) {
                HashSet<Object> lv = new HashSet<Object>();
                out.put(lhs, lv);
                if (rhs instanceof NewExpr) {
                    lv.add(rhs);
                } else if (rhs instanceof Local) {
                    lv.addAll((HashSet)in.get(rhs));
                } else {
                    lv.add(UNKNOWN);
                }
            }
        }
    }

    protected void copy(Object source, Object dest) {
        HashMap sourceMap = (HashMap)source;
        HashMap destMap = (HashMap)dest;
        destMap.putAll(sourceMap);
    }

    protected Object entryInitialFlow() {
        HashMap m = new HashMap();
        for (Local l : this.locals) {
            HashSet<Object> s = new HashSet<Object>();
            s.add(UNKNOWN);
            m.put(l, s);
        }
        return m;
    }

    protected Object newInitialFlow() {
        HashMap m = new HashMap();
        for (Local l : this.locals) {
            HashSet s = new HashSet();
            m.put(l, s);
        }
        return m;
    }

    public boolean hasInfoOn(Local l, Stmt s) {
        HashMap flowBefore = (HashMap)this.getFlowBefore(s);
        if (flowBefore == null) {
            return false;
        }
        Set info = (Set)flowBefore.get(l);
        return info != null && !info.contains(UNKNOWN);
    }

    public boolean notMayAlias(Local l1, Stmt s1, Local l2, Stmt s2) {
        Set l1n = (Set)((HashMap)this.getFlowBefore(s1)).get(l1);
        Set l2n = (Set)((HashMap)this.getFlowBefore(s2)).get(l2);
        if (l1n.contains(UNKNOWN) || l2n.contains(UNKNOWN)) {
            return false;
        }
        HashSet n = new HashSet();
        n.addAll(l1n);
        n.retainAll(l2n);
        return n.isEmpty();
    }
}

