/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.PAG;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.thread.mhp.StartJoinAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartJoinFinder {
    Set<Stmt> startStatements = new HashSet<Stmt>();
    Set<Stmt> joinStatements = new HashSet<Stmt>();
    Map<Stmt, List<SootMethod>> startToRunMethods = new HashMap<Stmt, List<SootMethod>>();
    Map<Stmt, List<AllocNode>> startToAllocNodes = new HashMap<Stmt, List<AllocNode>>();
    Map<Stmt, Stmt> startToJoin = new HashMap<Stmt, Stmt>();
    Map<Stmt, SootMethod> startToContainingMethod = new HashMap<Stmt, SootMethod>();

    public StartJoinFinder(CallGraph callGraph, PAG pag) {
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootMethod method : appClass.getMethods()) {
                boolean mayHaveStartStmt = false;
                Iterator<Edge> edgesIt = callGraph.edgesOutOf(method);
                while (edgesIt.hasNext()) {
                    SootMethod target = edgesIt.next().tgt();
                    if (!target.getName().equals("start") && !target.getName().equals("run")) continue;
                    mayHaveStartStmt = true;
                }
                if (!mayHaveStartStmt || !method.isConcrete()) continue;
                Body b = method.retrieveActiveBody();
                StartJoinAnalysis sja = new StartJoinAnalysis(new ExceptionalUnitGraph(b), method, callGraph, pag);
                this.startStatements.addAll(sja.getStartStatements());
                this.joinStatements.addAll(sja.getJoinStatements());
                this.startToRunMethods.putAll(sja.getStartToRunMethods());
                this.startToAllocNodes.putAll(sja.getStartToAllocNodes());
                this.startToJoin.putAll(sja.getStartToJoin());
                for (Stmt start : sja.getStartStatements()) {
                    this.startToContainingMethod.put(start, method);
                }
            }
        }
    }

    public Set<Stmt> getStartStatements() {
        return this.startStatements;
    }

    public Set<Stmt> getJoinStatements() {
        return this.joinStatements;
    }

    public Map<Stmt, List<SootMethod>> getStartToRunMethods() {
        return this.startToRunMethods;
    }

    public Map<Stmt, List<AllocNode>> getStartToAllocNodes() {
        return this.startToAllocNodes;
    }

    public Map<Stmt, Stmt> getStartToJoin() {
        return this.startToJoin;
    }

    public Map<Stmt, SootMethod> getStartToContainingMethod() {
        return this.startToContainingMethod;
    }
}

