/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.G;
import soot.toolkits.graph.DGEdge;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.toolkits.graph.MutableEdgeLabelledDirectedGraph;
import soot.util.Chain;
import soot.util.HashChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMutableEdgeLabelledDirectedGraph
implements MutableEdgeLabelledDirectedGraph {
    protected HashMap<Object, ArrayList> nodeToPreds = new HashMap();
    protected HashMap<Object, ArrayList> nodeToSuccs = new HashMap();
    protected HashMap<DGEdge, ArrayList<Object>> edgeToLabels = new HashMap();
    protected HashMap<Object, ArrayList<DGEdge>> labelToEdges = new HashMap();
    protected Chain heads = new HashChain();
    protected Chain tails = new HashChain();

    public void clearAll() {
        this.nodeToPreds = new HashMap();
        this.nodeToSuccs = new HashMap();
        this.edgeToLabels = new HashMap();
        this.labelToEdges = new HashMap();
        this.heads = new HashChain();
        this.tails = new HashChain();
    }

    public Object clone() {
        HashMutableEdgeLabelledDirectedGraph g = new HashMutableEdgeLabelledDirectedGraph();
        g.nodeToPreds = (HashMap)this.nodeToPreds.clone();
        g.nodeToSuccs = (HashMap)this.nodeToSuccs.clone();
        g.edgeToLabels = (HashMap)this.edgeToLabels.clone();
        g.labelToEdges = (HashMap)this.labelToEdges.clone();
        g.heads = HashChain.listToHashChain(HashChain.toList(this.heads));
        g.tails = HashChain.listToHashChain(HashChain.toList(this.tails));
        return g;
    }

    public List getHeads() {
        ArrayList l = new ArrayList();
        l.addAll(this.heads);
        return Collections.unmodifiableList(l);
    }

    public List getTails() {
        ArrayList l = new ArrayList();
        l.addAll(this.tails);
        return Collections.unmodifiableList(l);
    }

    public List getPredsOf(Object s) {
        List l = this.nodeToPreds.get(s);
        if (l != null) {
            return Collections.unmodifiableList(l);
        }
        throw new RuntimeException(s + "not in graph!");
    }

    public List getSuccsOf(Object s) {
        List l = this.nodeToSuccs.get(s);
        if (l != null) {
            return Collections.unmodifiableList(l);
        }
        throw new RuntimeException(s + "not in graph!");
    }

    @Override
    public int size() {
        return this.nodeToPreds.keySet().size();
    }

    @Override
    public Iterator iterator() {
        return this.nodeToPreds.keySet().iterator();
    }

    @Override
    public void addEdge(Object from, Object to, Object label) {
        DGEdge edge;
        if (from == null || to == null) {
            throw new RuntimeException("edge from or to null");
        }
        if (label == null) {
            throw new RuntimeException("edge with null label");
        }
        if (this.containsEdge(from, to, label)) {
            return;
        }
        List succsList = this.nodeToSuccs.get(from);
        if (succsList == null) {
            throw new RuntimeException(from + " not in graph!");
        }
        List predsList = this.nodeToPreds.get(to);
        if (predsList == null) {
            throw new RuntimeException(to + " not in graph!");
        }
        if (this.heads.contains(to)) {
            this.heads.remove(to);
        }
        if (this.tails.contains(from)) {
            this.tails.remove(from);
        }
        if (!succsList.contains(to)) {
            succsList.add(to);
        }
        if (!predsList.contains(from)) {
            predsList.add(from);
        }
        if (!this.edgeToLabels.containsKey(edge = new DGEdge(from, to))) {
            this.edgeToLabels.put(edge, new ArrayList());
        }
        List labels = this.edgeToLabels.get(edge);
        if (!this.labelToEdges.containsKey(label)) {
            this.labelToEdges.put(label, new ArrayList());
        }
        List edges = this.labelToEdges.get(label);
        labels.add(label);
        edges.add(edge);
    }

    @Override
    public List<Object> getLabelsForEdges(Object from, Object to) {
        DGEdge edge = new DGEdge(from, to);
        return this.edgeToLabels.get(edge);
    }

    @Override
    public MutableDirectedGraph getEdgesForLabel(Object label) {
        List edges = this.labelToEdges.get(label);
        HashMutableDirectedGraph ret = new HashMutableDirectedGraph();
        if (edges == null) {
            return ret;
        }
        for (DGEdge edge : edges) {
            if (!ret.containsNode(edge.from())) {
                ret.addNode(edge.from());
            }
            if (!ret.containsNode(edge.to())) {
                ret.addNode(edge.to());
            }
            ret.addEdge(edge.from(), edge.to());
        }
        return ret;
    }

    @Override
    public void removeEdge(Object from, Object to, Object label) {
        if (!this.containsEdge(from, to, label)) {
            return;
        }
        DGEdge edge = new DGEdge(from, to);
        List labels = this.edgeToLabels.get(edge);
        if (labels == null) {
            throw new RuntimeException("edge " + edge + " not in graph!");
        }
        List edges = this.labelToEdges.get(label);
        if (edges == null) {
            throw new RuntimeException("label " + label + " not in graph!");
        }
        labels.remove(label);
        edges.remove(edge);
        if (labels.isEmpty()) {
            this.edgeToLabels.remove(edge);
            List succsList = this.nodeToSuccs.get(from);
            if (succsList == null) {
                throw new RuntimeException(from + " not in graph!");
            }
            List predsList = this.nodeToPreds.get(to);
            if (predsList == null) {
                throw new RuntimeException(to + " not in graph!");
            }
            succsList.remove(to);
            predsList.remove(from);
            if (succsList.isEmpty()) {
                this.tails.add(from);
            }
            if (predsList.isEmpty()) {
                this.heads.add(to);
            }
        }
        if (edges.isEmpty()) {
            this.labelToEdges.remove(label);
        }
    }

    @Override
    public void removeAllEdges(Object from, Object to) {
        if (!this.containsAnyEdge(from, to)) {
            return;
        }
        DGEdge edge = new DGEdge(from, to);
        List labels = this.edgeToLabels.get(edge);
        if (labels == null) {
            throw new RuntimeException("edge " + edge + " not in graph!");
        }
        for (Object label : labels) {
            this.removeEdge(from, to, label);
        }
    }

    @Override
    public void removeAllEdges(Object label) {
        if (!this.containsAnyEdge(label)) {
            return;
        }
        List edges = this.labelToEdges.get(label);
        if (edges == null) {
            throw new RuntimeException("label " + label + " not in graph!");
        }
        for (DGEdge edge : edges) {
            this.removeEdge(edge.from(), edge.to(), label);
        }
    }

    @Override
    public boolean containsEdge(Object from, Object to, Object label) {
        DGEdge edge = new DGEdge(from, to);
        return this.edgeToLabels.get(edge) != null && this.edgeToLabels.get(edge).contains(label);
    }

    @Override
    public boolean containsAnyEdge(Object from, Object to) {
        DGEdge edge = new DGEdge(from, to);
        return this.edgeToLabels.get(edge) == null || !this.edgeToLabels.get(edge).isEmpty();
    }

    @Override
    public boolean containsAnyEdge(Object label) {
        return this.labelToEdges.get(label) == null || !this.labelToEdges.get(label).isEmpty();
    }

    @Override
    public boolean containsNode(Object node) {
        return this.nodeToPreds.keySet().contains(node);
    }

    @Override
    public List<Object> getNodes() {
        return Arrays.asList(this.nodeToPreds.keySet().toArray());
    }

    @Override
    public void addNode(Object node) {
        if (this.containsNode(node)) {
            throw new RuntimeException("Node already in graph");
        }
        this.nodeToSuccs.put(node, new ArrayList());
        this.nodeToPreds.put(node, new ArrayList());
        this.heads.add(node);
        this.tails.add(node);
    }

    @Override
    public void removeNode(Object node) {
        List succs = (List)this.nodeToSuccs.get(node).clone();
        Iterator succsIt = succs.iterator();
        while (succsIt.hasNext()) {
            this.removeAllEdges(node, succsIt.next());
        }
        this.nodeToSuccs.remove(node);
        List preds = (List)this.nodeToPreds.get(node).clone();
        Iterator predsIt = preds.iterator();
        while (predsIt.hasNext()) {
            this.removeAllEdges(predsIt.next(), node);
        }
        this.nodeToPreds.remove(node);
        if (this.heads.contains(node)) {
            this.heads.remove(node);
        }
        if (this.tails.contains(node)) {
            this.tails.remove(node);
        }
    }

    public void printGraph() {
        for (Object node : this) {
            List labels;
            DGEdge edge;
            G.v().out.println("Node = " + node);
            G.v().out.println("Preds:");
            for (Object pred : this.getPredsOf(node)) {
                edge = new DGEdge(pred, node);
                labels = this.edgeToLabels.get(edge);
                G.v().out.println("     " + pred + " [" + labels + "]");
            }
            G.v().out.println("Succs:");
            for (Object succ : this.getSuccsOf(node)) {
                edge = new DGEdge(node, succ);
                labels = this.edgeToLabels.get(edge);
                G.v().out.println("     " + succ + " [" + labels + "]");
            }
        }
    }
}

