/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import soot.Body;
import soot.G;
import soot.HjToJimple.jimple.RegionStmt;
import soot.SootMethod;
import soot.Unit;
import soot.UnitBox;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnitGraph
implements DirectedGraph<Unit> {
    List<Unit> heads;
    List<Unit> tails;
    protected Map<Unit, List<Unit>> unitToSuccs;
    protected Map<Unit, List<Unit>> unitToPreds;
    protected SootMethod method;
    protected Body body;
    protected Chain<Unit> unitChain;

    protected UnitGraph(Body body) {
        this.body = body;
        this.unitChain = body.getUnits();
        this.method = body.getMethod();
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.method.getName() + "]     Constructing " + this.getClass().getName() + "...");
        }
    }

    protected void buildUnexceptionalEdges(Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds) {
        Unit nextUnit;
        Iterator<Unit> unitIt = this.unitChain.iterator();
        while (unitIt.hasNext()) {
            unitToPreds.put(unitIt.next(), new ArrayList());
        }
        unitIt = this.unitChain.iterator();
        Unit unit = nextUnit = unitIt.hasNext() ? unitIt.next() : null;
        while (nextUnit != null) {
            RegionStmt regionStmt;
            Unit currentUnit = nextUnit;
            nextUnit = unitIt.hasNext() ? unitIt.next() : null;
            ArrayList<Unit> successors = new ArrayList<Unit>();
            if (currentUnit.fallsThrough() && nextUnit != null) {
                successors.add(nextUnit);
                unitToPreds.get(nextUnit).add(currentUnit);
            }
            if (currentUnit.branches()) {
                Iterator<UnitBox> targetIt = currentUnit.getUnitBoxes().iterator();
                while (targetIt.hasNext()) {
                    Unit target = targetIt.next().getUnit();
                    if (successors.contains(target)) continue;
                    successors.add(target);
                    unitToPreds.get(target).add(currentUnit);
                }
            }
            unitToSuccs.put(currentUnit, successors);
            if (!(currentUnit instanceof RegionStmt) || (regionStmt = (RegionStmt)currentUnit).getConnect() == null || !regionStmt.isFinishRegion()) continue;
            this.addEdge(unitToSuccs, unitToPreds, regionStmt, regionStmt.getConnect());
        }
    }

    protected void buildHeadsAndTails() {
        ArrayList<Unit> tailList = new ArrayList<Unit>();
        ArrayList<Unit> headList = new ArrayList<Unit>();
        for (Unit s : this.unitChain) {
            List<Unit> preds;
            List<Unit> succs = this.unitToSuccs.get(s);
            if (succs.size() == 0) {
                tailList.add(s);
            }
            if ((preds = this.unitToPreds.get(s)).size() != 0) continue;
            headList.add(s);
        }
        Unit entryPoint = this.unitChain.getFirst();
        if (!headList.contains(entryPoint)) {
            headList.add(entryPoint);
        }
        this.tails = Collections.unmodifiableList(tailList);
        this.heads = Collections.unmodifiableList(headList);
    }

    protected static void makeMappedListsUnmodifiable(Map<?, List<Unit>> map) {
        for (Map.Entry<?, List<Unit>> entry : map.entrySet()) {
            List<Unit> value = entry.getValue();
            if (value.size() == 0) {
                entry.setValue(Collections.emptyList());
                continue;
            }
            entry.setValue(Collections.unmodifiableList(value));
        }
    }

    protected Map<Unit, List<Unit>> combineMapValues(Map<Unit, List<Unit>> mapA, Map<Unit, List<Unit>> mapB) {
        HashMap<Unit, List<Unit>> result = new HashMap<Unit, List<Unit>>(mapA.size() * 2 + 1, 0.7f);
        for (Unit unit : this.unitChain) {
            int resultSize;
            List<Unit> listB;
            List<Unit> listA = mapA.get(unit);
            if (listA == null) {
                listA = Collections.emptyList();
            }
            if ((listB = mapB.get(unit)) == null) {
                listB = Collections.emptyList();
            }
            if ((resultSize = listA.size() + listB.size()) == 0) {
                result.put(unit, Collections.emptyList());
                continue;
            }
            ArrayList<Unit> resultList = new ArrayList<Unit>(resultSize);
            Iterator<Unit> listIt = null;
            if (listA.size() >= listB.size()) {
                resultList.addAll(listA);
                listIt = listB.iterator();
            } else {
                resultList.addAll(listB);
                listIt = listA.iterator();
            }
            while (listIt.hasNext()) {
                Unit element = listIt.next();
                if (resultList.contains(element)) continue;
                resultList.add(element);
            }
            result.put(unit, Collections.unmodifiableList(resultList));
        }
        return result;
    }

    protected void addEdge(Map<Unit, List<Unit>> unitToSuccs, Map<Unit, List<Unit>> unitToPreds, Unit head, Unit tail) {
        List<Unit> headsSuccs = unitToSuccs.get(head);
        if (headsSuccs == null) {
            headsSuccs = new ArrayList<Unit>(3);
            unitToSuccs.put(head, headsSuccs);
        }
        if (!headsSuccs.contains(tail)) {
            headsSuccs.add(tail);
            List<Unit> tailsPreds = unitToPreds.get(tail);
            if (tailsPreds == null) {
                tailsPreds = new ArrayList<Unit>();
                unitToPreds.put(tail, tailsPreds);
            }
            tailsPreds.add(head);
        }
    }

    public Body getBody() {
        return this.body;
    }

    public List<Unit> getExtendedBasicBlockPathBetween(Unit from, Unit to) {
        UnitGraph g = this;
        if (g.getPredsOf(to).size() > 1) {
            return null;
        }
        LinkedList<Unit> pathStack = new LinkedList<Unit>();
        LinkedList<Integer> pathStackIndex = new LinkedList<Integer>();
        pathStack.add(from);
        pathStackIndex.add(new Integer(0));
        int psiMax = g.getSuccsOf((Unit)pathStack.get(0)).size();
        int level = 0;
        while ((Integer)pathStackIndex.get(0) != psiMax) {
            List<Unit> succs;
            int p = (Integer)pathStackIndex.get(level);
            if (p >= (succs = g.getSuccsOf((Unit)pathStack.get(level))).size()) {
                pathStack.remove(level);
                pathStackIndex.remove(level);
                int q = (Integer)pathStackIndex.get(--level);
                pathStackIndex.set(level, new Integer(q + 1));
                continue;
            }
            Unit betweenUnit = succs.get(p);
            if (betweenUnit == to) {
                pathStack.add(to);
                return pathStack;
            }
            if (g.getPredsOf(betweenUnit).size() > 1) {
                pathStackIndex.set(level, new Integer(p + 1));
                continue;
            }
            ++level;
            pathStackIndex.add(new Integer(0));
            pathStack.add(betweenUnit);
        }
        return null;
    }

    @Override
    public List<Unit> getHeads() {
        return this.heads;
    }

    @Override
    public List<Unit> getTails() {
        return this.tails;
    }

    @Override
    public List<Unit> getPredsOf(Unit u) {
        if (!this.unitToPreds.containsKey(u)) {
            throw new NoSuchElementException("Invalid unit " + u);
        }
        return this.unitToPreds.get(u);
    }

    @Override
    public List<Unit> getSuccsOf(Unit u) {
        List<Unit> l = this.unitToSuccs.get(u);
        if (l == null) {
            throw new RuntimeException("Invalid unit " + u);
        }
        return l;
    }

    @Override
    public int size() {
        return this.unitChain.size();
    }

    @Override
    public Iterator<Unit> iterator() {
        return this.unitChain.iterator();
    }

    public String toString() {
        Iterator<Unit> it = this.unitChain.iterator();
        StringBuffer buf = new StringBuffer();
        while (it.hasNext()) {
            Unit u = it.next();
            buf.append("// preds: " + this.getPredsOf(u) + "\n");
            buf.append(u.toString() + '\n');
            buf.append("// succs " + this.getSuccsOf(u) + "\n");
        }
        return buf.toString();
    }
}

