/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ContiguousRange;
import hj.array.Distribution_c;
import hj.array.MultiDimRegion;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;

public class BlockIJK
extends Distribution_c {
    final region[] regions;
    final region procGrid;
    final int x;
    final int y;
    final int z;
    final int sizeX;
    final int sizeY;
    final int sizeZ;

    public boolean powerOf2(int p) {
        if (p == 0) {
            return false;
        }
        while (p > 1) {
            if ((p /= 2) % 2 != 1) continue;
            return false;
        }
        return true;
    }

    public int log2(int p) {
        assert (this.powerOf2(p));
        int i = 0;
        while (p > 1) {
            p /= 2;
            ++i;
        }
        return i;
    }

    public int pow2(int i) {
        int p = 1;
        for (int j = i; j > 0; --j) {
            p *= 2;
        }
        return p;
    }

    public BlockIJK(region r, int P) {
        super(r, place.places(P));
        assert (r instanceof MultiDimRegion);
        int p = this.log2(P);
        int loX = r.rank(0).low();
        int hiX = r.rank(0).high();
        int I = hiX - loX + 1;
        int loY = r.rank(1).low();
        int hiY = r.rank(1).high();
        int J = hiY - loY + 1;
        int loZ = r.rank(2).low();
        int hiZ = r.rank(2).high();
        int K = hiZ - loZ + 1;
        assert (this.powerOf2(I) && this.powerOf2(J) && this.powerOf2(K));
        int a = p / 3;
        int b = p % 3;
        this.x = a + (b > 0 ? 1 : 0);
        this.sizeX = I / this.pow2(this.x);
        this.y = a + (b > 1 ? 1 : 0);
        this.sizeY = J / this.pow2(this.y);
        this.z = a;
        this.sizeZ = K / this.pow2(this.z);
        this.regions = new region[p];
        this.procGrid = new MultiDimRegion(new region[]{new ContiguousRange(0, this.x - 1), new ContiguousRange(0, this.y - 1), new ContiguousRange(0, this.z - 1)}, true);
        for (int pp = 0; pp < p; ++pp) {
            int q = pp;
            int k = q % K;
            int j = (q /= K) % J;
            int i = (q /= J) % I;
            this.regions[pp] = new MultiDimRegion(new region[]{new ContiguousRange(this.sizeX * i + loX + 1, this.sizeX * (i + 1) + loX), new ContiguousRange(this.sizeY * j + loY + 1, this.sizeY * (j + 1) + loY), new ContiguousRange(this.sizeZ * k + loZ + 1, this.sizeZ * (k + 1) + loZ)}, false);
        }
    }

    int ord(int i, int j, int k) {
        return k + this.z * (j + this.y * i);
    }

    public place get(point p) throws dist.MalformedError {
        int[] r = p.val();
        int i = r[0] / this.sizeX;
        int j = r[1] / this.sizeY;
        int k = r[2] / this.sizeZ;
        return Runtime.factory.getPlaceFactory().place(this.ord(i, j, k));
    }

    public final region[] getPerPlaceRegions() {
        return this.regions;
    }

    public region restrictToRegion(place P) {
        return this.regions[P.id];
    }
}

