/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class EmptyRegion
extends region {
    public EmptyRegion(int rank) {
        super(rank, true, true);
    }

    public int size() {
        return 0;
    }

    public region rank(int index) {
        assert (index < this.rank);
        return new EmptyRegion(1);
    }

    public boolean isConvex() {
        return true;
    }

    public int low() {
        throw new UnsupportedOperationException();
    }

    public int high() {
        throw new UnsupportedOperationException();
    }

    public region union(region r) {
        assert (r != null);
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        return r;
    }

    public region intersection(region r) {
        assert (r != null);
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        return this;
    }

    public region difference(region r) {
        assert (r != null);
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        return this;
    }

    public region convexHull() {
        return this;
    }

    public boolean contains(region r) {
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        return r.size() == 0;
    }

    public boolean contains(point p) {
        if (p.rank != this.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        return false;
    }

    public boolean contains(int[] p) {
        assert (this.rank == p.length);
        return false;
    }

    public boolean disjoint(region r) {
        if (r.rank != this.rank) {
            throw new RankMismatchException(r, this.rank);
        }
        return true;
    }

    public region[] partition(int n, int dim) {
        assert (n > 0);
        region[] ret = new region[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = new EmptyRegion(this.rank);
        }
        return ret;
    }

    public int ordinal(point p) throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    public point coord(int ord) throws ArrayIndexOutOfBoundsException {
        throw new ArrayIndexOutOfBoundsException();
    }

    public Iterator iterator() {
        return new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public Object next() throws NoSuchElementException {
                throw new NoSuchElementException();
            }
        };
    }

    public String toString() {
        return "EmptyRegion(" + this.rank + ")";
    }

    public boolean equals(Object o) {
        boolean ret;
        if (o == null || !(o instanceof region)) {
            ret = false;
        } else {
            region oe = (region)o;
            ret = oe.rank == this.rank && oe.size() == 0;
        }
        return ret;
    }
}

