/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.Helper;
import hj.array.Operator;
import hj.array.lang.IntReferenceArray;
import hj.array.lang.intArray;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class IntArray
extends IntReferenceArray {
    public IntArray(dist d, boolean mutable) {
        super(d, mutable);
    }

    protected abstract IntArray newInstance(dist var1);

    protected abstract IntArray newInstance(dist var1, int var2);

    protected final IntArray newInstance(dist d, Operator.Pointwise p) {
        IntArray res = this.newInstance(d);
        if (p != null) {
            this.scan(res, p);
        }
        return res;
    }

    public abstract int getOrdinal(int var1);

    public abstract int setOrdinal(int var1, int var2);

    public int set(int v, point pos) {
        return this.set(v, pos, true, true);
    }

    public int set(int v, point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public int set(int v, int d0) {
        return this.set(v, d0, true, true);
    }

    public int set(int v, int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public int set(int v, int d0, int d1) {
        return this.set(v, d0, d1, true, true);
    }

    public int set(int v, int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public int set(int v, int d0, int d1, int d2) {
        return this.set(v, d0, d1, d2, true, true);
    }

    public int set(int v, int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public int set(int v, int d0, int d1, int d2, int d3) {
        return this.set(v, d0, d1, d2, d3, true, true);
    }

    public int set(int v, int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public int get(point pos) {
        return this.get(pos, true, true);
    }

    public int get(point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public int get(int d0) {
        return this.get(d0, true, true);
    }

    public int get(int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public int get(int d0, int d1) {
        return this.get(d0, d1, true, true);
    }

    public int get(int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public int get(int d0, int d1, int d2) {
        return this.get(d0, d1, d2, true, true);
    }

    public int get(int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public int get(int d0, int d1, int d2, int d3) {
        return this.get(d0, d1, d2, d3, true, true);
    }

    public int get(int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.getOrdinal(theIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEquals(Indexable other) {
        IntArray o = (IntArray)other;
        if (!o.distribution.equals(this.distribution)) {
            return false;
        }
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                if (this.get(pos) == o.get(pos)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assign(IntArray rhs) {
        assert (rhs instanceof IntArray);
        assert (rhs.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        IntArray rhs_t = rhs;
        try {
            Iterator it = rhs_t.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(rhs_t.get(pos), pos);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(IntArray res, Operator.Pointwise op, IntArray arg) {
        assert (res == null || res.distribution.equals(this.distribution));
        assert (arg != null);
        assert (arg.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int arg1 = this.get(p);
                int arg2 = arg.get(p);
                int val = op.apply(p, arg1, arg2);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(IntArray res, Operator.Pointwise op) {
        assert (res == null || res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int arg1 = this.get(p);
                int val = op.apply(p, arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduction(Operator.Reduction op) {
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int arg1 = this.get(p);
                op.apply(arg1);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(region targetRegion, IntArray res, Operator.Unary op) {
        assert (res == null || res instanceof IntArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = targetRegion.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int arg1 = this.get(p);
                int val = op.apply(arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(IntArray res, Operator.Unary op) {
        assert (res == null || res instanceof IntArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int arg1 = this.get(p);
                int val = op.apply(arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(IntArray res, Operator.Pointwise op) {
        assert (res == null || res instanceof IntArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int val = op.apply(p, 0);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntReferenceArray lift(Operator.Binary op, intArray arg) {
        assert (arg.distribution.equals(this.distribution));
        IntArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((IntReferenceArray)result).set(op.apply(this.get(p), arg.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntReferenceArray lift(Operator.Unary op) {
        IntArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((IntReferenceArray)result).set(op.apply(this.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reduce(Operator.Binary op, region localRegion) {
        int result = 0;
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = localRegion.iterator();
            point p = (point)it.next();
            place pl = this.distribution.get(p);
            Runtime.runtime.setCurrentPlace(pl);
            result = this.get(p);
            while (it.hasNext()) {
                p = (point)it.next();
                pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result = op.apply(this.get(p), result);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reduce(Operator.Binary op, int unit) {
        int result = unit;
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result = op.apply(this.get(p), result);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntReferenceArray scan(Operator.Binary op, int unit) {
        int temp = unit;
        IntArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                temp = op.apply(this.get(p), temp);
                ((IntReferenceArray)result).set(temp, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntReferenceArray overlay(intArray d) {
        dist dist2 = this.distribution.overlay(d.distribution);
        IntArray ret = this.newInstance(dist2, 0);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int val = d.distribution.region.contains(p) ? d.get(p) : this.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(intArray d) {
        assert (this.region.contains(d.region));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = d.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(d.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntReferenceArray union(intArray d) {
        dist dist2 = this.distribution.union(d.distribution);
        IntArray ret = this.newInstance(dist2, 0);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                int val = this.distribution.region.contains(p) ? this.get(p) : d.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public IntReferenceArray restriction(dist d) {
        return this.restriction(d.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntReferenceArray restriction(region d) {
        dist dist2 = this.distribution.restriction(d);
        IntArray ret = this.newInstance(dist2, 0);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ret.set(this.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public Object toJava() {
        final int[] dims_tmp = new int[this.distribution.rank];
        for (int i = 0; i < this.distribution.rank; ++i) {
            dims_tmp[i] = this.distribution.region.rank(i).high() + 1;
        }
        final Object ret = Array.newInstance(Integer.TYPE, dims_tmp);
        this.pointwise(null, new Operator.Pointwise(){

            public int apply(point p, int arg) {
                int i;
                Object handle = ret;
                for (i = 0; i < dims_tmp.length - 1; ++i) {
                    handle = Array.get(handle, p.get(i));
                }
                Array.setInt(handle, p.get(i), arg);
                return arg;
            }
        });
        return ret;
    }

    public intArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        throw new Error("TODO: <T>ReferenceArray --> <T>ValueArray");
    }

    public static void printArray(String prefix, int[][] a) {
        IntArray.printArray(prefix, a, System.out);
    }

    public static void printArray(String prefix, int[][] a, PrintStream out) {
        out.print(prefix + "{");
        for (int i = 0; i < a.length; ++i) {
            out.print("{");
            for (int j = 0; j < a[i].length; ++j) {
                out.print(a[i][j]);
                if (j >= a[i].length - 1) continue;
                out.print(", ");
            }
            out.print("}");
            if (i >= a.length - 1) continue;
            out.print(", ");
        }
        out.println("}");
    }
}

