/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.MultiDimRegion;
import hj.lang.DimensionIndexOutOfBoundsException;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;

public class RegionRectangular
extends MultiDimRegion {
    public final int low_I;
    public final int low_J;
    public final int low_K;
    public final int low_L;
    public final int low_M;
    public final int lg_I;
    public final int lg_J;
    public final int lg_K;
    public final int lg_L;
    public final int lg_M;
    public final int rank;
    private int[] descriptor;

    public RegionRectangular(region[] r) {
        super(r, false);
        this.rank = r.length;
        this.low_I = this.rank >= 1 ? r[0].rank(0).low() : 0;
        this.lg_I = this.rank >= 1 ? r[0].rank(0).size() : 0;
        this.low_J = this.rank >= 2 ? r[1].rank(0).low() : 0;
        this.lg_J = this.rank >= 2 ? r[1].rank(0).size() : 0;
        this.low_K = this.rank >= 3 ? r[2].rank(0).low() : 0;
        this.lg_K = this.rank >= 3 ? r[2].rank(0).size() : 0;
        this.low_L = this.rank >= 4 ? r[3].rank(0).low() : 0;
        this.lg_L = this.rank >= 4 ? r[3].rank(0).size() : 0;
        this.low_M = this.rank >= 5 ? r[4].rank(0).low() : 0;
        int n = this.lg_M = this.rank >= 5 ? r[4].rank(0).size() : 0;
        if (this.rank > 5) {
            throw new RuntimeException("current rectangular region implementation is restricted from 1d to 5d ");
        }
    }

    public int ordinal(point p) {
        int r = p.rank;
        if (r == 1) {
            return this.ordinal(p.get(0));
        }
        if (r == 2) {
            return this.ordinal(p.get(0), p.get(1));
        }
        if (r == 3) {
            return this.ordinal(p.get(0), p.get(1), p.get(2));
        }
        if (r == 4) {
            return this.ordinal(p.get(0), p.get(1), p.get(2), p.get(3));
        }
        if (r == 5) {
            return this.ordinal(p.get(0), p.get(1), p.get(2), p.get(3), p.get(4));
        }
        throw new RuntimeException("point " + p + " rank is not compatible with a rectangular region");
    }

    private final void checkDimensionBoundCheck(int i, int j, int k, int l, int m) {
        if (this.rank >= 1 ? i < this.low_I || i >= this.lg_I - i : (this.rank >= 2 ? j < this.low_J || j >= this.lg_J - j : (this.rank >= 3 ? k < this.low_K || k >= this.lg_K - k : (this.rank >= 4 ? l < this.low_L || l >= this.lg_L - l : m < this.low_M || m >= this.lg_M - m)))) {
            throw new DimensionIndexOutOfBoundsException();
        }
    }

    public final int ordinal(int i) {
        if (Configuration.ARRAY_VIEW_DIMENSION_BOUND_CHECK) {
            this.checkDimensionBoundCheck(i, 0, 0, 0, 0);
        }
        return i - this.low_I;
    }

    public final int ordinal(int i, int j) {
        if (Configuration.ARRAY_VIEW_DIMENSION_BOUND_CHECK) {
            this.checkDimensionBoundCheck(i, j, 0, 0, 0);
        }
        return j - this.low_J + (i - this.low_I) * this.lg_J;
    }

    public final int ordinal(int i, int j, int k) {
        if (Configuration.ARRAY_VIEW_DIMENSION_BOUND_CHECK) {
            this.checkDimensionBoundCheck(i, j, k, 0, 0);
        }
        return k - this.low_K + (j - this.low_J) * this.lg_K + (i - this.low_I) * this.lg_K * this.lg_J;
    }

    public final int ordinal(int i, int j, int k, int l) {
        if (Configuration.ARRAY_VIEW_DIMENSION_BOUND_CHECK) {
            this.checkDimensionBoundCheck(i, j, k, l, 0);
        }
        return l - this.low_L + (k - this.low_K) * this.lg_L + (j - this.low_J) * (this.lg_L * this.lg_K) + (i - this.low_I) * (this.lg_L * this.lg_K * this.lg_J);
    }

    public final int ordinal(int i, int j, int k, int l, int m) {
        if (Configuration.ARRAY_VIEW_DIMENSION_BOUND_CHECK) {
            this.checkDimensionBoundCheck(i, j, k, l, m);
        }
        return m - this.low_M + (l - this.low_L) * this.lg_M + (k - this.low_K) * (this.lg_M * this.lg_L) + (j - this.low_J) * (this.lg_M * this.lg_L * this.lg_K) + (i - this.low_I) * (this.lg_M * this.lg_L * this.lg_K * this.lg_J);
    }

    public int getDimensionSize(int dimension) {
        if (dimension == 1) {
            return this.lg_I;
        }
        if (dimension == 2) {
            return this.lg_J;
        }
        if (dimension == 3) {
            return this.lg_K;
        }
        if (dimension == 4) {
            return this.lg_L;
        }
        if (dimension == 5) {
            return this.lg_M;
        }
        throw new RuntimeException("current rectangular region implementation is restricted from 1d to 5d ");
    }

    public String toString() {
        int dimension = 1;
        String res = "";
        while (dimension < 6) {
            res = res + "[" + this.getDimensionSize(dimension++) + "]";
        }
        return res;
    }

    public int[] getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new int[this.rank + 1];
            this.descriptor[0] = this.rank;
            for (int i = 1; i <= this.rank; ++i) {
                this.descriptor[i] = this.getDimensionSize(i);
            }
        }
        return this.descriptor;
    }
}

