/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.Helper;
import hj.array.Operator;
import hj.array.lang.ShortReferenceArray;
import hj.array.lang.shortArray;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.common.Configuration;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class ShortArray
extends ShortReferenceArray {
    public ShortArray(dist d, boolean mutable) {
        super(d, mutable);
    }

    protected abstract ShortArray newInstance(dist var1);

    protected abstract ShortArray newInstance(dist var1, short var2);

    protected final ShortArray newInstance(dist d, Operator.Pointwise p) {
        ShortArray res = this.newInstance(d);
        if (p != null) {
            this.scan(res, p);
        }
        return res;
    }

    public abstract short getOrdinal(int var1);

    public abstract short setOrdinal(short var1, int var2);

    public short set(short v, point pos) {
        return this.set(v, pos, true, true);
    }

    public short set(short v, point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public short set(short v, int d0) {
        return this.set(v, d0, true, true);
    }

    public short set(short v, int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public short set(short v, int d0, int d1) {
        return this.set(v, d0, d1, true, true);
    }

    public short set(short v, int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public short set(short v, int d0, int d1, int d2) {
        return this.set(v, d0, d1, d2, true, true);
    }

    public short set(short v, int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public short set(short v, int d0, int d1, int d2, int d3) {
        return this.set(v, d0, d1, d2, d3, true, true);
    }

    public short set(short v, int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.setOrdinal(v, theIndex);
    }

    public short get(point pos) {
        return this.get(pos, true, true);
    }

    public short get(point pos, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(pos));
        }
        int theIndex = Helper.ordinal(this.distribution, pos, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public short get(int d0) {
        return this.get(d0, true, true);
    }

    public short get(int d0, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public short get(int d0, int d1) {
        return this.get(d0, d1, true, true);
    }

    public short get(int d0, int d1, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public short get(int d0, int d1, int d2) {
        return this.get(d0, d1, d2, true, true);
    }

    public short get(int d0, int d1, int d2, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, chkAOB);
        return this.getOrdinal(theIndex);
    }

    public short get(int d0, int d1, int d2, int d3) {
        return this.get(d0, d1, d2, d3, true, true);
    }

    public short get(int d0, int d1, int d2, int d3, boolean chkPl, boolean chkAOB) {
        if (chkPl && Configuration.BAD_PLACE_RUNTIME_CHECK && this.mutable_) {
            Runtime.hereCheckPlace(this.distribution.get(d0, d1, d2, d3));
        }
        int theIndex = Helper.ordinal(this.distribution, d0, d1, d2, d3, chkAOB);
        return this.getOrdinal(theIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEquals(Indexable other) {
        ShortArray o = (ShortArray)other;
        if (!o.distribution.equals(this.distribution)) {
            return false;
        }
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                if (this.get(pos) == o.get(pos)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assign(ShortArray rhs) {
        assert (rhs instanceof ShortArray);
        assert (rhs.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        ShortArray rhs_t = rhs;
        try {
            Iterator it = rhs_t.distribution.region.iterator();
            while (it.hasNext()) {
                point pos = (point)it.next();
                place pl = this.distribution.get(pos);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(rhs_t.get(pos), pos);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(ShortArray res, Operator.Pointwise op, ShortArray arg) {
        assert (res == null || res.distribution.equals(this.distribution));
        assert (arg != null);
        assert (arg.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short arg1 = this.get(p);
                short arg2 = arg.get(p);
                short val = op.apply(p, arg1, arg2);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pointwise(ShortArray res, Operator.Pointwise op) {
        assert (res == null || res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short arg1 = this.get(p);
                short val = op.apply(p, arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduction(Operator.Reduction op) {
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short arg1 = this.get(p);
                op.apply(arg1);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(ShortArray res, Operator.Unary op) {
        assert (res == null || res instanceof ShortArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short arg1 = this.get(p);
                short val = op.apply(arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(ShortArray res, Operator.Pointwise op) {
        assert (res == null || res instanceof ShortArray);
        assert (res.distribution.equals(this.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short val = op.apply(p, (short)0);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortReferenceArray lift(Operator.Binary op, shortArray arg) {
        assert (arg.distribution.equals(this.distribution));
        ShortArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result.set(op.apply(this.get(p), arg.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortReferenceArray lift(Operator.Unary op) {
        ShortArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ((ShortReferenceArray)result).set(op.apply(this.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reduce(Operator.Binary op, short unit) {
        short result = unit;
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result = op.apply(this.get(p), result);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortReferenceArray scan(Operator.Binary op, short unit) {
        short temp = unit;
        ShortArray result = this.newInstance(this.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = this.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                temp = op.apply(this.get(p), temp);
                result.set(temp, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortReferenceArray overlay(shortArray d) {
        dist dist2 = this.distribution.overlay(d.distribution);
        ShortArray ret = this.newInstance(dist2, (short)0);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short val = d.distribution.region.contains(p) ? d.get(p) : this.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(shortArray d) {
        assert (this.region.contains(d.region));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = d.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = this.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                this.set(d.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortReferenceArray union(shortArray d) {
        dist dist2 = this.distribution.union(d.distribution);
        ShortArray ret = this.newInstance(dist2, (short)0);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                short val = this.distribution.region.contains(p) ? this.get(p) : d.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public ShortReferenceArray restriction(dist d) {
        return this.restriction(d.region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortReferenceArray restriction(region r) {
        dist dist2 = this.distribution.restriction(r);
        ShortArray ret = this.newInstance(dist2, (short)0);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ret.set(this.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    public Object toJava() {
        final int[] dims_tmp = new int[this.distribution.rank];
        for (int i = 0; i < this.distribution.rank; ++i) {
            dims_tmp[i] = this.distribution.region.rank(i).high() + 1;
        }
        final Object ret = Array.newInstance(Short.TYPE, dims_tmp);
        this.pointwise(null, new Operator.Pointwise(){

            public short apply(point p, short arg) {
                int i;
                Object handle = ret;
                for (i = 0; i < dims_tmp.length - 1; ++i) {
                    handle = Array.get(handle, p.get(i));
                }
                Array.setShort(handle, p.get(i), arg);
                return arg;
            }
        });
        return ret;
    }

    public shortArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        throw new Error("TODO: <T>ReferenceArray --> <T>ValueArray");
    }

    public static void printArray(String prefix, short[][] a) {
        ShortArray.printArray(prefix, a, System.out);
    }

    public static void printArray(String prefix, short[][] a, PrintStream out) {
        out.print(prefix + "{");
        for (int i = 0; i < a.length; ++i) {
            out.print("{");
            for (int j = 0; j < a[i].length; ++j) {
                out.print(a[i][j]);
                if (j >= a[i].length - 1) continue;
                out.print(", ");
            }
            out.print("}");
            if (i >= a.length - 1) continue;
            out.print(", ");
        }
        out.println("}");
    }
}

