/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ArbitraryRegion;
import hj.array.ContiguousRange;
import hj.array.Range;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;
import java.util.HashSet;
import java.util.Iterator;

public class StridedRange
extends Range {
    public final int stride;

    public StridedRange(int lo, int hi, int stride) {
        super(lo, hi, (hi - lo) / stride + 1);
        assert ((hi - lo) % stride == 0);
        this.stride = stride;
    }

    public point coord(int ord) {
        assert (ord < this.size);
        int val = this.lo + ord * this.stride;
        return point.factory.point(new int[]{val});
    }

    public int ordinal(point p) {
        assert (this.contains(p));
        int val = p.get(0);
        return (val - this.lo) % this.stride;
    }

    public region union(region r) {
        point p;
        if (r.rank != 1) {
            throw new RankMismatchException(r, 1);
        }
        HashSet<point> set = new HashSet<point>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            p = (point)it.next();
            set.add(p);
        }
        it = r.iterator();
        while (it.hasNext()) {
            p = (point)it.next();
            set.add(p);
        }
        return new ArbitraryRegion(1, set);
    }

    public region intersection(region r) {
        if (r.rank != 1) {
            throw new RankMismatchException(r, 1);
        }
        HashSet<point> set = new HashSet<point>();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            point p = (point)it.next();
            if (!this.contains(p)) continue;
            set.add(p);
        }
        return new ArbitraryRegion(1, set);
    }

    public region difference(region r) {
        assert (r != null);
        return super.difference(r);
    }

    public boolean contains(point p) {
        boolean ret;
        boolean bl = ret = p.rank == 1;
        if (ret) {
            int val = p.get(0);
            ret = val >= this.lo && val <= this.hi && (val - this.lo) % this.stride == 0;
        }
        return ret;
    }

    public String toString() {
        return "[" + this.lo + ", " + this.hi + ": " + this.stride + "]";
    }

    public boolean isConvex() {
        return this.stride == 1;
    }

    public region convexHull() {
        if (this.stride == 1) {
            return this;
        }
        return new ContiguousRange(this.lo, this.hi);
    }

    public boolean disjoint(region r) {
        boolean ret = false;
        if (r.rank == 1) {
            Iterator it = r.iterator();
            while (ret && it.hasNext()) {
                point p = (point)it.next();
                if (!this.contains(p)) continue;
                ret = false;
            }
        }
        return ret;
    }

    public boolean contains(region r) {
        boolean ret = false;
        if (r.rank == 1) {
            ret = true;
            Iterator it = r.iterator();
            while (ret && it.hasNext()) {
                if (this.contains((point)it.next())) continue;
                ret = false;
            }
        }
        return ret;
    }

    public Iterator iterator() {
        return new StridedRangeIterator();
    }

    private class StridedRangeIterator
    implements Iterator {
        private int cur_;

        private StridedRangeIterator() {
            this.cur_ = StridedRange.this.lo;
        }

        public boolean hasNext() {
            return this.cur_ < StridedRange.this.hi;
        }

        public void remove() {
            throw new Error("not implemented");
        }

        public Object next() {
            assert (this.hasNext());
            point ret = point.factory.point(new int[]{this.cur_});
            this.cur_ += StridedRange.this.stride;
            return ret;
        }
    }
}

