/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.array.ArbitraryRegion;
import hj.array.ContiguousRange;
import hj.array.EmptyRegion;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;
import java.util.Iterator;

public class TriangularRegion
extends region {
    private final boolean isLower_;
    private final region[] dims_;
    private final int size_;

    public TriangularRegion(region[] dims, boolean is_lower) {
        super(2, false, false);
        assert (dims != null && dims.length == 2);
        int size = dims[0].size();
        assert (size > 0);
        for (int i = 0; i < dims.length; ++i) {
            assert (dims[i] instanceof ContiguousRange);
            assert (dims[i].size() == size);
            if (this.zeroBased()) assert (dims[i].zeroBased());
        }
        this.size_ = this.gauss_(size);
        this.isLower_ = is_lower;
        this.dims_ = dims;
    }

    public int size() {
        return this.size_;
    }

    private int gauss_(int n) {
        int ret = n <= 0 ? 0 : n * (n + 1) / 2;
        return ret;
    }

    private int inv_gauss_(int x) {
        assert (x >= 0);
        int ret = (int)((Math.sqrt((double)(8 * x) + 1.0) - 1.0) / 2.0);
        return ret;
    }

    public region rank(int index) {
        assert (index >= 0);
        assert (index < 2);
        return this.dims_[index];
    }

    public boolean isConvex() {
        return true;
    }

    public int low() {
        throw new UnsupportedOperationException("TriangularRegion::low");
    }

    public int high() {
        throw new UnsupportedOperationException("TriangularRegion::high");
    }

    public region union(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.union(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(2);
        }
        return ret;
    }

    public region intersection(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.intersection(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(2);
        }
        return ret;
    }

    public region difference(region r) {
        assert (r != null);
        region ret = ArbitraryRegion.difference(this, r);
        if (ret.size() == 0) {
            new EmptyRegion(2);
        }
        return ret;
    }

    public region convexHull() {
        return this;
    }

    public boolean contains(point p) {
        assert (p != null);
        boolean ret = p.rank == 2 ? this.contains_(p.get(0), p.get(1)) : false;
        return ret;
    }

    public boolean contains(int[] p) {
        assert (p != null);
        boolean ret = p.length == 2 ? this.contains_(p[0], p[1]) : false;
        return ret;
    }

    private boolean contains_(int a, int b) {
        int a_normal = a - this.dims_[0].low();
        int b_normal = b - this.dims_[1].low();
        boolean ul_criterion = this.isLower_ ? a_normal >= b_normal : a_normal <= b_normal;
        boolean size_criterion = this.dims_[0].contains(new int[]{a}) && this.dims_[1].contains(new int[]{b});
        return ul_criterion && size_criterion;
    }

    public boolean disjoint(region r) {
        assert (r != null);
        return this.intersection(r).size() == 0;
    }

    public int ordinal(point p) throws ArrayIndexOutOfBoundsException {
        assert (p != null);
        if (p.rank != 2) {
            throw new RankMismatchException(p, 2);
        }
        if (this.size() == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (!this.contains(p)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int ret = this.ordinal_(p.get(0), p.get(1));
        return ret;
    }

    private int ordinal_(int a, int b) {
        int b_normal;
        int a_normal;
        if (!this.isLower_) {
            a_normal = this.dims_[0].high() - a;
            b_normal = this.dims_[1].high() - b;
        } else {
            a_normal = a - this.dims_[0].low();
            b_normal = b - this.dims_[1].low();
        }
        return this.gauss_(a_normal) + b_normal;
    }

    public point coord(int ord) throws ArrayIndexOutOfBoundsException {
        assert (ord >= 0);
        if (ord >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int x_normal = this.inv_gauss_(ord);
        int y_normal = ord - this.gauss_(x_normal);
        int[] tmp = this.isLower_ ? new int[]{x_normal + this.dims_[0].low(), y_normal + this.dims_[1].low()} : new int[]{this.dims_[0].high() - x_normal, this.dims_[1].high() - y_normal};
        point ret = point.factory.point(tmp);
        return ret;
    }

    public Iterator iterator() {
        return new TriangularRegionIterator_();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.isLower_ ? "upper" : "lower");
        sb.append("-triangular(");
        sb.append(this.dims_[0].toString());
        sb.append(", ");
        sb.append(this.dims_[1].toString());
        sb.append(")");
        return sb.toString();
    }

    private class TriangularRegionIterator_
    implements Iterator {
        private int nextOrd_ = 0;

        private TriangularRegionIterator_() {
        }

        public boolean hasNext() {
            return this.nextOrd_ < TriangularRegion.this.size_;
        }

        public void remove() {
            throw new UnsupportedOperationException("TriangularRegionIterator_::remove - not implemented");
        }

        public Object next() {
            assert (this.hasNext());
            return TriangularRegion.this.coord(this.nextOrd_++);
        }
    }
}

