/*
 * Decompiled with CFR 0.152.
 */
package hj.array.lang;

import hj.array.BooleanArray;
import hj.array.Operator;
import hj.array.lang.BooleanReferenceArray;
import hj.array.lang.booleanArray;
import hj.array.sharedmemory.BooleanArray_c;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import java.io.PrintStream;
import java.util.Iterator;

public final class ArrayOperations {
    protected ArrayOperations() {
    }

    public static void printArray(String prefix, boolean[][] a) {
        ArrayOperations.printArray(prefix, a, System.out);
    }

    public static void printArray(String prefix, boolean[][] a, PrintStream out) {
        out.print(prefix + "{");
        for (int i = 0; i < a.length; ++i) {
            out.print("{");
            for (int j = 0; j < a[i].length; ++j) {
                out.print(a[i][j]);
                if (j >= a[i].length - 1) continue;
                out.print(", ");
            }
            out.print("}");
            if (i >= a.length - 1) continue;
            out.print(", ");
        }
        out.println("}");
    }

    public static void printArray(String prefix, byte[][] a) {
        ArrayOperations.printArray(prefix, a, System.out);
    }

    public static void printArray(String prefix, byte[][] a, PrintStream out) {
        out.print(prefix + "{");
        for (int i = 0; i < a.length; ++i) {
            out.print("{");
            for (int j = 0; j < a[i].length; ++j) {
                out.print(a[i][j]);
                if (j >= a[i].length - 1) continue;
                out.print(", ");
            }
            out.print("}");
            if (i >= a.length - 1) continue;
            out.print(", ");
        }
        out.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reduction(BooleanReferenceArray a, Operator.Reduction op) {
        place here = Runtime.runtime.currentPlace();
        try {
            dist distribution = a.distribution;
            Iterator it = distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean arg1 = a.get(p);
                op.apply(arg1);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(BooleanReferenceArray res, Operator.Unary op, booleanArray a) {
        BooleanArray r = (BooleanArray)a;
        assert (res.distribution.equals(r.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = r.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = r.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean arg1 = r.get(p);
                res.set(op.apply(arg1), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scan(BooleanArray res, Operator.Pointwise op, booleanArray a) {
        dist distribution = a.distribution;
        assert (res == null || res instanceof BooleanArray);
        assert (res.distribution.equals(distribution));
        place here = Runtime.runtime.currentPlace();
        BooleanArray res_t = res == null ? null : res;
        try {
            Iterator it = distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean val = op.apply(p, false);
                if (res_t == null) continue;
                res_t.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    public static BooleanReferenceArray restriction(booleanArray a, dist D) {
        return ArrayOperations.restriction(a, D.region);
    }

    public static BooleanReferenceArray restriction(booleanArray a, place P) {
        return ArrayOperations.restriction(a, a.distribution.restriction(P));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanReferenceArray restriction(booleanArray a, region R) {
        BooleanArray_c array = (BooleanArray_c)a;
        dist dist2 = array.distribution.restriction(R);
        BooleanArray ret = array.newInstance(dist2);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                ret.set(array.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanReferenceArray union(booleanArray a, booleanArray b) {
        BooleanArray_c r = (BooleanArray_c)a;
        dist dist2 = r.distribution.union(b.distribution);
        BooleanArray ret = r.newInstance(dist2);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean val = r.distribution.region.contains(p) ? r.get(p) : b.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(BooleanReferenceArray a, booleanArray b) {
        assert (a.region.contains(b.region));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = b.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = a.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                a.set(b.get(p), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanReferenceArray overlay(booleanArray a, booleanArray b) {
        BooleanArray_c r = (BooleanArray_c)a;
        dist dist2 = r.distribution.overlay(b.distribution);
        BooleanArray ret = r.newInstance(dist2);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = dist2.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = dist2.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean val = b.distribution.region.contains(p) ? b.get(p) : r.get(p);
                ret.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanReferenceArray lift(booleanArray left, Operator.Binary op, booleanArray right) {
        BooleanArray_c l = (BooleanArray_c)left;
        assert (right.distribution.equals(l.distribution));
        BooleanArray r = (BooleanArray)right;
        BooleanArray result = l.newInstance(l.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = l.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = l.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result.set(op.apply(l.get(p), r.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanReferenceArray lift(Operator.Unary op, booleanArray arg) {
        BooleanArray_c a = (BooleanArray_c)arg;
        BooleanArray result = a.newInstance(a.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = a.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = a.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result.set(op.apply(a.get(p)), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reduce(booleanArray a, Operator.Binary op, boolean unit) {
        boolean result = unit;
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = a.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = a.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                result = op.apply(a.get(p), result);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BooleanReferenceArray scan(booleanArray arg, Operator.Binary op, boolean unit) {
        BooleanArray_c a = (BooleanArray_c)arg;
        boolean temp = unit;
        BooleanArray result = a.newInstance(a.distribution);
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = a.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = a.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                temp = op.apply(a.get(p), temp);
                result.set(temp, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pointwise(booleanArray a, BooleanReferenceArray res, Operator.Pointwise op, booleanArray b) {
        assert (res.distribution.equals(a.distribution));
        assert (b.distribution.equals(a.distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = a.distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = a.distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean arg1 = a.get(p);
                boolean arg2 = b.get(p);
                res.set(op.apply(p, arg1, arg2), p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pointwise(booleanArray a, BooleanReferenceArray res, Operator.Pointwise op) {
        dist distribution = a.distribution;
        assert (res == null || res.distribution.equals(distribution));
        place here = Runtime.runtime.currentPlace();
        try {
            Iterator it = distribution.region.iterator();
            while (it.hasNext()) {
                point p = (point)it.next();
                place pl = distribution.get(p);
                Runtime.runtime.setCurrentPlace(pl);
                boolean arg1 = a.get(p);
                boolean val = op.apply(p, arg1);
                if (res == null) continue;
                res.set(val, p);
            }
        }
        finally {
            Runtime.runtime.setCurrentPlace(here);
        }
    }

    public static boolean[] arrayInit(boolean[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), false);
        }
        return arr;
    }

    public static byte[] arrayInit(byte[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), (byte)0);
        }
        return arr;
    }

    public static char[] arrayInit(char[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), '\u0000');
        }
        return arr;
    }

    public static short[] arrayInit(short[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), (short)0);
        }
        return arr;
    }

    public static int[] arrayInit(int[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), 0);
        }
        return arr;
    }

    public static long[] arrayInit(long[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), 0L);
        }
        return arr;
    }

    public static float[] arrayInit(float[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), 0.0f);
        }
        return arr;
    }

    public static double[] arrayInit(double[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), 0.0);
        }
        return arr;
    }

    public static Object[] arrayInit(Object[] arr, Operator.Pointwise init) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = init.apply(point.factory.point(i), null);
        }
        return arr;
    }
}

