/*
 * Decompiled with CFR 0.152.
 */
package hj.array;

import hj.annotations.NoSideEffects;
import hj.lang.Indexable;
import hj.lang.RankMismatchException;
import hj.lang.point;
import hj.lang.region;

public final class point_c
extends point
implements Comparable {
    final int[] val;
    final int hash_;

    public boolean valueEquals(Indexable other) {
        if (!(other instanceof point_c)) {
            return false;
        }
        point_c op = (point_c)other;
        if (op.hash_ == this.hash_ && op.val.length == this.val.length) {
            for (int i = this.val.length - 1; i >= 0; --i) {
                if (this.val[i] == op.val[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int[] val() {
        return this.val;
    }

    public point_c(int[] val) {
        super(val.length);
        this.val = new int[val.length];
        System.arraycopy(val, 0, this.val, 0, val.length);
        int b = 378551;
        int a = 63689;
        int hash_tmp = 0;
        for (int i = 0; i < val.length; ++i) {
            hash_tmp = hash_tmp * a + val[i];
            a *= b;
        }
        this.hash_ = hash_tmp;
    }

    public int get(int i) {
        if (i < 0 || i >= this.rank) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.val[i];
    }

    public boolean onUpperBoundary(int i, region r) {
        return r.rank(i).high() == this.get(i);
    }

    public boolean onLowerBoundary(int i, region r) {
        return r.rank(i).low() == this.get(i);
    }

    public boolean isValue() {
        return true;
    }

    public boolean equals(Object o) {
        assert (o != null);
        boolean ret = false;
        if (o.getClass() == point_c.class) {
            point_c tmp = (point_c)o;
            if (tmp.rank == this.rank) {
                ret = true;
                for (int i = 0; i < this.val.length; ++i) {
                    if (this.val[i] == tmp.val[i]) continue;
                    ret = false;
                    break;
                }
            }
        }
        return ret;
    }

    public int hashCode() {
        return this.hash_;
    }

    public int compareTo(Object o) {
        assert (o.getClass() == point_c.class);
        point_c tmp = (point_c)o;
        if (tmp.rank != this.rank) {
            throw new RankMismatchException(tmp, this.rank);
        }
        int res = 0;
        for (int i = 0; res == 0 && i < this.rank; ++i) {
            int t1 = this.val[i];
            int t2 = tmp.val[i];
            if (t1 < t2) {
                res = -1;
                continue;
            }
            if (t1 <= t2) continue;
            res = 1;
        }
        return res;
    }

    public boolean gt(point p) {
        return this.compareTo(p) == 1;
    }

    public boolean lt(point p) {
        return this.compareTo(p) == -1;
    }

    public boolean ge(point p) {
        return this.compareTo(p) >= 0;
    }

    public boolean le(point p) {
        return this.compareTo(p) <= 0;
    }

    public point neg() {
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = -this.val[i];
        }
        return factory.point(array);
    }

    public point add(point p) {
        if (this.val.length != p.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] + p.get(i);
        }
        return factory.point(array);
    }

    public point sub(point p) {
        if (this.val.length != p.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] - p.get(i);
        }
        return factory.point(array);
    }

    public point mul(point p) {
        if (this.val.length != p.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] * p.get(i);
        }
        return factory.point(array);
    }

    public point div(point p) {
        if (this.val.length != p.rank) {
            throw new RankMismatchException(p, this.rank);
        }
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] / p.get(i);
        }
        return factory.point(array);
    }

    public point add(int c) {
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] + c;
        }
        return factory.point(array);
    }

    public point mul(int c) {
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] * c;
        }
        return factory.point(array);
    }

    public point div(int c) {
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = this.val[i] / c;
        }
        return factory.point(array);
    }

    public point invsub(int c) {
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = c - this.val[i];
        }
        return factory.point(array);
    }

    public point invdiv(int c) {
        int[] array = new int[this.val.length];
        for (int i = 0; i < this.val.length; ++i) {
            array[i] = c / this.val[i];
        }
        return factory.point(array);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.val.length; ++i) {
            sb.append(this.val[i]);
            if (i >= this.val.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class factory
    extends point.factory {
        @NoSideEffects
        public point point(int[] val) {
            point_c p = new point_c(val);
            return p;
        }
    }
}

