/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.BooleanArray;
import hj.array.Distribution_c;
import hj.array.Operator;
import hj.array.lang.ArrayOperations;
import hj.array.lang.booleanArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class BooleanArray_c
extends BooleanArray
implements UnsafeContainer,
Cloneable {
    private final boolean[] arr_;
    public final int[] descriptor_;

    public BooleanArray_c(dist d, boolean c, boolean mutable) {
        this(d, new booleanArray.Constant(c), mutable);
    }

    public BooleanArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected BooleanArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            ArrayOperations.scan(this, c, (booleanArray)this);
        }
    }

    public BooleanArray_c(dist d, boolean mutable, boolean[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new boolean[count];
    }

    protected BooleanArray_c(dist d, boolean[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public BooleanArray_c(boolean[] base, dist d) {
        super(d, true);
        assert (d instanceof Distribution_c);
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = base;
    }

    public static BooleanArray_c BooleanArray_c(boolean[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new BooleanArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        BooleanArray_c o = (BooleanArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public boolean[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public boolean setOrdinal(boolean v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public boolean getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    public BooleanArray newInstance(dist d) {
        return new BooleanArray_c(d, (Operator.Pointwise)null, true);
    }

    protected BooleanArray newInstance(dist d, boolean c) {
        return new BooleanArray_c(d, c, true);
    }

    protected void assign(BooleanArray rhs) {
        assert (rhs.getClass() == this.getClass());
        BooleanArray_c rhs_t = (BooleanArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

