/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.DoubleArray;
import hj.array.Operator;
import hj.array.lang.doubleArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class DoubleArray_c
extends DoubleArray
implements UnsafeContainer,
Cloneable {
    public final double[] arr_;
    public final int[] descriptor_;

    public DoubleArray_c(dist d, double c, boolean mutable) {
        this(d, new doubleArray.Constant(c), mutable);
    }

    public DoubleArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected DoubleArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((DoubleArray)this, c);
        }
    }

    protected DoubleArray_c(dist d, boolean mutable, double[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new double[count];
    }

    protected DoubleArray_c(dist d, double[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static DoubleArray_c DoubleArray_c(double[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new DoubleArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        DoubleArray_c o = (DoubleArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public double[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public double setOrdinal(double v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public double getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected DoubleArray newInstance(dist d) {
        return new DoubleArray_c(d, (Operator.Pointwise)null, true);
    }

    protected DoubleArray newInstance(dist d, double c) {
        return new DoubleArray_c(d, c, true);
    }

    protected void assign(DoubleArray rhs) {
        assert (rhs.getClass() == this.getClass());
        DoubleArray_c rhs_t = (DoubleArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }

    public doubleArray toValueArray() {
        if (!this.mutable_) {
            return this;
        }
        return new DoubleArray_c(this.distribution, this.arr_, false);
    }
}

