/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.GenericArray;
import hj.array.Operator;
import hj.array.lang.genericArray;
import hj.base.UnsafeContainer;
import hj.compilergenerated.Parameter1;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class GenericArray_c
extends GenericArray
implements UnsafeContainer,
Cloneable {
    public final Parameter1[] arr_;
    public final int[] descriptor_;

    public GenericArray_c(dist d, Parameter1 c, boolean mutable, boolean refs_to_values) {
        this(d, new genericArray.Constant(c), mutable, refs_to_values);
    }

    public GenericArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean refs_to_values) {
        this(d, mutable, refs_to_values, null);
        if (c != null) {
            this.scan((GenericArray)this, c);
        }
    }

    private GenericArray_c(dist d, boolean mutable, boolean refs_to_values, Parameter1[] a) {
        super(d, mutable, refs_to_values);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new Parameter1[count];
    }

    private GenericArray_c(dist d, Parameter1[] a, boolean mutable, boolean refs_to_values) {
        this(d, mutable, refs_to_values, a);
    }

    public static GenericArray_c GenericArray_c(Parameter1[] a, boolean mutable, boolean refs_to_values) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new GenericArray_c(d, a, mutable, refs_to_values);
    }

    public boolean valueEquals(Indexable other) {
        GenericArray_c o = (GenericArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        if (this.refsToValues_) {
            for (int i = this.arr_.length - 1; i >= 0; --i) {
                if (Runtime.equalsequals(this.arr_[i], o.arr_[i])) continue;
                return false;
            }
        } else {
            for (int i = this.arr_.length - 1; i >= 0; --i) {
                if (this.arr_[i] == o.arr_[i]) continue;
                return false;
            }
        }
        return true;
    }

    public Parameter1[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public Parameter1 setOrdinal(Parameter1 v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public Parameter1 getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected GenericArray newInstance(dist d) {
        return new GenericArray_c(d, (Operator.Pointwise)null, true, false);
    }

    protected GenericArray newInstance(dist d, Parameter1 c) {
        return new GenericArray_c(d, c, true, false);
    }

    protected void assign(GenericArray rhs) {
        assert (rhs.getClass() == this.getClass());
        GenericArray_c rhs_t = (GenericArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

