/*
 * Decompiled with CFR 0.152.
 */
package hj.array.sharedmemory;

import hj.array.Distribution_c;
import hj.array.Operator;
import hj.array.ShortArray;
import hj.array.lang.shortArray;
import hj.base.UnsafeContainer;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.dist;
import hj.runtime.common.Configuration;

public class ShortArray_c
extends ShortArray
implements UnsafeContainer,
Cloneable {
    public final short[] arr_;
    public final int[] descriptor_;

    public ShortArray_c(dist d, short c, boolean mutable) {
        this(d, new shortArray.Constant(c), mutable);
    }

    public ShortArray_c(dist d, Operator.Pointwise c, boolean mutable, boolean ignored) {
        this(d, c, mutable);
    }

    protected ShortArray_c(dist d, Operator.Pointwise c, boolean mutable) {
        this(d, mutable, null);
        if (c != null) {
            this.scan((ShortArray)this, c);
        }
    }

    protected ShortArray_c(dist d, boolean mutable, short[] a) {
        super(d, mutable);
        assert (d instanceof Distribution_c);
        int count = d.region.size();
        int rank = d.region.rank;
        this.descriptor_ = new int[rank + 1];
        this.descriptor_[0] = rank;
        for (int i = 1; i <= rank; ++i) {
            this.descriptor_[i] = d.region.rank(i - 1).size();
        }
        this.arr_ = a != null ? a : new short[count];
    }

    private ShortArray_c(dist d, short[] a, boolean mutable) {
        this(d, mutable, a);
    }

    public static ShortArray_c ShortArray_c(short[] a, boolean mutable) {
        dist d = Runtime.factory.getDistributionFactory().local(a.length);
        return new ShortArray_c(d, a, mutable);
    }

    public boolean valueEquals(Indexable other) {
        ShortArray_c o = (ShortArray_c)other;
        if (o.arr_.length != this.arr_.length) {
            return false;
        }
        for (int i = this.arr_.length - 1; i >= 0; --i) {
            if (this.arr_[i] == o.arr_[i]) continue;
            return false;
        }
        return true;
    }

    public short[] getBackingArray() {
        return this.arr_;
    }

    public int[] getDescriptor() {
        return this.descriptor_;
    }

    public short setOrdinal(short v, int rawIndex) {
        this.arr_[rawIndex] = v;
        return this.arr_[rawIndex];
    }

    public short getOrdinal(int rawIndex) {
        return this.arr_[rawIndex];
    }

    protected ShortArray newInstance(dist d) {
        return new ShortArray_c(d, (Operator.Pointwise)null, true);
    }

    protected ShortArray newInstance(dist d, short c) {
        return new ShortArray_c(d, c, true);
    }

    protected void assign(ShortArray rhs) {
        assert (rhs.getClass() == this.getClass());
        ShortArray_c rhs_t = (ShortArray_c)rhs;
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK && rhs.distribution.equals(this.distribution)) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                this.arr_[i] = rhs_t.arr_[i];
            }
        } else {
            super.assign(rhs);
        }
    }

    public void reduction(Operator.Reduction op) {
        if (!Configuration.BAD_PLACE_RUNTIME_CHECK) {
            int count = this.arr_.length;
            for (int i = 0; i < count; ++i) {
                op.apply(this.arr_[i]);
            }
        } else {
            super.reduction(op);
        }
    }
}

