/*
 * Decompiled with CFR 0.152.
 */
package hj.lang;

import hj.annotations.NoSideEffects;
import hj.lang.Indexable;
import hj.lang.Runtime;
import hj.lang.ValueType;
import hj.lang.region;

public abstract class point
implements Indexable,
ValueType {
    public final int rank;
    public static final factory factory = Runtime.factory.getPointFactory();

    protected point(int rank) {
        this.rank = rank;
    }

    public abstract int get(int var1);

    public abstract boolean onUpperBoundary(int var1, region var2);

    public abstract boolean onLowerBoundary(int var1, region var2);

    public abstract boolean gt(point var1);

    public abstract boolean lt(point var1);

    public abstract boolean ge(point var1);

    public abstract boolean le(point var1);

    public abstract point neg();

    public abstract point add(point var1);

    public point sub(point p) {
        return this.add(p.neg());
    }

    public abstract point mul(point var1);

    public abstract point div(point var1);

    private static point toPoint(int rank, int c) {
        int[] a = new int[rank];
        for (int i = 0; i < rank; ++i) {
            a[i] = c;
        }
        return factory.point(a);
    }

    public point add(int c) {
        return this.add(point.toPoint(this.rank, c));
    }

    public point sub(int c) {
        return this.add(-c);
    }

    public point mul(int c) {
        return this.mul(point.toPoint(this.rank, c));
    }

    public point div(int c) {
        return this.div(point.toPoint(this.rank, c));
    }

    public point invadd(int c) {
        return this.add(c);
    }

    public point invsub(int c) {
        return this.add(-c).neg();
    }

    public point invmul(int c) {
        return this.mul(c);
    }

    public point invdiv(int c) {
        return point.toPoint(this.rank, c).div(this);
    }

    public abstract int[] val();

    public static abstract class factory
    implements ValueType {
        @NoSideEffects
        public abstract point point(int[] var1);

        @NoSideEffects
        public point point(int v1) {
            return this.point(new int[]{v1});
        }

        @NoSideEffects
        public point allZero(int d) {
            return this.point(new int[d]);
        }

        @NoSideEffects
        public point point(int v1, int v2) {
            return this.point(new int[]{v1, v2});
        }

        @NoSideEffects
        public point point(int v1, int v2, int v3) {
            return this.point(new int[]{v1, v2, v3});
        }

        @NoSideEffects
        public point point(int v1, int v2, int v3, int v4) {
            return this.point(new int[]{v1, v2, v3, v4});
        }

        @NoSideEffects
        public point point(int v1, int v2, int v3, int v4, int v5) {
            return this.point(new int[]{v1, v2, v3, v4, v5});
        }
    }
}

