/*
 * Decompiled with CFR 0.152.
 */
package hj.newarray;

public final class DoubleRectSafeLocal0Based3DArray {
    public final int iMax;
    public final int jMax;
    public final int kMax;
    protected int size;
    protected double[] m;

    public DoubleRectSafeLocal0Based3DArray(int i, int j, int k) {
        this.iMax = i - 1;
        this.jMax = j - 1;
        this.kMax = k - 1;
        this.size = i * j * k;
        this.m = new double[this.size];
    }

    public DoubleRectSafeLocal0Based3DArray(int i, int j, int k, FunDoubleInt3 f) {
        this.iMax = i - 1;
        this.jMax = j - 1;
        this.kMax = k - 1;
        this.size = i * j * k;
        this.m = new double[this.size];
        for (int u = 0; u < this.size; ++u) {
            this.m[u] = f.eval(this.i(u), this.j(u), this.k(u));
        }
    }

    public DoubleRectSafeLocal0Based3DArray(int i, int j, int k, FunDoubleInt f) {
        this.iMax = i - 1;
        this.jMax = j - 1;
        this.kMax = k - 1;
        this.size = i * j * k;
        this.m = new double[this.size];
        for (int u = 0; u < this.size; ++u) {
            this.m[u] = f.eval(u);
        }
    }

    private int u(int i, int j, int k) {
        return k + this.kMax * (j + i * this.jMax);
    }

    private int i(int u) {
        return u / (this.jMax * this.kMax);
    }

    private int j(int u) {
        return u / this.kMax % this.jMax;
    }

    private int k(int u) {
        return u % this.kMax;
    }

    public double get(int i, int j, int k) {
        return this.m[this.u(i, j, k)];
    }

    public double getOrd(int u) {
        return this.m[u];
    }

    public void set(int i, int j, int k, double v) {
        this.m[this.u((int)i, (int)j, (int)k)] = v;
    }

    public void plusSet(int i, int j, int k, double v) {
        int n = this.u(i, j, k);
        this.m[n] = this.m[n] + v;
    }

    public void timesSet(int i, int j, int k, double v) {
        int n = this.u(i, j, k);
        this.m[n] = this.m[n] * v;
    }

    public void setOrd(int u, double v) {
        this.m[u] = v;
    }

    public void plusSetOrd(int u, double v) {
        int n = u;
        this.m[n] = this.m[n] + v;
    }

    public void timesSetOrd(int u, double v) {
        int n = u;
        this.m[n] = this.m[n] * v;
    }

    public void allUp(FunDoubleInt3Double f) {
        for (int u = 0; u < this.size; ++u) {
            this.m[u] = f.eval(this.i(u), this.j(u), this.k(u), this.m[u]);
        }
    }

    public void allUpOrd(FunDoubleIntDouble f) {
        for (int u = 0; u < this.size; ++u) {
            this.m[u] = f.eval(u, this.m[u]);
        }
    }

    public void allDown(FunDoubleInt3Double f) {
        for (int u = this.size - 1; u >= 0; --u) {
            this.m[u] = f.eval(this.i(u), this.j(u), this.k(u), this.m[u]);
        }
    }

    public void liftUp(DoubleRectSafeLocal0Based3DArray other, FunDoubleDouble2 f) {
        assert (other.iMax == this.iMax && other.jMax == this.jMax && other.iMax == this.iMax);
        for (int u = 0; u < this.size; ++u) {
            this.m[u] = f.eval(this.m[u], other.getOrd(u));
        }
    }

    public void liftDown(DoubleRectSafeLocal0Based3DArray other, FunDoubleDouble2 f) {
        assert (other.iMax == this.iMax && other.jMax == this.jMax && other.iMax == this.iMax);
        for (int u = this.size - 1; u >= 0; --u) {
            this.m[u] = f.eval(this.m[u], other.getOrd(u));
        }
    }

    public void reduce(FunDoubleDouble2 f, double unit) {
        double result = unit;
        for (int u = 0; u < this.size; ++u) {
            result = f.eval(this.m[u], result);
        }
    }

    public DoubleRectSafeLocal0Based3DArray scan(FunDoubleDouble2 f, double unit) {
        double temp = unit;
        DoubleRectSafeLocal0Based3DArray result = new DoubleRectSafeLocal0Based3DArray(this.iMax, this.jMax, this.kMax);
        for (int u = 0; u < this.size; ++u) {
            temp = f.eval(this.m[u], temp);
            result.setOrd(u, temp);
        }
        return result;
    }

    public static interface FunDoubleDouble2 {
        public double eval(double var1, double var3);
    }

    public static interface FunDoubleIntDouble {
        public double eval(int var1, double var2);
    }

    public static interface FunDoubleInt3Double {
        public double eval(int var1, int var2, int var3, double var4);
    }

    public static interface FunDoubleInt {
        public double eval(int var1);
    }

    public static interface FunDoubleInt3 {
        public double eval(int var1, int var2, int var3);
    }
}

