/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.common;

import hj.runtime.common.ConfigurationError;
import hj.runtime.common.OptionError;
import hj.runtime.common.Version;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.util.ShowUsageNotification;
import hj.runtime.wst.WstConfiguration;
import hj.runtime.wst.adaptive.Runtime;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class Configuration {
    public static final String OPT_WST_RUNTIME = "wst";
    public static final String OPT_WSH_RUNTIME = "wsh";
    public static String MAIN_CLASS_NAME = null;
    private static final String MAIN_CLASS_NAME_desc = "The name of the main class";
    public static boolean BAD_PLACE_RUNTIME_CHECK = false;
    private static final String BAD_PLACE_RUNTIME_CHECK_desc = "Perform runtime place checks";
    public static String RT = null;
    private static final String RT_desc = "The runtime implementation to use 'wsh' or 'wst'";
    public static boolean ARRAY_VIEW_DIMENSION_BOUND_CHECK = false;
    private static final String ARRAY_VIEW_DIMENSION_BOUND_CHECK_desc = "Activate Array view dimension bound checks";

    protected static void set(Class cls, String key, String val) throws ConfigurationError, OptionError {
        block25: {
            int idx = 0;
            String fld = null;
            try {
                if (key.indexOf(91) > 0) {
                    idx = Integer.parseInt(key.substring(key.indexOf(91) + 1, key.indexOf(93)));
                    fld = key.substring(key.indexOf(46) + 1);
                    key = key.substring(0, key.indexOf(91));
                }
                String upperCaseKey = key.toUpperCase();
                Field f = cls.getField(upperCaseKey);
                Class<?> t = f.getType();
                Object o = null;
                if (fld != null) {
                    if (t.isArray()) {
                        if (!t.getComponentType().isPrimitive()) {
                            o = Array.get(f.get(null), idx);
                            if (o == null) {
                                o = t.getComponentType().newInstance();
                                Array.set(f.get(null), idx, o);
                            }
                            f = o.getClass().getField(fld);
                            t = f.getType();
                        }
                    } else {
                        throw new OptionError(key + " is not an array");
                    }
                }
                if (val == null) {
                    if (t == Boolean.TYPE) {
                        val = "true";
                    } else {
                        throw new OptionError("Parameter " + key + " expects a value");
                    }
                }
                if (t == String.class) {
                    f.set(o, val);
                    break block25;
                }
                if (t == Integer.TYPE) {
                    f.setInt(o, new Integer(val));
                    break block25;
                }
                if (t == Float.TYPE) {
                    f.setFloat(o, new Float(val).floatValue());
                    break block25;
                }
                if (t == Double.TYPE) {
                    f.setDouble(o, new Double(val));
                    break block25;
                }
                if (t == Long.TYPE) {
                    f.setLong(o, new Long(val));
                    break block25;
                }
                if (t == Short.TYPE) {
                    f.setShort(o, new Short(val));
                    break block25;
                }
                if (t == Byte.TYPE) {
                    f.setByte(o, new Byte(val));
                    break block25;
                }
                if (t == Character.TYPE) {
                    if (val.length() != 1) {
                        throw new OptionError("Parameter " + key + " expects exactly one character; got '" + val + "'");
                    }
                    f.setChar(o, new Character(val.charAt(48)).charValue());
                    break block25;
                }
                if (t != Boolean.TYPE) break block25;
                if (val.equalsIgnoreCase("true")) {
                    f.setBoolean(null, true);
                    break block25;
                }
                if (val.equalsIgnoreCase("false")) {
                    f.setBoolean(null, false);
                    break block25;
                }
                throw new OptionError("Parameter " + key + " expects a boolean, not '" + val + "'");
            }
            catch (NoSuchFieldException nsfe) {
                throw new OptionError("Parameter " + key + " not found");
            }
            catch (InstantiationException ie) {
                System.err.println("Failed to create object for " + key);
                throw new ConfigurationError(ie);
            }
            catch (IllegalAccessException iae) {
                System.err.println("Wrong permissions for field " + key + ": " + iae);
                throw new ConfigurationError(iae);
            }
            catch (NumberFormatException z) {
                throw new OptionError("Parameter " + key + " expects a number, not '" + val + "'");
            }
        }
    }

    public static String getConfigurationResource() {
        return System.getProperty("hj.configuration");
    }

    public static void readConfiguration(Class cls, String cfg) throws ConfigurationError {
        if (cfg == null) {
            return;
        }
        try {
            Properties props = new Properties();
            InputStream is = cls.getClassLoader().getResourceAsStream(cfg);
            if (is == null) {
                throw new ConfigurationError("Configuration " + cfg + " not found");
            }
            byte[] data = new byte[is.available()];
            if (data.length != is.read(data)) {
                throw new ConfigurationError("Cannot read entire file");
            }
            String s = new String(data).replace('\\', '/');
            props.load(new ByteArrayInputStream(s.getBytes()));
            for (String string : props.keySet()) {
                String val = props.getProperty(string);
                try {
                    Configuration.set(cls, string, val);
                }
                catch (OptionError e) {
                    System.err.println(e.getMessage() + ", ignoring.");
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationError(e);
        }
    }

    protected static void parseArgument(Class cls, String arg) throws OptionError, ConfigurationError {
        String optionName;
        if (arg.length() < 1 || arg.charAt(0) != '-') {
            throw new OptionError("Invalid argument: '" + arg + "'");
        }
        int eq = arg.indexOf(61);
        String optionValue = null;
        if (eq == -1) {
            optionName = arg.substring(1);
        } else {
            optionName = arg.substring(1, eq);
            optionValue = arg.substring(eq + 1);
        }
        Configuration.set(cls, optionName, optionValue);
    }

    public static String[] parseCommandLine(String[] args) throws ConfigurationError {
        if (args == null) {
            return new String[0];
        }
        LinkedList<String> unhandledArgs = new LinkedList<String>();
        int pos = 0;
        while (pos < args.length && args[pos].length() > 0 && args[pos].charAt(0) == '-') {
            if (args[pos].equals("-h") || args[pos].equals("-help") || args[pos].equals("--help")) {
                throw new ShowUsageNotification();
            }
            if (args[pos].equals("-v") || args[pos].equals("-version") || args[pos].equals("--version")) {
                Version.printVersion();
                System.exit(0);
            }
            if (args[pos].equals("-report")) {
                StringTokenizer st = new StringTokenizer(args[++pos], "=");
                String topic = "";
                int level = 0;
                if (st.hasMoreTokens()) {
                    topic = st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    try {
                        level = Integer.parseInt(st.nextToken());
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                Report.addTopic(topic, level);
                ++pos;
                continue;
            }
            try {
                Configuration.parseArgument(Configuration.class, args[pos]);
            }
            catch (OptionError e) {
                unhandledArgs.add(args[pos]);
            }
            ++pos;
        }
        MAIN_CLASS_NAME = args[pos++];
        Configuration.checkMainClassName();
        Configuration.checkRuntimeOption();
        String[] unhandledArrayArgs = new String[unhandledArgs.size()];
        unhandledArgs.toArray(unhandledArrayArgs);
        try {
            Configuration.parseRuntimeSpecificOptions(unhandledArrayArgs);
        }
        catch (OptionError e) {
            throw new ConfigurationError(e.getMessage());
        }
        int aa = args.length - pos;
        String[] appArgs = new String[aa];
        System.arraycopy(args, pos, appArgs, 0, aa);
        if (Report.should_report("activity", 3)) {
            Report.report(3, Thread.currentThread() + " user class is |" + MAIN_CLASS_NAME + "|.");
        }
        return appArgs;
    }

    public static final Class getRuntimeClass() {
        if (Configuration.isWorkSharingRuntime()) {
            return WshRuntime_c.class;
        }
        if (Configuration.isWorkStealingRuntime()) {
            return Runtime.class;
        }
        return null;
    }

    public static final void parseRuntimeSpecificOptions(String[] args) throws ConfigurationError, OptionError {
        Class runtimeSpecificConfiguration = null;
        if (Configuration.isWorkSharingRuntime()) {
            runtimeSpecificConfiguration = WshConfiguration.class;
        }
        if (Configuration.isWorkStealingRuntime()) {
            runtimeSpecificConfiguration = WstConfiguration.class;
        }
        if (args != null) {
            for (int pos = 0; pos < args.length && args[pos].length() > 0 && args[pos].charAt(0) == '-'; ++pos) {
                Configuration.parseArgument(runtimeSpecificConfiguration, args[pos]);
            }
        }
    }

    public static final String getRuntimeName() {
        return RT;
    }

    public static final boolean isWorkStealingRuntime() {
        return Configuration.getRuntimeName().equals(OPT_WST_RUNTIME);
    }

    public static final boolean isWorkSharingRuntime() {
        return Configuration.getRuntimeName().equals(OPT_WSH_RUNTIME);
    }

    private static final void checkMainClassName() {
        if ((MAIN_CLASS_NAME = MAIN_CLASS_NAME.substring(MAIN_CLASS_NAME.lastIndexOf("\\") + 1)).endsWith(".java")) {
            MAIN_CLASS_NAME = MAIN_CLASS_NAME.substring(0, MAIN_CLASS_NAME.length() - 5);
        } else if (MAIN_CLASS_NAME.endsWith(".hj")) {
            MAIN_CLASS_NAME = MAIN_CLASS_NAME.substring(0, MAIN_CLASS_NAME.length() - 3);
        }
    }

    private static final void checkRuntimeOption() throws ConfigurationError {
        if (Configuration.getRuntimeName() == null) {
            throw new ConfigurationError("rt option is mandatory (wsh | wst)");
        }
        if (!Configuration.isWorkSharingRuntime() && !Configuration.isWorkStealingRuntime()) {
            throw new ConfigurationError("Invalid rt option value " + Configuration.getRuntimeName());
        }
    }

    private static String typeToString(Class t) {
        if (t.isPrimitive()) {
            return t.toString();
        }
        if (t.isArray()) {
            return Configuration.typeToString(t.getComponentType()) + "[]";
        }
        if (t.getPackage() == Package.getPackage("java.lang")) {
            return t.getName().substring("java.lang.".length());
        }
        return t.getName();
    }

    protected static String[][] options(Class cls) {
        Field[] flds = cls.getFields();
        int num = 0;
        for (int i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            int m = f.getModifiers();
            if (!Modifier.isStatic(m) || Modifier.isFinal(m)) continue;
            ++num;
        }
        String[][] opts = new String[num][];
        int j = 0;
        for (int i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            int m = f.getModifiers();
            if (!Modifier.isStatic(m) || Modifier.isFinal(m)) continue;
            Class<?> t = f.getType();
            String type = Configuration.typeToString(t);
            String desc = "";
            Object v = null;
            try {
                Field d = cls.getDeclaredField(f.getName() + "_desc");
                int dm = d.getModifiers();
                if (!(Modifier.isPrivate(dm) && Modifier.isStatic(dm) && Modifier.isFinal(dm))) {
                    throw new NoSuchFieldException();
                }
                boolean s = d.isAccessible();
                d.setAccessible(true);
                desc = (String)d.get(null) + " ";
                d.setAccessible(s);
            }
            catch (NoSuchFieldException nsfe) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
            try {
                v = f.get(null);
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
            if (!t.isPrimitive() && v != null) {
                v = "\"" + v + "\"";
            }
            opts[j++] = new String[]{f.getName(), type, desc, "" + v};
        }
        return opts;
    }

    public static String[][] options() {
        return Configuration.options(Configuration.class);
    }

    static {
        String cfg = Configuration.getConfigurationResource();
        try {
            Configuration.readConfiguration(Configuration.class, cfg);
        }
        catch (ConfigurationError err) {
            System.err.println("Failed to read configuration file " + cfg + ": " + err);
            System.err.println("Using defaults");
        }
    }
}

