/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.MultipleExceptions;
import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.activity;
import hj.runtime.wsh.AccumCell;
import hj.runtime.wsh.Accumulator;
import hj.runtime.wsh.FinishState;
import hj.runtime.wsh.Future_c;
import hj.runtime.wsh.HjRunnable;
import hj.runtime.wsh.InvocationStrategy;
import hj.runtime.wsh.PhaserImpl;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.SyncVar1;
import hj.runtime.wsh.SyncVar2;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshConfiguration;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.abstractmetrics.AbstractMetricsFactory;
import hj.runtime.wsh.phaser.PhaserManager;
import hj.runtime.wsh.phaser.PhaserManagerFactory;
import hj.runtime.wsh.phaser.PhaserRegMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activity
extends activity
implements HjRunnable,
AbstractMetrics {
    protected Place place_;
    protected FinishState finishState_ = null;
    protected Stack<FinishState> finishStack_ = null;
    public PhaserManager activityPhaserManager;
    protected FinishState rootNode_;
    protected Future_c future;
    private AbstractMetrics abstractMetricsManager;
    private boolean notFinished = true;
    boolean success = true;
    private InvocationStrategy invocationStrategy = InvocationStrategy.ASYNC;
    private final String name;
    private final HashMap syncVarMap1 = new HashMap();
    private final HashMap syncVarMap2 = new HashMap();
    private SyncVar1 sv1 = null;
    private SyncVar2 sv2 = null;
    private PhaserImpl singlePh = null;
    private int cnt = 0;
    private final HashMap AccumCellMap = new HashMap();
    public int tmpForDelay;
    public int round;
    public Random rand = new Random();
    protected Activity parentActivity;
    protected int parentAct_Clock;
    protected int act_Clock;
    protected int spawnLevel;

    public Activity() {
        this(new Throwable().getStackTrace()[2].toString());
    }

    public Activity(String name) {
        this.name = name;
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.initializeActivity();
    }

    public Activity(List phaserRegModes, String name) {
        this.name = name;
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.activityPhaserManager = PhaserManagerFactory.getPhaserManager(this, phaserRegModes);
        this.initializeActivity();
    }

    public Activity(List phaserRegModes) {
        this(phaserRegModes, new Throwable().getStackTrace()[2].toString());
    }

    public Activity(PhaserRegMode phaserRegMode, String name) {
        this.name = name;
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();
        }
        this.activityPhaserManager = PhaserManagerFactory.getPhaserManager(this, phaserRegMode);
        this.initializeActivity();
    }

    public Activity(PhaserRegMode phaserRegMode) {
        this(phaserRegMode, new Throwable().getStackTrace()[2].toString());
    }

    private void initializeActivity() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " Activity: initializing " + this);
        }
        this.registerPhasers();
        if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
            this.setResumeTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PoolRunner activityRunner = (PoolRunner)Thread.currentThread();
        if (Report.should_report("activity", 5)) {
            Report.report(5, activityRunner + " is running " + this);
        }
        activityRunner.setActivity(this);
        activityRunner.setPlace(this.getPlace());
        try {
            this.invocationStrategy.invokeHjTask(this);
        }
        catch (Throwable t) {
            this.success = false;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
        }
        finally {
            this.setFinished();
        }
    }

    @Override
    public abstract void runHjTask();

    @Override
    public abstract boolean isHjTaskReady();

    public synchronized void join() throws InterruptedException {
        while (this.notFinished) {
            this.wait();
        }
    }

    private synchronized void setFinished() {
        this.notFinished = false;
        this.notifyAll();
    }

    public void setRootActivityFinishState(FinishState root) {
        this.rootNode_ = root;
    }

    public void setPlace(Place p) {
        this.place_ = p;
    }

    public Place getPlace() {
        return this.place_;
    }

    public void setAsyncReturn(Object asyncResult) {
        this.future.setResult(asyncResult);
    }

    public void startFinish() {
        if (this.finishState_ != null) {
            this.getFinishStack().push(this.finishState_);
        }
        this.finishState_ = new FinishState(this);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " starts finish " + this.finishState_);
        }
    }

    public void stopFinish() {
        for (PhaserImpl c : this.finishState_.getPhaserList()) {
            c.drop(this);
        }
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " " + this + " enters stopfinish ");
        }
        this.finishState_.waitForFinish();
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " " + this + " continues stopfinish ");
        }
        FinishState state = this.finishState_;
        if (this.finishStack_ == null) {
            this.finishState_ = null;
        } else if (!this.finishStack_.isEmpty()) {
            this.finishState_ = this.finishStack_.pop();
        }
        Stack result = state.exceptions();
        if (result != null && !result.empty()) {
            if (result.size() == 1) {
                Throwable t = (Throwable)result.pop();
                if (Report.should_report("activity", 3)) {
                    Report.report(3, PoolRunner.logString() + " " + this + " throws  " + t);
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
            }
            throw new MultipleExceptions(result);
        }
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " exits from finish.");
        }
    }

    private Stack<FinishState> getFinishStack() {
        if (this.finishStack_ == null) {
            this.finishStack_ = new Stack();
        }
        return this.finishStack_;
    }

    private boolean inFinish() {
        return this.finishState_ != null;
    }

    public void pushException(Throwable t) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " pushing exception " + t + " onto " + this.finishState_);
        }
        this.finishState_.pushException(t);
    }

    public void addPhaser(PhaserRegMode pr) {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.addPhaser(pr);
        } else {
            this.activityPhaserManager = PhaserManagerFactory.getPhaserManager(this, pr);
        }
    }

    public void dropPhaser(PhaserImpl ph) {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.dropPhaser(ph);
            if (this.activityPhaserManager.getNbRegisteredPhasers() == 0) {
                this.activityPhaserManager = null;
            }
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " dropPhaser attempt failed because no phasers are registered in this activity " + ph + ".");
        }
    }

    protected void dropAllPhasers() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.dropAllPhasers();
            this.activityPhaserManager = null;
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " dropAllPhasers attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doNext() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doNext();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " doNext attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doSignal() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doSignal();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " signal attempt failed because no phasers are registered in this activity ");
        }
    }

    public void doWait() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doWait();
        } else if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " doWait attempt failed because no phasers are registered in this activity ");
        }
    }

    public int doNext1(String loc) {
        int ret = 0;
        if (this.activityPhaserManager != null) {
            ret = this.activityPhaserManager.doNext1(loc);
        } else {
            if (Report.should_report("Phaser", 3)) {
                Report.report(3, PoolRunner.logString() + " doNext1 attempt failed because no phasers are registered in this activity ");
            }
            assert (false);
        }
        return ret;
    }

    public void doNext2() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.doNext2();
        } else {
            if (Report.should_report("Phaser", 3)) {
                Report.report(3, PoolRunner.logString() + " doNext2 attempt failed because no phasers are registered in this activity ");
            }
            assert (false);
        }
    }

    public void putSyncVar1(PhaserImpl ph, SyncVar1 s1) {
        if (this.cnt > 1) {
            this.syncVarMap1.put(ph, s1);
        } else if (this.cnt == 1) {
            if (ph == this.singlePh) {
                this.sv1 = s1;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.singlePh, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.singlePh, this.sv2);
                }
                this.syncVarMap1.put(ph, s1);
                this.cnt = 2;
            }
        } else {
            this.singlePh = ph;
            this.sv1 = s1;
            this.cnt = 1;
        }
    }

    public void putSyncVar2(PhaserImpl ph, SyncVar2 s2) {
        if (this.cnt > 1) {
            this.syncVarMap2.put(ph, s2);
        } else if (this.cnt == 1) {
            if (ph == this.singlePh) {
                this.sv2 = s2;
            } else {
                if (this.sv1 != null) {
                    this.syncVarMap1.put(this.singlePh, this.sv1);
                }
                if (this.sv2 != null) {
                    this.syncVarMap2.put(this.singlePh, this.sv2);
                }
                this.syncVarMap2.put(ph, s2);
                this.cnt = 2;
            }
        } else {
            this.singlePh = ph;
            this.sv2 = s2;
            this.cnt = 1;
        }
    }

    public SyncVar1 getSyncVar1(PhaserImpl ph) {
        if (this.cnt == 1 && ph == this.singlePh) {
            return this.sv1;
        }
        if (this.cnt > 1) {
            return (SyncVar1)this.syncVarMap1.get(ph);
        }
        return null;
    }

    public SyncVar2 getSyncVar2(PhaserImpl ph) {
        if (this.cnt == 1 && ph == this.singlePh) {
            return this.sv2;
        }
        if (this.cnt > 1) {
            return (SyncVar2)this.syncVarMap2.get(ph);
        }
        return null;
    }

    public PhaserRegMode checkPhaserUse(PhaserRegMode prm) {
        PhaserImpl ph = (PhaserImpl)prm.getPhaser();
        if (ph.dropped()) {
            throw new PhaserException("Cannot transmit dropped phaser.");
        }
        if (ph.quiescent()) {
            throw new PhaserException("Cannot transmit sent (resumed) phaser.");
        }
        if (this.inFinish() && !this.finishState_.getPhaserList().contains(ph)) {
            throw new PhaserException("IEF scope rule violation: The innermost finish doesn't include this phaser.");
        }
        return prm;
    }

    public void checkPhaserUse(List<PhaserRegMode> phaserModeList) {
        Iterator<PhaserRegMode> it = phaserModeList.iterator();
        while (it.hasNext()) {
            this.checkPhaserUse(it.next());
        }
    }

    public List<PhaserRegMode> getPhaserRegModeList() {
        if (this.activityPhaserManager != null) {
            return this.activityPhaserManager.getPhaserRegModeList();
        }
        return Collections.EMPTY_LIST;
    }

    public int getNbRegisteredPhasers() {
        if (this.activityPhaserManager == null) {
            return 0;
        }
        return this.activityPhaserManager.getNbRegisteredPhasers();
    }

    public void registerPhasers() {
        if (this.activityPhaserManager != null) {
            this.activityPhaserManager.registerPhasers();
        }
    }

    public void putAccumCell(Accumulator acc, Object elem) {
        this.AccumCellMap.put(acc, elem);
    }

    public AccumCell getAccumCell(Accumulator acc) {
        return (AccumCell)this.AccumCellMap.get(acc);
    }

    @Override
    public long getTotalOps() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalOps();
        }
        return 0L;
    }

    @Override
    public long getCritPathOps() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathOps();
        }
        return 0L;
    }

    @Override
    public void addLocalOps(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addLocalOps(n);
        }
    }

    @Override
    public void addCritPathOps(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addCritPathOps(n);
        }
    }

    @Override
    public void maxCritPathOps(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathOps(n);
        }
    }

    @Override
    public long getTotalUnblockedTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getTotalUnblockedTime();
        }
        return 0L;
    }

    @Override
    public long getCritPathTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCritPathTime();
        }
        return 0L;
    }

    @Override
    public void maxCritPathTime(long t) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxCritPathTime(t);
        }
    }

    @Override
    public long getResumeTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getResumeTime();
        }
        return 0L;
    }

    @Override
    public void setResumeTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.setResumeTime();
        }
    }

    @Override
    public void updateIdealTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.updateIdealTime();
        }
    }

    @Override
    public long getCurrentTime() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getCurrentTime();
        }
        return 0L;
    }

    @Override
    public void addUnblockedTime(long t) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.addUnblockedTime(t);
        }
    }

    @Override
    public void maxOverheads(long n) {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.abstractMetricsManager.maxOverheads(n);
        }
    }

    @Override
    public long getOverheads() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            return this.abstractMetricsManager.getOverheads();
        }
        return 0L;
    }

    public Activity finalizeActivitySpawn(Activity child) {
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this + " spawns " + child);
        }
        FinishState target = this.finishState_ == null ? this.rootNode_ : this.finishState_;
        child.setRootActivityFinishState(target);
        target.notifySubActivitySpawn();
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            child.maxCritPathOps(this.getCritPathOps());
            child.maxOverheads(this.getOverheads() + WshConfiguration.ABSTRACT_EXECUTION_OVERHEAD);
        }
        return child;
    }

    public void finalizeTermination() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " " + this + "terminates.");
        }
        this.finalizeTerminationCleanup();
        if (this.rootNode_ != null) {
            if (this.future != null && this.future.getException() != null) {
                this.rootNode_.registerFailedFuture(this.future);
            }
            this.rootNode_.notifySubActivityTermination();
        }
    }

    public void finalizeTermination(Throwable t) {
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " terminates abruptly with " + t);
        }
        if (this.future != null) {
            this.future.setException(t);
            this.finalizeTermination();
        } else {
            this.finalizeTerminationCleanup();
            if (this.rootNode_ != null) {
                this.rootNode_.notifySubActivityTermination(t);
            }
        }
    }

    public void finalizeTerminationCleanup() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            ((Place)Runtime.here()).maxCritPathOps(this.getCritPathOps());
            ((Place)Runtime.here()).addLocalOps(this.getTotalOps());
            ((Place)Runtime.here()).maxOverheads(this.getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.updateIdealTime();
                ((Place)Runtime.here()).addUnblockedTime(this.getTotalUnblockedTime());
                ((Place)Runtime.here()).maxCritPathTime(this.getCritPathTime());
            }
        }
        this.dropAllPhasers();
        if (Report.should_report("activity", 5)) {
            Report.report(5, Thread.currentThread() + " " + this + " drops phasers, has rootNode_ " + this.rootNode_);
        }
    }

    public String myName() {
        return this.name != null ? this.name : "Activity " + Long.toHexString(System.identityHashCode(this));
    }

    public String toString() {
        String rv = "<" + this.myName();
        rv = rv + " " + this.finishState_ + "," + this.rootNode_;
        rv = rv + ">";
        return rv;
    }

    public String shortString() {
        return "<" + this.myName() + ">";
    }

    public void setInvocationStrategy(InvocationStrategy async_in_finish) {
        this.invocationStrategy = async_in_finish;
    }

    public void registerPhaserToIEF(PhaserImpl phaserImpl) {
        if (this.finishState_ != null) {
            this.finishState_.getPhaserList().add(phaserImpl);
        }
    }

    public Activity getParentActivity() {
        return this.parentActivity;
    }

    public void setActivityInfo(Activity parentActivity, int parentAct_Clock, int spawnLevel) {
        this.parentActivity = parentActivity;
        this.parentAct_Clock = parentAct_Clock;
        this.spawnLevel = spawnLevel;
    }

    protected void incAct_Clock() {
        ++this.act_Clock;
    }

    public int getAct_Clock() {
        return this.act_Clock;
    }

    public int getSpawnLevel() {
        return this.spawnLevel;
    }

    public int getParentAct_Clock() {
        return this.parentAct_Clock;
    }

    public void prepareSpawn(Activity childActivity) {
        childActivity.setActivityInfo(this, this.getAct_Clock(), this.getSpawnLevel() + 1);
        this.incAct_Clock();
    }

    public FinishState getFinishState() {
        return this.finishState_;
    }

    public boolean hasFinishState(FinishState fs) {
        if (this.finishState_ == fs && fs != null) {
            return true;
        }
        if (this.finishStack_ != null) {
            for (int i = this.finishStack_.size() - 1; i >= 0; --i) {
                if (this.finishStack_.get(i) != fs) continue;
                return true;
            }
        }
        return false;
    }
}

