/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import java.util.concurrent.atomic.AtomicReference;

class AtomicDouble {
    private final AtomicReference atom;
    private final int func;
    private final double delay;
    private final double coef;

    public AtomicDouble() {
        this.atom = new AtomicReference<Double>(new Double(0.0));
        this.delay = 0.0;
        this.func = 0;
        this.coef = 0.0;
    }

    public AtomicDouble(double val) {
        this.atom = new AtomicReference<Double>(new Double(val));
        this.delay = 0.0;
        this.func = 0;
        this.coef = 0.0;
    }

    public AtomicDouble(double val, int f, double dl, double coe) {
        this.atom = new AtomicReference<Double>(new Double(val));
        this.func = f;
        this.delay = dl;
        this.coef = coe;
    }

    public double get() {
        return (Double)this.atom.get();
    }

    public void set(double val) {
        this.atom.set(new Double(val));
    }

    private int localSpin(double round, double exp, Activity a) {
        int n = 0;
        int length = (int)this.delay;
        switch (this.func) {
            case 1: {
                length = (int)(this.delay * (1.0 + this.coef * a.rand.nextDouble()));
                break;
            }
            case 2: {
                length = (int)(this.delay * (1.0 + this.coef * (round - 1.0)));
                break;
            }
            case 3: {
                length = (int)(this.delay * (1.0 + this.coef * round * a.rand.nextDouble()));
                break;
            }
            case 4: {
                length = (int)Math.min(exp * this.coef, this.delay);
                break;
            }
            case 5: {
                length = (int)(Math.min(exp * this.coef, this.delay) * a.rand.nextDouble());
            }
        }
        for (int i = 0; i < length; ++i) {
            n += i;
        }
        return n;
    }

    public double addAndGet(double val) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            double newVal;
            Double neo;
            Double cur;
            if (this.atom.compareAndSet(cur = (Double)this.atom.get(), neo = new Double(newVal = cur + val))) {
                a.round = (int)round;
                return newVal;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
    }

    public double mulAndGet(double val) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        double round = 1.0;
        double exp = 2.0;
        while (true) {
            double newVal;
            Double neo;
            Double cur;
            if (this.atom.compareAndSet(cur = (Double)this.atom.get(), neo = new Double(newVal = cur * val))) {
                a.round = (int)round;
                return newVal;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
    }

    public double minAndGet(double val) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        double round = 1.0;
        double exp = 2.0;
        Double cur;
        double v;
        while (!(val >= (v = (cur = (Double)this.atom.get()).doubleValue()))) {
            Double neo = new Double(val);
            if (this.atom.compareAndSet(cur, neo)) {
                a.round = (int)round;
                return val;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
        return v;
    }

    public double maxAndGet(double val) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        double round = 1.0;
        double exp = 2.0;
        Double cur;
        double v;
        while (!(val <= (v = (cur = (Double)this.atom.get()).doubleValue()))) {
            Double neo = new Double(val);
            if (this.atom.compareAndSet(cur, neo)) {
                a.round = (int)round;
                return val;
            }
            a.tmpForDelay = this.localSpin(round, exp, a);
            round += 1.0;
            exp *= 2.0;
        }
        return v;
    }
}

