/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.runtime.wsh.Activity;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class ModCountDownLatch {
    private final Sync sync;
    private long critPathOps = 0L;
    private long overheads = 0L;
    private long curIdealTime = 0L;

    public ModCountDownLatch(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(count);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void countDown() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.maxCritPathOps(((Activity)WshRuntime_c.getCurrentActivity()).getCritPathOps());
            this.maxOverheads(((Activity)WshRuntime_c.getCurrentActivity()).getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                this.maxIdealTime(((Activity)WshRuntime_c.getCurrentActivity()).getCritPathTime());
            }
        }
        this.sync.releaseShared(1);
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxOverheads(long n) {
        this.overheads = Math.max(this.overheads, n);
    }

    public long getOverheads() {
        return this.overheads;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }

    public void updateCount() {
        this.sync.updateCount();
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 4982264981922014374L;

        Sync(int count) {
            this.setState(count);
        }

        int getCount() {
            return this.getState();
        }

        public void updateCount() {
            int nextc;
            int c;
            while (!this.compareAndSetState(c = this.getState(), nextc = c + 1)) {
            }
        }

        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        public boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - 1));
            return nextc == 0;
        }
    }
}

