/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.PhaserAbst;
import hj.lang.PhaserException;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.lang.phaserMode;
import hj.runtime.wsh.Accumulator;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.AtomicDouble;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.SyncVar1;
import hj.runtime.wsh.SyncVar2;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.phaser.PhaserRegMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class PhaserImpl
extends PhaserAbst {
    private static final AtomicInteger nextId_ = new AtomicInteger(-1);
    private final int id_;
    private final String name_;
    public static final int TRANSMIT_INT = 0;
    public static final int SIG_INT = 1;
    public static final int WAIT_INT = 2;
    public static final int SIG_WAIT_INT = 3;
    public static final int SINGLE_INT = 4;
    private int busyWaitCount;
    private volatile int mSigPhase = 0;
    private volatile int mWaitPhase = 0;
    private int minSigP = 0;
    private int minWaitP = 0;
    private int mSigCycle = 0;
    private int mWaitCycle = 0;
    private final AtomicInteger sCastID = new AtomicInteger(0);
    private final AtomicInteger wCastID = new AtomicInteger(0);
    private Mode masterMode;
    private final AtomicInteger masterID = new AtomicInteger(0);
    public String loc_of_master;
    private final ArrayList syncVars1 = new ArrayList();
    private final Integer lockForSyncVars1 = new Integer(0);
    private final ArrayList syncVars2 = new ArrayList();
    private final Integer lockForSyncVars2 = new Integer(0);
    private final AtomicInteger swCounter = new AtomicInteger(0);
    private final AtomicInteger snglCounter = new AtomicInteger(0);
    private final Integer lockForLastDrop = new Integer(0);
    private final int bound;
    private final int upperBound;
    private static final int busyWaitCountInit = 100000;
    private static final Mode defaultMode = Mode.SIG_WAIT_SINGLE;
    private final ArrayList accums = new ArrayList();
    private boolean onlyBoundedANY = true;
    private long gblCP;
    private long gblTime;
    private long gblOvhd;
    private long critPathOps = 0L;
    private long overheads = 0L;
    private long curIdealTime = 0L;

    public static Mode PhaserModeToImplMode(phaserMode m) {
        switch (m) {
            case SIG: {
                return Mode.SIG;
            }
            case WAIT: {
                return Mode.WAIT;
            }
            case SIG_WAIT: {
                return Mode.SIG_WAIT;
            }
            case SIG_WAIT_SINGLE: {
                return Mode.SIG_WAIT_SINGLE;
            }
        }
        throw new RuntimeException("Unhandled phaser mode " + (Object)((Object)m));
    }

    public PhaserImpl() {
        this("", defaultMode, 100000, 0);
    }

    public PhaserImpl(Mode mode) {
        this("", mode, 100000, 0);
    }

    public PhaserImpl(int bound) {
        this("", defaultMode, 100000, bound);
    }

    public PhaserImpl(Mode mode, int bound) {
        this("", mode, 100000, bound);
    }

    public PhaserImpl(String name, Mode mode, int busyWaitCount, int bound) {
        this.name_ = name;
        this.id_ = nextId_.incrementAndGet();
        this.busyWaitCount = busyWaitCount;
        if (mode == Mode.TRANSMIT) {
            throw new PhaserException("TRANSMIT mode isn't permitted.");
        }
        Activity a = (Activity)Runtime.getCurrentActivity();
        a.addPhaser(new PhaserRegMode(this, mode));
        a.registerPhaserToIEF(this);
        if (mode != Mode.WAIT) {
            SyncVar1 s1 = new SyncVar1(0, 0, mode);
            a.putSyncVar1(this, s1);
            this.syncVars1.add(s1);
        }
        if (mode != Mode.SIG) {
            SyncVar2 s2 = new SyncVar2(0, 0, 0, mode);
            a.putSyncVar2(this, s2);
            this.syncVars2.add(s2);
            if (mode == Mode.SIG_WAIT) {
                this.swCounter.addAndGet(1);
            } else if (mode == Mode.SIG_WAIT_SINGLE) {
                this.snglCounter.addAndGet(1);
            }
            this.masterMode = mode;
        }
        if (bound < 0) {
            throw new PhaserException("Bounded size must be greater or equal to 0.");
        }
        this.bound = bound;
        this.upperBound = bound > 0 ? bound * 3 + 1 : 0;
    }

    public void register(Activity a) {
        this.register(a, defaultMode);
    }

    public void register(Activity a, Mode mode) {
        Mode authMode;
        boolean availWait;
        Activity authorizer = (Activity)Runtime.getCurrentActivity();
        SyncVar1 authSync1 = authorizer.getSyncVar1(this);
        SyncVar2 authSync2 = authorizer.getSyncVar2(this);
        boolean availSignal = authSync1 != null && !authSync1.isDropped;
        boolean bl = availWait = authSync2 != null && !authSync2.isDropped;
        if (!availSignal && !availWait) {
            throw new PhaserException("TRANSMIT mode isn't permitted.");
        }
        Mode mode2 = authMode = availSignal ? authSync1.mode : authSync2.mode;
        if (mode != Mode.WAIT && !availSignal || mode != Mode.SIG && !availWait || mode == Mode.SIG_WAIT_SINGLE && authMode != Mode.SIG_WAIT_SINGLE) {
            throw new PhaserException("Capability model violation: Parent mode = " + (Object)((Object)authMode) + ", child mode = " + (Object)((Object)mode) + ".");
        }
        if (this.quiescent(authorizer)) {
            throw new PhaserException(authorizer + "is not active on " + this + "; cannot transmit.");
        }
        if (mode != Mode.WAIT) {
            this.register1(a, authSync1.sigPhase, authSync1.sigCycle, mode);
        }
        if (mode != Mode.SIG) {
            this.register2(a, authSync2.waitPhase, authSync2.waitCycle, authSync2.mID, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register1(Activity a, int sigPhase, int sigCycle, Mode mode) {
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && !s1.isDropped) {
            if (s1.mode == mode) {
                return;
            }
            assert (false);
        } else if (s1 != null) {
            s1.sigPhase = sigPhase;
            s1.sigCycle = sigCycle;
            s1.isResumed = false;
            s1.isDropped = false;
            s1.mode = mode;
        } else {
            SyncVar1 s1n = new SyncVar1(sigPhase, sigCycle, mode);
            a.putSyncVar1(this, s1n);
            Integer n = this.lockForSyncVars1;
            synchronized (n) {
                this.syncVars1.add(s1n);
            }
            if (this.accums.size() > 0) {
                for (Accumulator acc : this.accums) {
                    acc.register(a, mode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register2(Activity a, int waitPhase, int waitCycle, int mID, Mode mode) {
        block11: {
            block12: {
                block13: {
                    SyncVar2 s2;
                    block10: {
                        s2 = a.getSyncVar2(this);
                        if (s2 == null || s2.isDropped) break block10;
                        if (s2.mode == mode) {
                            return;
                        }
                        assert (false);
                        break block11;
                    }
                    if (s2 == null) break block12;
                    s2.waitPhase = waitPhase;
                    s2.waitCycle = waitCycle;
                    s2.isDropped = false;
                    s2.mode = mode;
                    s2.mID = mID;
                    s2.isMaster = false;
                    if (mode != Mode.SIG_WAIT) break block13;
                    this.swCounter.addAndGet(1);
                    break block11;
                }
                if (mode != Mode.SIG_WAIT_SINGLE) break block11;
                this.snglCounter.addAndGet(1);
                break block11;
            }
            SyncVar2 s2n = new SyncVar2(waitPhase, waitCycle, mID, mode);
            a.putSyncVar2(this, s2n);
            Integer n = this.lockForSyncVars2;
            synchronized (n) {
                this.syncVars2.add(s2n);
            }
            if (mode == Mode.SIG_WAIT) {
                this.swCounter.addAndGet(1);
            } else if (mode == Mode.SIG_WAIT_SINGLE) {
                this.snglCounter.addAndGet(1);
            }
            if (this.accums.size() > 0 && mode == Mode.WAIT) {
                for (Accumulator acc : this.accums) {
                    acc.register(a, mode);
                }
            }
        }
    }

    public Mode getMode() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getMode(a);
    }

    public Mode getMode(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && !s1.isDropped) {
            return s1.mode;
        }
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s2 == null || s2.isDropped) {
            throw new PhaserException("Dropped/non-registered activity cannot call getMode.");
        }
        return s2.mode;
    }

    public int getBound() {
        return this.bound;
    }

    public boolean registered() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        SyncVar1 s1 = a.getSyncVar1(this);
        if (s1 != null && !s1.isDropped) {
            return true;
        }
        SyncVar2 s2 = a.getSyncVar2(this);
        return s2 != null && !s2.isDropped;
    }

    public void addAccums(Accumulator accum, accumulator.Operator ope) {
        if (this.onlyBoundedANY && (ope != accumulator.Operator.ANY || this.bound == 0)) {
            this.onlyBoundedANY = false;
        }
        this.accums.add(accum);
    }

    public void drop() {
        this.drop((Activity)Runtime.getCurrentActivity());
    }

    public void drop(Activity a) {
        boolean actIsDropped = this.drop1(a);
        this.drop2(a, actIsDropped);
    }

    public boolean drop1(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        boolean actIsDropped = false;
        if (s1 != null && !s1.isDropped) {
            s1.isDropped = true;
            a.dropPhaser(this);
            actIsDropped = true;
        }
        return actIsDropped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mode setMasterMode(SyncVar2 s2, AtomicInteger c) {
        Mode selected = Mode.TRANSMIT;
        if (c.addAndGet(-1) == 0) {
            Integer n = this.lockForLastDrop;
            synchronized (n) {
                if (c.get() == 0 && s2.mode == this.masterMode) {
                    ArrayList lSyncVars2;
                    Integer n2 = this.lockForSyncVars2;
                    synchronized (n2) {
                        lSyncVars2 = (ArrayList)this.syncVars2.clone();
                    }
                    int size = lSyncVars2.size();
                    for (int i = 0; i < size; ++i) {
                        SyncVar2 workS2 = (SyncVar2)lSyncVars2.get(i);
                        if (workS2 == s2 || workS2.isDropped || workS2.mode.compareTo(selected) <= 0 || workS2.mode.compareTo(s2.mode) >= 0) continue;
                        selected = workS2.mode;
                    }
                    if (selected.compareTo(Mode.TRANSMIT) > 0) {
                        this.masterMode = selected;
                    }
                    lSyncVars2 = null;
                }
            }
        }
        return selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean passedWithoutMasterCheck(SyncVar2 s2) {
        SyncVar2 workS2;
        int i;
        ArrayList lSyncVars2;
        Integer n = this.lockForSyncVars2;
        synchronized (n) {
            lSyncVars2 = (ArrayList)this.syncVars2.clone();
        }
        int size = lSyncVars2.size();
        for (i = 0; i < size && ((workS2 = (SyncVar2)lSyncVars2.get(i)) == s2 || workS2.isDropped || workS2.mID != s2.mID + 1); ++i) {
        }
        lSyncVars2 = null;
        return i < size;
    }

    public void drop2(Activity a, boolean actIsDropped) {
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s2 != null && !s2.isDropped) {
            Mode selected;
            AtomicInteger c = null;
            if (s2.mode == Mode.SIG_WAIT) {
                c = this.swCounter;
            } else if (s2.mode == Mode.SIG_WAIT_SINGLE) {
                c = this.snglCounter;
            }
            Mode mode = selected = c != null ? this.setMasterMode(s2, c) : Mode.TRANSMIT;
            if (selected.compareTo(Mode.TRANSMIT) > 0 && this.passedWithoutMasterCheck(s2) && this.masterID.compareAndSet(s2.mID, s2.mID + 1)) {
                this.waitForWorkerSignals();
                if (this.accums.size() > 0 && !this.onlyBoundedANY) {
                    this.calculateAccums(a, 1);
                }
                ++this.mWaitPhase;
                if (this.bound > 0) {
                    int n = this.mWaitCycle = this.mWaitCycle == this.upperBound ? 0 : this.mWaitCycle + 1;
                    if (!this.wCastID.compareAndSet(this.mWaitPhase - 1, this.mWaitPhase)) {
                        this.notifyAllWorkersOnS1(a.getSyncVar1(this));
                    }
                    if (this.mSigPhase >= this.minWaitP + this.bound) {
                        this.waitForWorkersInBound();
                    }
                }
                ++this.mSigPhase;
                if (this.bound > 0) {
                    int n = this.mSigCycle = this.mSigCycle == this.upperBound ? 0 : this.mSigCycle + 1;
                }
                if (!this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase)) {
                    this.notifyAllWorkersOnS2(s2);
                }
            }
            s2.isDropped = true;
            if (!actIsDropped) {
                a.dropPhaser(this);
            }
        }
    }

    public boolean dropped() {
        return !this.registered();
    }

    public void resume() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.resume(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void resume(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s1 == null || s2 == null) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Activity in " + (Object)((Object)mode) + " cannot resume.");
        }
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot resume.");
        }
        this.signal(a, s1, s2);
    }

    public void signal() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.signal(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void signal(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s1 == null) {
            return;
        }
        if (s2 != null && s1.isResumed) {
            return;
        }
        if (s1.isDropped) {
            throw new PhaserException("Dropped activity cannot signal.");
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.maxCritPathOps(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
            this.maxOverheads(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getOverheads());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).updateIdealTime();
                this.maxIdealTime(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathTime());
            }
        }
        ++s1.sigPhase;
        s1.isResumed = true;
        if (this.bound > 0) {
            int n = s1.sigCycle = s1.sigCycle == this.upperBound ? 0 : s1.sigCycle + 1;
            if (s2 == null && s1.prevMWP + this.bound <= s1.sigPhase) {
                this.waitForMasterInBound(s1);
            }
        }
    }

    public boolean quiescent() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.quiescent(a);
    }

    public boolean quiescent(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        return s1 != null && !s1.isDropped && s1.isResumed && (s1.mode == Mode.SIG_WAIT || s1.mode == Mode.SIG_WAIT_SINGLE);
    }

    public void doNext() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.doNext(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    public void doNext(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s1 == null || s2 == null) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Activity in " + (Object)((Object)mode) + " cannot do next.");
        }
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot do next.");
        }
        this.doWait(a, s1, s2);
    }

    public void doWait() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.doWait(a, a.getSyncVar1(this), a.getSyncVar2(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllWorkersOnS1(SyncVar1 s1) {
        ArrayList lSyncVars1;
        Integer n = this.lockForSyncVars1;
        synchronized (n) {
            lSyncVars1 = (ArrayList)this.syncVars1.clone();
        }
        int size = lSyncVars1.size();
        for (int i = 0; i < size; ++i) {
            SyncVar1 workS1 = (SyncVar1)lSyncVars1.get(i);
            if (workS1 == s1 || workS1.isDropped) continue;
            Integer n2 = workS1.lockForSSync1;
            synchronized (n2) {
                workS1.lockForSSync1.notifyAll();
                continue;
            }
        }
        lSyncVars1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyAllWorkersOnS2(SyncVar2 s2) {
        ArrayList lSyncVars2;
        Integer n = this.lockForSyncVars2;
        synchronized (n) {
            lSyncVars2 = (ArrayList)this.syncVars2.clone();
        }
        int size = lSyncVars2.size();
        for (int i = 0; i < size; ++i) {
            SyncVar2 workS2 = (SyncVar2)lSyncVars2.get(i);
            if (workS2 == s2 || workS2.isDropped) continue;
            Integer n2 = workS2.lockForSSync2;
            synchronized (n2) {
                workS2.lockForSSync2.notifyAll();
                continue;
            }
        }
        lSyncVars2 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForMasterNotifyOnS1(SyncVar1 s1) {
        Thread t = Thread.currentThread();
        ((PoolRunner)t).getPlace().threadBlockedNotification();
        if (this.mWaitPhase + this.bound <= s1.sigPhase) {
            Integer n = s1.lockForSSync1;
            synchronized (n) {
                if (this.mWaitPhase + this.bound <= s1.sigPhase) {
                    try {
                        s1.lockForSSync1.wait();
                    }
                    catch (InterruptedException ie) {
                        ((PoolRunner)t).getPlace().threadUnblockedNotification();
                        throw new Error(ie);
                    }
                }
            }
        }
        ((PoolRunner)t).getPlace().threadUnblockedNotification();
        return this.mWaitPhase + this.bound > s1.sigPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForMasterNotifyOnS2(SyncVar2 s2) {
        Thread t = Thread.currentThread();
        ((PoolRunner)t).getPlace().threadBlockedNotification();
        if (this.mSigPhase <= s2.waitPhase) {
            Integer n = s2.lockForSSync2;
            synchronized (n) {
                if (this.mSigPhase <= s2.waitPhase) {
                    try {
                        s2.lockForSSync2.wait();
                    }
                    catch (InterruptedException ie) {
                        ((PoolRunner)t).getPlace().threadUnblockedNotification();
                        throw new Error(ie);
                    }
                }
            }
        }
        ((PoolRunner)t).getPlace().threadUnblockedNotification();
        return this.mSigPhase > s2.waitPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWorkerSignals() {
        int size = 0;
        int min = Integer.MAX_VALUE;
        while (true) {
            ArrayList lSyncVars1;
            Integer n = this.lockForSyncVars1;
            synchronized (n) {
                int sz = this.syncVars1.size();
                if (sz == size) {
                    break;
                }
                lSyncVars1 = (ArrayList)this.syncVars1.clone();
                int first = size;
                size = sz;
            }
            Thread t = Thread.currentThread();
            ((PoolRunner)t).getPlace().threadBlockedNotification();
            for (int i = first; i < size; ++i) {
                int s1SigP;
                SyncVar1 s1 = (SyncVar1)lSyncVars1.get(i);
                while (!s1.isDropped && s1.sigPhase <= this.mWaitPhase) {
                }
                if (s1.isDropped || (s1SigP = s1.sigPhase) >= min) continue;
                min = s1SigP;
            }
            ((PoolRunner)t).getPlace().threadUnblockedNotification();
            lSyncVars1 = null;
        }
        this.minSigP = min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForWorkersInBound() {
        int size = 0;
        int min = Integer.MAX_VALUE;
        while (true) {
            ArrayList lSyncVars2;
            Integer n = this.lockForSyncVars2;
            synchronized (n) {
                int sz = this.syncVars2.size();
                if (sz == size) {
                    break;
                }
                lSyncVars2 = (ArrayList)this.syncVars2.clone();
                int first = size;
                size = sz;
            }
            Thread t = Thread.currentThread();
            ((PoolRunner)t).getPlace().threadBlockedNotification();
            for (int i = first; i < size; ++i) {
                int s2WaitP;
                SyncVar2 s2 = (SyncVar2)lSyncVars2.get(i);
                while (!s2.isDropped && s2.waitPhase + this.bound <= this.mSigPhase) {
                }
                if (s2.isDropped || (s2WaitP = s2.waitPhase) >= min) continue;
                min = s2WaitP;
            }
            ((PoolRunner)t).getPlace().threadUnblockedNotification();
            lSyncVars2 = null;
        }
        this.minWaitP = min;
    }

    private void waitForMasterInBound(SyncVar1 s1) {
        boolean done = false;
        while (!done) {
            for (int j = 0; j < this.busyWaitCount; ++j) {
                if (this.mWaitPhase + this.bound <= s1.sigPhase) continue;
                done = true;
                s1.prevMWP = this.mWaitPhase;
                break;
            }
            if (done) continue;
            while (this.wCastID.get() < s1.sigPhase - this.bound) {
            }
            this.wCastID.compareAndSet(s1.sigPhase - this.bound, s1.sigPhase - this.bound + 1);
            if (!this.waitForMasterNotifyOnS1(s1)) continue;
            done = true;
            s1.prevMWP = this.mWaitPhase;
        }
    }

    private void waitForMasterSignal(SyncVar2 s2) {
        boolean done = false;
        while (!done) {
            for (int j = 0; j < this.busyWaitCount; ++j) {
                if (this.mSigPhase <= s2.waitPhase) continue;
                done = true;
                s2.prevMSP = this.mSigPhase;
                break;
            }
            if (done) continue;
            while (this.sCastID.get() < s2.waitPhase) {
            }
            this.sCastID.compareAndSet(s2.waitPhase, s2.waitPhase + 1);
            if (!this.waitForMasterNotifyOnS2(s2)) continue;
            done = true;
            s2.prevMSP = this.mSigPhase;
        }
    }

    private void calculateAccums(Activity a, int delta) {
        Iterator it = this.accums.iterator();
        if (this.bound == 0 || delta == 1) {
            while (it.hasNext()) {
                Accumulator acc = (Accumulator)it.next();
                accumulator.Operator ope = acc.getOperator();
                if (ope != accumulator.Operator.ANY) {
                    Number v;
                    Class type = acc.getType();
                    if (type == Integer.class) {
                        AtomicInteger aI = this.bound == 0 ? acc.atomI : acc.atomIbuff[this.mWaitCycle];
                        v = new Integer(aI.get());
                        acc.setResultAndSigPhase(v, this.mSigPhase, this.mSigCycle);
                    } else if (type == Double.class) {
                        AtomicDouble aD = this.bound == 0 ? acc.atomD : acc.atomDbuff[this.mWaitCycle];
                        v = new Double(aD.get());
                        acc.setResultAndSigPhase(v, this.mSigPhase, this.mSigCycle);
                    } else assert (false);
                    acc.initAtomicVar(this.mWaitCycle);
                    continue;
                }
                if (this.bound != 0) continue;
                acc.moveTmp2Result();
            }
        } else {
            while (it.hasNext()) {
                Accumulator acc = (Accumulator)it.next();
                accumulator.Operator ope = acc.getOperator();
                if (ope != accumulator.Operator.ANY) {
                    Number v;
                    int i;
                    int cyc;
                    Class type = acc.getType();
                    if (type == Integer.class) {
                        cyc = this.mWaitCycle;
                        for (i = 0; i < delta; ++i) {
                            v = new Integer(acc.atomIbuff[cyc].get());
                            acc.setResultAndSigPhase(v, this.mSigPhase, cyc);
                            acc.initAtomicVar(cyc);
                            cyc = cyc == this.upperBound ? 0 : cyc + 1;
                        }
                        continue;
                    }
                    if (type == Double.class) {
                        cyc = this.mWaitCycle;
                        for (i = 0; i < delta; ++i) {
                            v = new Double(acc.atomDbuff[cyc].get());
                            acc.setResultAndSigPhase(v, this.mSigPhase, cyc);
                            acc.initAtomicVar(cyc);
                            cyc = cyc == this.upperBound ? 0 : cyc + 1;
                        }
                        continue;
                    }
                    assert (false);
                    continue;
                }
                if (this.bound != 0) continue;
                acc.moveTmp2Result();
            }
        }
    }

    public void doWait(Activity a, SyncVar1 s1, SyncVar2 s2) {
        if (s2 == null) {
            return;
        }
        if (s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (s1 != null && !s1.isResumed) {
            throw new PhaserException("Signal is necessary before wait.");
        }
        ++s2.mID;
        boolean bl = s2.isMaster = s2.prevMSP <= s2.waitPhase && this.mSigPhase <= s2.waitPhase && s2.mode == this.masterMode && this.masterID.compareAndSet(s2.mID - 1, s2.mID);
        if (s2.mode == Mode.SIG_WAIT_SINGLE) {
            s2.loc = null;
        }
        if (s1 != null) {
            s1.isResumed = false;
        }
        if (s2.isMaster) {
            if (s1 != null) {
                this.waitForWorkerSignals();
                if (this.accums.size() > 0 && !this.onlyBoundedANY) {
                    this.calculateAccums(a, 1);
                }
                ++this.mWaitPhase;
                if (this.bound > 0) {
                    int n = this.mWaitCycle = this.mWaitCycle == this.upperBound ? 0 : this.mWaitCycle + 1;
                    if (!this.wCastID.compareAndSet(this.mWaitPhase - 1, this.mWaitPhase)) {
                        this.notifyAllWorkersOnS1(s1);
                    }
                    if (this.mSigPhase >= this.minWaitP + this.bound) {
                        this.waitForWorkersInBound();
                    }
                }
                if (VMInterface.ABSTRACT_EXECUTION_STATS) {
                    this.gblCP = this.getCritPathOps();
                    this.gblOvhd = this.getOverheads();
                    if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                        this.gblTime = this.getIdealTime();
                    }
                }
                if (s2.mode == Mode.SIG_WAIT_SINGLE) {
                    this.loc_of_master = s2.loc;
                }
                if (this.bound > 0) {
                    this.mSigCycle = this.mSigCycle == this.upperBound ? 0 : this.mSigCycle + 1;
                }
                ++this.mSigPhase;
                if (!this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase)) {
                    this.notifyAllWorkersOnS2(s2);
                }
            } else {
                boolean flg;
                int delta;
                this.waitForWorkerSignals();
                int t = Integer.MAX_VALUE;
                if (this.bound > 0) {
                    this.waitForWorkersInBound();
                    t = this.minWaitP + this.bound;
                }
                int n = delta = this.minSigP < t ? this.minSigP - this.mWaitPhase : t - this.mWaitPhase;
                if (this.accums.size() > 0 && !this.onlyBoundedANY) {
                    this.calculateAccums(a, delta);
                }
                if (delta > 1) {
                    flg = this.masterID.compareAndSet(s2.mID, s2.mID + delta - 1);
                    assert (flg);
                }
                this.mWaitPhase += delta;
                if (this.bound > 0) {
                    int t2 = this.mWaitCycle + delta;
                    int n2 = this.mWaitCycle = t2 > this.upperBound ? t2 - this.upperBound - 1 : t2;
                    if (!this.wCastID.compareAndSet(this.mWaitPhase - delta, this.mWaitPhase)) {
                        boolean flg2 = this.wCastID.compareAndSet(this.mWaitPhase - delta + 1, this.mWaitPhase);
                        assert (flg2);
                        this.notifyAllWorkersOnS1(s1);
                    }
                }
                while (this.sCastID.get() < this.mSigPhase) {
                }
                if (VMInterface.ABSTRACT_EXECUTION_STATS) {
                    this.gblCP = this.getCritPathOps();
                    this.gblOvhd = this.getOverheads();
                    if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                        this.gblTime = this.getIdealTime();
                    }
                }
                if (this.bound > 0) {
                    int t3 = this.mSigCycle + delta;
                    this.mSigCycle = t3 > this.upperBound ? t3 - this.upperBound - 1 : t3;
                }
                this.mSigPhase += delta;
                if (!this.sCastID.compareAndSet(this.mSigPhase - delta, this.mSigPhase)) {
                    if (delta > 1) {
                        flg = this.sCastID.compareAndSet(this.mSigPhase - delta + 1, this.mSigPhase);
                        assert (flg);
                    }
                    this.notifyAllWorkersOnS2(s2);
                }
            }
        } else {
            if (s1 != null || s2.prevMSP <= s2.waitPhase) {
                this.waitForMasterSignal(s2);
            }
            if (s2.mode == Mode.SIG_WAIT_SINGLE && this.loc_of_master != null) {
                throw new PhaserException("Location of single statement doesn't match.");
            }
        }
        ++s2.waitPhase;
        if (this.bound > 0) {
            int n = s2.waitCycle = s2.waitCycle == this.upperBound ? 0 : s2.waitCycle + 1;
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.gblCP);
            ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.gblOvhd);
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.gblTime);
                ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
            }
        }
    }

    public boolean doWaitSingle1() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.doWaitSingle1(a, a.getSyncVar1(this), a.getSyncVar2(this), "foo");
    }

    public boolean doWaitSingle1(String loc) {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.doWaitSingle1(a, a.getSyncVar1(this), a.getSyncVar2(this), loc);
    }

    public boolean doWaitSingle1(Activity a, SyncVar1 s1, SyncVar2 s2, String loc) {
        if (s1 == null || s1.mode != Mode.SIG_WAIT_SINGLE || s2 == null || s2.mode != Mode.SIG_WAIT_SINGLE) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Single statement isn't permitted for activity in " + (Object)((Object)mode) + ".");
        }
        if (s1.isDropped || s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (!s1.isResumed) {
            throw new PhaserException("Signal is necessary before wait.");
        }
        ++s2.mID;
        s2.isMaster = this.mSigPhase <= s2.waitPhase && s2.mode == this.masterMode && this.masterID.compareAndSet(s2.mID - 1, s2.mID);
        s2.loc = loc;
        if (s1 != null) {
            s1.isResumed = false;
        }
        if (s2.isMaster) {
            this.waitForWorkerSignals();
            if (this.accums.size() > 0 && !this.onlyBoundedANY) {
                this.calculateAccums(a, 1);
            }
            ++this.mWaitPhase;
            if (this.bound > 0) {
                int n = this.mWaitCycle = this.mWaitCycle == this.upperBound ? 0 : this.mWaitCycle + 1;
                if (!this.wCastID.compareAndSet(this.mWaitPhase - 1, this.mWaitPhase)) {
                    this.notifyAllWorkersOnS1(s1);
                }
                if (this.mSigPhase >= this.minWaitP + this.bound) {
                    this.waitForWorkersInBound();
                }
            }
            if (VMInterface.ABSTRACT_EXECUTION_STATS) {
                this.gblCP = this.getCritPathOps();
                this.gblOvhd = this.getOverheads();
                ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.gblCP);
                ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.gblOvhd);
                if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                    this.gblTime = this.getIdealTime();
                    ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.gblTime);
                    ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
                }
            }
        }
        return s2.isMaster;
    }

    public void doWaitSingle2() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        this.doWaitSingle2(a, a.getSyncVar2(this));
    }

    public void doWaitSingle2(Activity a, SyncVar2 s2) {
        if (s2 == null || s2.mode != Mode.SIG_WAIT_SINGLE) {
            Mode mode = this.getMode(a);
            throw new PhaserException("Single statement isn't permitted for activity in " + (Object)((Object)mode) + ".");
        }
        if (s2.isDropped) {
            throw new PhaserException("Dropped activity cannot wait.");
        }
        if (s2.isMaster) {
            if (VMInterface.ABSTRACT_EXECUTION_STATS) {
                this.maxCritPathOps(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
                this.maxOverheads(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getOverheads());
                this.gblCP = this.getCritPathOps();
                this.gblOvhd = this.getOverheads();
                if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                    ((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).updateIdealTime();
                    this.maxIdealTime(((AbstractMetrics)((Object)WshRuntime_c.getCurrentActivity())).getCritPathTime());
                    this.gblTime = this.getIdealTime();
                }
            }
            this.loc_of_master = s2.loc;
            if (this.bound > 0) {
                this.mSigCycle = this.mSigCycle == this.upperBound ? 0 : this.mSigCycle + 1;
            }
            ++this.mSigPhase;
            if (!this.sCastID.compareAndSet(this.mSigPhase - 1, this.mSigPhase)) {
                this.notifyAllWorkersOnS2(s2);
            }
        } else {
            this.waitForMasterSignal(s2);
            if (!s2.loc.equals(this.loc_of_master)) {
                throw new PhaserException("Location of single statement doesn't match.");
            }
        }
        ++s2.waitPhase;
        if (this.bound > 0) {
            int n = s2.waitCycle = s2.waitCycle == this.upperBound ? 0 : s2.waitCycle + 1;
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathOps(this.gblCP);
            ((Activity)WshRuntime_c.getCurrentActivity()).maxOverheads(this.gblOvhd);
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)WshRuntime_c.getCurrentActivity()).maxCritPathTime(this.gblTime);
                ((Activity)WshRuntime_c.getCurrentActivity()).setResumeTime();
            }
        }
    }

    public int getSigPhase() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getSigPhase(a);
    }

    public int getSigPhase(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        if (this.mSigPhase != this.mWaitPhase && s2 != null && !s2.isDropped && s2.isMaster) {
            return this.mSigPhase;
        }
        if (s1 == null || s1.isDropped) {
            return Integer.MAX_VALUE;
        }
        return s1.sigPhase;
    }

    public int getWaitPhase() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getWaitPhase(a);
    }

    public int getWaitPhase(Activity a) {
        SyncVar2 s2 = a.getSyncVar2(this);
        if (s2 == null || s2.isDropped) {
            return 0;
        }
        if (this.mSigPhase != this.mWaitPhase && s2.isMaster) {
            return this.mWaitPhase;
        }
        return s2.waitPhase;
    }

    public int getSigCycle() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getSigCycle(a);
    }

    public int getSigCycle(Activity a) {
        SyncVar1 s1 = a.getSyncVar1(this);
        SyncVar2 s2 = a.getSyncVar2(this);
        if (this.bound == 0) {
            return 0;
        }
        if (this.mSigPhase != this.mWaitPhase && s2 != null && !s2.isDropped && s2.isMaster) {
            return this.mSigCycle;
        }
        if (s1 == null || s1.isDropped) {
            return 0;
        }
        return s1.sigCycle;
    }

    public int getWaitCycle() {
        Activity a = (Activity)Runtime.getCurrentActivity();
        return this.getWaitCycle(a);
    }

    public int getWaitCycle(Activity a) {
        SyncVar2 s2 = a.getSyncVar2(this);
        if (this.bound == 0 || s2 == null || s2.isDropped) {
            return 0;
        }
        if (this.mSigPhase != this.mWaitPhase && s2.isMaster) {
            return this.mWaitCycle;
        }
        return s2.waitCycle;
    }

    public boolean masterInSingle(Activity a) {
        SyncVar2 s2 = a.getSyncVar2(this);
        return this.masterInSingle(s2);
    }

    public boolean masterInSingle(SyncVar2 s2) {
        return s2 != null && !s2.isDropped && this.mSigPhase != this.mWaitPhase && s2.isMaster;
    }

    public String toString() {
        return "Phaser" + this.id_ + this.name_ + ")";
    }

    synchronized boolean tryMoveToSplit_() {
        assert (false);
        return true;
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxOverheads(long n) {
        this.overheads = Math.max(this.overheads, n);
    }

    public long getOverheads() {
        return this.overheads;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }

    public static interface AdvanceListener {
        public void notifyAdvance();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        TRANSMIT,
        SIG,
        WAIT,
        SIG_WAIT,
        SIG_WAIT_SINGLE;

    }
}

