/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class PreLoader {
    private static final String TRUE = "true";
    private static final Map inited = new HashMap();
    private static final ClassLoader bootstrap = Object.class.getClassLoader();
    private static final int CONSTANT_Empty = 0;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final byte[] EMPTY = new byte[]{0};
    private static final String[] TAGS = new String[]{"EMPTY", "UTF8", null, "INTEGER", "FLOAT", "LONG", "DOUBLE", "CLASS", "STRING", "FIELDREF", "METHODREF", "IMETHOD", "NAME/TYPE"};

    public static void main(String[] args) {
        if (args.length > 0) {
            PreLoader.preLoad(args[0], PreLoader.class);
        } else {
            PreLoader.preLoad(PreLoader.class);
        }
    }

    public static void preLoad(Class c) {
        PreLoader.preLoad(PreLoader.getClassFile(c), c);
    }

    public static void preLoad(Class c, boolean intern) {
        if (c.getClassLoader() == bootstrap) {
            return;
        }
        PreLoader.preLoad(PreLoader.getClassFile(c), c, intern);
    }

    private static void preLoad(String name, Class c) {
        PreLoader.preLoad(name, c, true);
    }

    private static void preLoad(String name, Class c, boolean intern) {
        block7: {
            if (inited.get(name) != null) {
                return;
            }
            inited.put(name, TRUE);
            try {
                InputStream in = PreLoader.getClassAsStream(name, c);
                byte[][] cp = PreLoader.getConstantPool(name, in);
                if (intern) {
                    PreLoader.internStrings(cp);
                }
                String[] ref_classes = PreLoader.getReferencedClasses(name, cp);
                for (int i = 0; i < ref_classes.length; ++i) {
                    String nm = PreLoader.toClassName(ref_classes[i]);
                    try {
                        Class<?> u = Class.forName(nm);
                        if (nm.charAt(0) == '[' || u.getClassLoader() == bootstrap) continue;
                        PreLoader.preLoad(PreLoader.toFileName(nm), c, intern);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    private static InputStream getClassAsStream(Class c) throws IOException {
        return PreLoader.getClassAsStream(PreLoader.getClassFile(c), c);
    }

    private static InputStream getClassAsStream(String name, Class c) throws IOException {
        InputStream cin = c.getClassLoader().getResourceAsStream(name);
        if (cin == null) {
            throw new IOException("Class file " + name + " cannot be found");
        }
        return cin;
    }

    private static String toClassName(String n) {
        return n.replace('/', '.');
    }

    private static String toFileName(String n) {
        return n.replace('.', '/') + ".class";
    }

    private static String getClassFile(Class c) {
        return PreLoader.toFileName(c.getName());
    }

    private static byte[] getClassBytes(String name, Class c) throws IOException {
        byte[] classbytes;
        InputStream cin = PreLoader.getClassAsStream(name, c);
        if (cin.read(classbytes = new byte[cin.available()]) != classbytes.length) {
            throw new IOException("Could not read class");
        }
        return classbytes;
    }

    private static void internStrings(byte[][] cp) {
        for (int i = 1; i < cp.length; ++i) {
            if (cp[i][0] != 1) continue;
            int len = (cp[i][1] & 0xFF) << 8 | cp[i][2] & 0xFF;
            try {
                String s = new String(cp[i], 3, len, "UTF-8").intern();
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private static String[] getReferencedClasses(String name, byte[][] cp) {
        int num_classes = 0;
        for (int i = 1; i < cp.length; ++i) {
            if (cp[i][0] != 7) continue;
            ++num_classes;
        }
        String[] ref_classes = new String[num_classes];
        int j = 0;
        for (int i = 1; i < cp.length; ++i) {
            if (cp[i][0] != 7) continue;
            int name_idx = (cp[i][1] & 0xFF) << 8 | cp[i][2] & 0xFF;
            if (cp[name_idx][0] != 1) {
                throw new Error("Class entry " + i + " refers to non-utf (" + cp[name_idx][0] + ") entry " + name_idx + " in " + name);
            }
            int name_len = (cp[name_idx][1] & 0xFF) << 8 | cp[name_idx][2] & 0xFF;
            try {
                ref_classes[j++] = new String(cp[name_idx], 3, name_len, "UTF-8").intern();
                continue;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return ref_classes;
    }

    private static byte[][] getConstantPool(String name, byte[] classbytes) {
        try {
            return PreLoader.getConstantPool(name, new ByteArrayInputStream(classbytes));
        }
        catch (IOException e) {
            throw new Error("Unable to read from an array of bytes");
        }
    }

    private static byte[][] getConstantPool(String name, InputStream in) throws IOException {
        for (int i = 0; i < 8; ++i) {
            in.read();
        }
        int cp_size = (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        byte[][] cp = new byte[cp_size][];
        cp[0] = EMPTY;
        block9: for (int i = 1; i < cp_size; ++i) {
            byte tag = (byte)in.read();
            switch (tag) {
                case 7: 
                case 8: {
                    cp[i] = new byte[]{tag, (byte)in.read(), (byte)in.read()};
                    continue block9;
                }
                case 9: 
                case 10: 
                case 11: {
                    cp[i] = new byte[]{tag, (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read()};
                    continue block9;
                }
                case 3: 
                case 4: {
                    cp[i] = new byte[]{tag, (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read()};
                    continue block9;
                }
                case 5: 
                case 6: {
                    cp[i] = new byte[]{tag, (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read()};
                    cp[++i] = EMPTY;
                    continue block9;
                }
                case 12: {
                    cp[i] = new byte[]{tag, (byte)in.read(), (byte)in.read(), (byte)in.read(), (byte)in.read()};
                    continue block9;
                }
                case 1: {
                    int n;
                    byte l_h = (byte)in.read();
                    byte l_l = (byte)in.read();
                    int len = (l_h & 0xFF) << 8 | l_l & 0xFF;
                    cp[i] = new byte[len + 3];
                    cp[i][0] = tag;
                    cp[i][1] = l_h;
                    cp[i][2] = l_l;
                    int off = 3;
                    while ((n = in.read(cp[i], off, len)) != len) {
                        len -= n;
                        off += n;
                    }
                    continue block9;
                }
                default: {
                    throw new Error("Unknown constant pool tag (" + tag + ") at entry " + i + " in " + name);
                }
            }
        }
        return cp;
    }

    private static void printConstantPoolEntry(byte[][] cp, int i, PrintStream out) {
        byte[] entry = cp[i];
        byte tag = entry[0];
        out.print(i + ": " + TAGS[tag]);
        switch (tag) {
            case 0: {
                out.println();
                break;
            }
            case 7: 
            case 8: {
                int tmp1 = (entry[1] & 0xFF) << 8 | entry[2] & 0xFF;
                out.println("[" + tmp1 + "]");
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                int tmp1 = (entry[1] & 0xFF) << 8 | entry[2] & 0xFF;
                int tmp2 = (entry[3] & 0xFF) << 8 | entry[4] & 0xFF;
                out.println("[" + tmp1 + "," + tmp2 + "]");
                break;
            }
            case 3: 
            case 4: {
                int tmp1 = ((entry[1] & 0xFF) << 8 | entry[2] & 0xFF) << 16 | ((entry[3] & 0xFF) << 8 | entry[4] & 0xFF);
                if (tag == 4) {
                    out.println(" = " + PreLoader.toFloat(tmp1));
                    break;
                }
                out.println(" = " + tmp1);
                break;
            }
            case 5: 
            case 6: {
                int tmp1 = ((entry[1] & 0xFF) << 8 | entry[2] & 0xFF) << 16 | ((entry[3] & 0xFF) << 8 | entry[4] & 0xFF);
                int tmp2 = ((entry[5] & 0xFF) << 8 | entry[6] & 0xFF) << 16 | ((entry[7] & 0xFF) << 8 | entry[8] & 0xFF);
                if (tag == 6) {
                    out.println(" = " + PreLoader.toDouble(tmp1, tmp2));
                    break;
                }
                out.println(" = " + PreLoader.toLong(tmp1, tmp2));
                break;
            }
            case 12: {
                int tmp1 = (entry[1] & 0xFF) << 8 | entry[2] & 0xFF;
                int tmp2 = (entry[3] & 0xFF) << 8 | entry[4] & 0xFF;
                out.println("[" + tmp1 + "," + tmp2 + "]");
                break;
            }
            case 1: {
                int tmp1 = (entry[1] & 0xFF) << 8 | entry[2] & 0xFF;
                try {
                    out.println(" = \"" + new String(entry, 3, tmp1, "UTF-8") + "\"");
                }
                catch (UnsupportedEncodingException e) {}
                break;
            }
            default: {
                throw new Error("Unknown constant pool tag (" + tag + ") at entry " + i);
            }
        }
    }

    private static float toFloat(int v) {
        return Float.intBitsToFloat(v);
    }

    private static long toLong(int h, int l) {
        long r = h;
        return r << 32 + l;
    }

    private static double toDouble(int h, int l) {
        long r = h;
        return Double.longBitsToDouble(r << 32 + l);
    }
}

