/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.runtime.wsh.WshConfiguration;
import java.util.concurrent.atomic.AtomicInteger;

public final class VMInterface {
    public static final int NUMBER_OF_LOCAL_PLACES = WshConfiguration.NUMBER_OF_LOCAL_PLACES;
    public static final boolean ABSTRACT_EXECUTION_STATS = WshConfiguration.ABSTRACT_EXECUTION_STATS;
    public static final boolean ABSTRACT_EXECUTION_TIMES = WshConfiguration.ABSTRACT_EXECUTION_TIMES;
    public static final boolean BIND_THREADS = WshConfiguration.BIND_THREADS;
    public static final boolean BIND_THREADS_DIAGNOSTICS = WshConfiguration.BIND_THREADS_DIAGNOSTICS;
    private static final AtomicInteger globalThreadNumber = new AtomicInteger(0);
    private static final int numCPUs;
    private static final String thrdSuppLib = "HjThreadSupp";

    public static final void loadMeInMain() {
    }

    public static final int speculateIndex(int index, int upperBound) {
        if (index >= upperBound) {
            return 0;
        }
        return index;
    }

    public static final int getCPU() {
        return -1;
    }

    public static final int noBoundsCheck(int i) {
        return i;
    }

    public static int checkLowBound(int i, int low) {
        if (i < low) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return i;
    }

    public static int checkHighBound(int i, int high) {
        if (i > high) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return i;
    }

    public static final Object noNullCheck(Object o) {
        return o;
    }

    public static final Object noCastCheck(Object o) {
        return o;
    }

    static final Runnable mapPoolThreadToCPU(final Runnable workerRunnable, int placeNumber, int workerWithinPool, String threadName) {
        if (BIND_THREADS && numCPUs != 0) {
            int CPUsPerPlace = numCPUs / WshConfiguration.NUMBER_OF_LOCAL_PLACES;
            int firstCPUInThisPlace = CPUsPerPlace * placeNumber;
            int numCPUsInThisPlace = placeNumber == WshConfiguration.NUMBER_OF_LOCAL_PLACES - 1 ? numCPUs - firstCPUInThisPlace : CPUsPerPlace;
            final int myCPU = (firstCPUInThisPlace + workerWithinPool % numCPUsInThisPlace) % numCPUs;
            if (BIND_THREADS_DIAGNOSTICS) {
                System.err.println("BIND_THREADS: Mapping thread " + threadName + " to CPU " + myCPU);
            }
            return new Runnable(){

                public void run() {
                    VMInterface.putMeOnCPU(myCPU);
                    workerRunnable.run();
                }
            };
        }
        return workerRunnable;
    }

    private static final native int getNumCPUs();

    private static final native void putMeOnCPU(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int n = 0;
        try {
            System.loadLibrary(thrdSuppLib);
            n = VMInterface.getNumCPUs();
        }
        catch (UnsatisfiedLinkError ule) {
            if (BIND_THREADS_DIAGNOSTICS) {
                System.err.println("BIND_THREADS: Library HjThreadSupp not found???");
            }
        }
        finally {
            numCPUs = n;
        }
    }
}

