/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.HjOVDException;
import hj.runtime.wsh.TwoLevelLockPlace;
import hj.util.ConcurrentHashMap;
import hj.util.Epoc;

public class WshOVDManager {
    private static ConcurrentHashMap stateTable = new ConcurrentHashMap();
    private static final Object SHARED_READONLY = new Object();

    public static void checkRead(ActivityRunner ar, Object obj) {
        Epoc epoc = ar.getEpoc();
        Activity activity2 = ar.getActivity();
        if (ar != null) {
            Object updated = null;
            do {
                Object o;
                if ((o = stateTable.getObj(obj, epoc)) == null) {
                    updated = stateTable.putObj(obj, ar, activity2, activity2.getAct_Clock(), false, TwoLevelLockPlace.inLock(ar), null);
                    continue;
                }
                Object origState = epoc.value;
                if (origState != SHARED_READONLY) {
                    boolean hb;
                    if (epoc.isWrite) {
                        if (epoc.value == ar) {
                            return;
                        }
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            return;
                        }
                        if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            return;
                        }
                        System.out.println("Read After Write Violation in obj ");
                        throw new HjOVDException("Read After Write Violation in obj");
                    }
                    if (epoc.value == ar) {
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            epoc.value = SHARED_READONLY;
                        }
                    }
                }
                updated = stateTable.putObj(obj, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    public static void checkRead(ActivityRunner ar, int objID) {
        Epoc epoc = ar.getEpoc();
        Activity activity2 = ar.getActivity();
        if (ar != null) {
            Boolean updated = null;
            do {
                Object o;
                if ((o = stateTable.getInt(objID, epoc)) == null) {
                    updated = stateTable.putInt(objID, ar, activity2, activity2.getAct_Clock(), false, TwoLevelLockPlace.inLock(ar), null);
                    continue;
                }
                Object origState = epoc.value;
                if (origState != SHARED_READONLY) {
                    boolean hb;
                    if (epoc.isWrite) {
                        if (epoc.value == ar) {
                            return;
                        }
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            return;
                        }
                        if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            return;
                        }
                        System.out.println("Read After Write Violation in array");
                        throw new HjOVDException("Read After Write Violation in array");
                    }
                    if (epoc.value == ar) {
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            epoc.value = SHARED_READONLY;
                        }
                    }
                }
                updated = stateTable.putInt(objID, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkWrite(ActivityRunner ar, Object obj) {
        block17: {
            Epoc epoc = ar.getEpoc();
            Activity activity2 = ar.getActivity();
            if (ar == null) break block17;
            Object updated = null;
            do {
                Object origState;
                block16: {
                    boolean hb;
                    block18: {
                        Object o;
                        if ((o = stateTable.getObj(obj, epoc)) == null) {
                            updated = stateTable.putObj(obj, ar, activity2, activity2.getAct_Clock(), true, TwoLevelLockPlace.inLock(ar), null);
                            continue;
                        }
                        origState = epoc.value;
                        if (epoc.value == SHARED_READONLY) {
                            System.out.println("Write After Read Violation in obj");
                            throw new HjOVDException("Write After Read Violation in obj");
                        }
                        if (!epoc.isWrite) break block18;
                        if (epoc.value == ar) {
                            if (epoc.activity == activity2 && epoc.act_clock == activity2.getAct_Clock()) {
                                epoc.act_clock = activity2.getAct_Clock();
                                epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                                break block16;
                            } else {
                                epoc.activity = activity2;
                                epoc.act_clock = activity2.getAct_Clock();
                                epoc.inLock = TwoLevelLockPlace.inLock(ar);
                            }
                            break block16;
                        } else {
                            hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                            if (hb) {
                                epoc.value = ar;
                                epoc.activity = activity2;
                                epoc.act_clock = activity2.getAct_Clock();
                                epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                                break block16;
                            } else {
                                if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                                    return;
                                }
                                System.out.println("Write After Write Violation in obj");
                                throw new HjOVDException("Write After Write Violation in obj");
                            }
                        }
                    }
                    if (epoc.value == ar) {
                        epoc.activity = activity2;
                        epoc.act_clock = activity2.getAct_Clock();
                        epoc.isWrite = true;
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            System.out.println("Write After Read Violation in obj");
                            throw new HjOVDException("Write After Read Violation in obj");
                        }
                    }
                }
                updated = stateTable.putObj(obj, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void checkWrite(ActivityRunner ar, int objID) {
        block15: {
            Epoc epoc = ar.getEpoc();
            Activity activity2 = ar.getActivity();
            if (ar == null) break block15;
            Boolean updated = null;
            do {
                Object origState;
                block14: {
                    boolean hb;
                    block16: {
                        Object o;
                        if ((o = stateTable.getInt(objID, epoc)) == null) {
                            updated = stateTable.putInt(objID, ar, activity2, activity2.getAct_Clock(), true, TwoLevelLockPlace.inLock(ar), null);
                            continue;
                        }
                        origState = epoc.value;
                        if (epoc.value == SHARED_READONLY) {
                            System.out.println("Write After Read Violation in array");
                            throw new HjOVDException("Write After Read Violation in array");
                        }
                        if (!epoc.isWrite) break block16;
                        if (epoc.value == ar) {
                            epoc.act_clock = activity2.getAct_Clock();
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                            break block14;
                        } else {
                            hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                            if (hb) {
                                epoc.value = ar;
                                epoc.activity = activity2;
                                epoc.act_clock = activity2.getAct_Clock();
                                epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                                break block14;
                            } else {
                                if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                                    return;
                                }
                                System.out.println("Write After Write Violation in array");
                                throw new HjOVDException("Write After Write Violation in array");
                            }
                        }
                    }
                    if (epoc.value == ar) {
                        epoc.activity = activity2;
                        epoc.act_clock = activity2.getAct_Clock();
                        epoc.isWrite = true;
                        epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                    } else {
                        hb = WshOVDManager.isHappenBefore(epoc.activity, epoc.act_clock, activity2);
                        if (hb) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else if (epoc.inLock && TwoLevelLockPlace.inLock(ar)) {
                            epoc.activity = activity2;
                            epoc.act_clock = activity2.getAct_Clock();
                            epoc.isWrite = true;
                            epoc.inLock = epoc.inLock && TwoLevelLockPlace.inLock(ar);
                        } else {
                            System.out.println("Write After Read Violation rw in array");
                            throw new HjOVDException("Write After Read Violation rw in array");
                        }
                    }
                }
                updated = stateTable.putInt(objID, epoc.value, epoc.activity, epoc.act_clock, epoc.isWrite, epoc.inLock, origState);
            } while (updated == null);
        }
    }

    public static ActivityRunner getCurrentWorker() {
        Thread t = Thread.currentThread();
        if (t instanceof ActivityRunner) {
            return (ActivityRunner)((Object)t);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean isHappenBefore(Activity oldAct, int oldAct_Clock, Activity curAct) {
        int curSL;
        if (oldAct == null) {
            return false;
        }
        int oldSL = oldAct.getSpawnLevel();
        if (oldSL < (curSL = curAct.getSpawnLevel())) {
            while (oldSL < curSL - 1) {
                curAct = curAct.getParentActivity();
                curSL = curAct.getSpawnLevel();
            }
            Activity curParent = curAct.getParentActivity();
            if (oldAct != curParent) return WshOVDManager.checkHappenBefore(oldAct, curParent);
            if (oldAct_Clock > curAct.getParentAct_Clock()) return false;
            return true;
        }
        if (oldSL <= curSL) return WshOVDManager.checkHappenBefore(oldAct, curAct);
        while (curSL < oldSL - 1) {
            oldAct = oldAct.getParentActivity();
            oldSL = oldAct.getSpawnLevel();
        }
        Activity oldParent = oldAct.getParentActivity();
        if (oldParent != curAct) return WshOVDManager.checkHappenBefore(oldParent, curAct);
        if (curAct.hasFinishState(oldAct.getFinishState())) return false;
        return true;
    }

    protected static boolean checkHappenBefore(Activity oldAct, Activity curAct) {
        Activity oldParent = oldAct;
        Activity curParent = curAct;
        do {
            oldAct = oldParent;
            curAct = curParent;
        } while ((oldParent = oldParent.getParentActivity()) != (curParent = curParent.getParentActivity()) && oldParent != null && curParent != null);
        if (oldParent == null || curParent == null) {
            return false;
        }
        if (oldAct.getParentAct_Clock() < curAct.getParentAct_Clock()) {
            return !oldParent.hasFinishState(oldAct.getFinishState());
        }
        return false;
    }
}

