/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.phaser;

import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.PhaserImpl;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.phaser.PhaserManager;
import hj.runtime.wsh.phaser.PhaserRegMode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaserManagerImpl
implements PhaserManager {
    protected Activity activity;
    private PhaserRegMode singlePhaserRegMode;
    private List<PhaserRegMode> phaserRegModeList;

    public PhaserManagerImpl(Activity activity2) {
        this.activity = activity2;
    }

    public PhaserManagerImpl(Activity activity2, List<PhaserRegMode> phaserRegModes) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " adding phaserRegModes " + phaserRegModes + " to " + activity2);
        }
        this.phaserRegModeList = phaserRegModes;
    }

    public PhaserManagerImpl(Activity activity2, PhaserRegMode phaserRegMode) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " adding phaserRegMode " + phaserRegMode + " to " + activity2);
        }
        this.singlePhaserRegMode = phaserRegMode;
    }

    private void switchFromSingleToListStrategy() {
        this.phaserRegModeList = new LinkedList<PhaserRegMode>();
        this.phaserRegModeList.add(this.singlePhaserRegMode);
        this.singlePhaserRegMode = null;
    }

    @Override
    public List<PhaserRegMode> clonePhasers() {
        LinkedList<PhaserRegMode> l = new LinkedList<PhaserRegMode>();
        Activity current = (Activity)Runtime.getCurrentActivity();
        for (PhaserRegMode o : this.phaserRegModeList) {
            PhaserRegMode pr = current.checkPhaserUse(o);
            PhaserImpl ph = (PhaserImpl)pr.getPhaser();
            PhaserRegMode ppr = new PhaserRegMode(ph, pr.getMode());
            l.add(ppr);
        }
        return l;
    }

    @Override
    public void addPhaser(PhaserRegMode pr) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " adds " + pr + ".");
        }
        if (this.singlePhaserRegMode != null) {
            this.switchFromSingleToListStrategy();
        }
        this.phaserRegModeList.add(pr);
    }

    @Override
    public void dropPhaser(PhaserImpl ph) {
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " drops " + ph + ".");
        }
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (singlePh.equals(ph)) {
                this.singlePhaserRegMode = null;
            } else if (Report.should_report("Phaser", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + " dropPhaser attempt failed because phaser to drop is not known by the activity " + ph + ".");
            }
        } else {
            PhaserRegMode pr = null;
            for (PhaserRegMode tpr : this.phaserRegModeList) {
                PhaserImpl ph2 = (PhaserImpl)tpr.getPhaser();
                if (!ph2.equals(ph)) continue;
                pr = tpr;
                break;
            }
            if (pr != null) {
                this.phaserRegModeList.remove(pr);
            }
        }
    }

    @Override
    public void dropAllPhasers() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            singlePh.drop(this.activity);
            this.singlePhaserRegMode = null;
        } else {
            PhaserRegMode[] arr = this.phaserRegModeList.toArray(new PhaserRegMode[0]);
            for (int i = 0; i < arr.length; ++i) {
                PhaserImpl ph = (PhaserImpl)arr[i].getPhaser();
                ph.drop(this.activity);
            }
            arr = null;
            this.phaserRegModeList = null;
        }
        if (Report.should_report("Phaser", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " drops all phasers.");
        }
    }

    @Override
    public void doSignal() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".signal() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.SIG || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".signal() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.SIG && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SIG_WAIT_SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
        }
    }

    @Override
    public void doWait() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doWait() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.WAIT || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && singlePh.quiescent()) {
                singlePh.doWait();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doWait() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                PhaserImpl.Mode mode = pr.getMode();
                if (mode != PhaserImpl.Mode.WAIT && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SIG_WAIT_SINGLE || !ph.quiescent())) continue;
                ph.doWait();
            }
        }
    }

    @Override
    public void doNext() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl.Mode mode;
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext() on " + singlePh);
            }
            if ((mode = this.singlePhaserRegMode.getMode()) == PhaserImpl.Mode.SIG || (mode == PhaserImpl.Mode.SIG_WAIT || mode == PhaserImpl.Mode.SIG_WAIT_SINGLE) && !singlePh.quiescent()) {
                singlePh.signal();
            }
            if (mode != PhaserImpl.Mode.SIG) {
                singlePh.doWait();
            }
        } else {
            PhaserImpl.Mode mode;
            PhaserImpl ph;
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                mode = pr.getMode();
                if (mode != PhaserImpl.Mode.SIG && (mode != PhaserImpl.Mode.SIG_WAIT && mode != PhaserImpl.Mode.SIG_WAIT_SINGLE || ph.quiescent())) continue;
                ph.signal();
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                mode = pr.getMode();
                if (mode == PhaserImpl.Mode.SIG) continue;
                ph.doWait();
            }
        }
    }

    @Override
    public int doNext1(String loc) {
        int ret = 0;
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext1() on " + singlePh);
            }
            if (!singlePh.quiescent()) {
                singlePh.signal();
            }
            if (singlePh.doWaitSingle1(loc)) {
                ++ret;
            }
        } else {
            PhaserImpl ph;
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext1() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                if (ph.quiescent()) continue;
                ph.signal();
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                ph = (PhaserImpl)pr.getPhaser();
                if (!ph.doWaitSingle1(loc)) continue;
                ++ret;
            }
        }
        return ret;
    }

    @Override
    public void doNext2() {
        if (this.singlePhaserRegMode != null) {
            PhaserImpl singlePh = (PhaserImpl)this.singlePhaserRegMode.getPhaser();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext2() on " + singlePh);
            }
            singlePh.doWaitSingle2();
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext2() on " + this.phaserRegModeList);
            }
            for (PhaserRegMode pr : this.phaserRegModeList) {
                PhaserImpl ph = (PhaserImpl)pr.getPhaser();
                ph.doWaitSingle2();
            }
        }
    }

    @Override
    public void registerPhasers() {
        if (this.singlePhaserRegMode != null) {
            this.registerPhaser(this.singlePhaserRegMode);
        } else {
            for (PhaserRegMode pr : this.phaserRegModeList) {
                this.registerPhaser(pr);
            }
        }
    }

    private void registerPhaser(PhaserRegMode pr) {
        PhaserImpl ph = (PhaserImpl)pr.getPhaser();
        PhaserImpl.Mode mode = pr.getMode();
        ph.register(this.activity, mode);
    }

    @Override
    public PhaserImpl checkPhaserUse(PhaserImpl ph) {
        assert (false);
        return null;
    }

    @Override
    public int getNbRegisteredPhasers() {
        if (this.singlePhaserRegMode != null) {
            return 1;
        }
        if (this.phaserRegModeList != null) {
            return this.phaserRegModeList.size();
        }
        return 0;
    }

    @Override
    public List<PhaserRegMode> getPhaserRegModeList() {
        if (this.singlePhaserRegMode != null) {
            ArrayList<PhaserRegMode> l = new ArrayList<PhaserRegMode>();
            l.add(this.singlePhaserRegMode);
            return l;
        }
        return this.phaserRegModeList;
    }
}

