/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class HTTPGet {
    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.err.println("Usage: HTTPGet url filename");
            }
            boolean verbose = System.getProperty("hj.runtime.HTTPGet.verbose", "false").equals("true");
            URL src = new URL(args[0]);
            File dst = new File(args[1]);
            URLConnection source = src.openConnection();
            System.out.println(source + " => " + dst);
            long timestamp = source.getLastModified();
            if (verbose) {
                System.out.println("Source URL: " + timestamp);
                if (!dst.exists()) {
                    System.out.println("Destination file does not exist");
                } else {
                    System.out.println("Destination file: " + dst.lastModified());
                }
            }
            if (!dst.exists() || timestamp > dst.lastModified()) {
                InputStream in = source.getInputStream();
                FileOutputStream out = new FileOutputStream(dst);
                byte[] buf = new byte[2048];
                int n = 0;
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.close();
                in.close();
            } else {
                System.out.println("    Not modified - so not downloaded");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

